/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.stubbing.Scenario;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.SortedConcurrentMappingSet;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import wiremock.com.google.common.base.Optional;
import wiremock.com.google.common.base.Predicate;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.com.google.common.collect.Iterables;

public class InMemoryStubMappings
implements StubMappings {
    private final SortedConcurrentMappingSet mappings = new SortedConcurrentMappingSet();
    private final ConcurrentHashMap<String, Scenario> scenarioMap = new ConcurrentHashMap();
    private final Map<String, RequestMatcherExtension> customMatchers;
    private final Map<String, ResponseDefinitionTransformer> transformers;
    private final FileSource rootFileSource;

    public InMemoryStubMappings(Map<String, RequestMatcherExtension> customMatchers, Map<String, ResponseDefinitionTransformer> transformers, FileSource rootFileSource) {
        this.customMatchers = customMatchers;
        this.transformers = transformers;
        this.rootFileSource = rootFileSource;
    }

    public InMemoryStubMappings() {
        this(Collections.emptyMap(), Collections.emptyMap(), new SingleRootFileSource("."));
    }

    @Override
    public ServeEvent serveFor(Request request) {
        StubMapping matchingMapping = Iterables.find(this.mappings, this.mappingMatchingAndInCorrectScenarioState(request), StubMapping.NOT_CONFIGURED);
        matchingMapping.updateScenarioStateIfRequired();
        ResponseDefinition responseDefinition = this.applyTransformations(request, matchingMapping.getResponse(), ImmutableList.copyOf(this.transformers.values()));
        return ServeEvent.of(LoggedRequest.createFrom(request), ResponseDefinition.copyOf(responseDefinition), matchingMapping);
    }

    private ResponseDefinition applyTransformations(Request request, ResponseDefinition responseDefinition, List<ResponseDefinitionTransformer> transformers) {
        if (transformers.isEmpty()) {
            return responseDefinition;
        }
        ResponseDefinitionTransformer transformer = transformers.get(0);
        ResponseDefinition newResponseDef = transformer.applyGlobally() || responseDefinition.hasTransformer(transformer) ? transformer.transform(request, responseDefinition, this.rootFileSource.child("__files"), responseDefinition.getTransformerParameters()) : responseDefinition;
        return this.applyTransformations(request, newResponseDef, transformers.subList(1, transformers.size()));
    }

    @Override
    public void addMapping(StubMapping mapping) {
        this.updateSenarioMapIfPresent(mapping);
        this.mappings.add(mapping);
    }

    @Override
    public void removeMapping(StubMapping mapping) {
        this.removeFromSenarioMapIfPresent(mapping);
        this.mappings.remove(mapping);
    }

    @Override
    public void editMapping(StubMapping stubMapping) {
        Optional<StubMapping> optionalExistingMapping = Iterables.tryFind(this.mappings, this.mappingMatchingUuid(stubMapping.getUuid()));
        if (!optionalExistingMapping.isPresent()) {
            String msg = "StubMapping with UUID: " + stubMapping.getUuid() + " not found";
            LocalNotifier.notifier().error(msg);
            throw new RuntimeException(msg);
        }
        StubMapping existingMapping = optionalExistingMapping.get();
        this.updateSenarioMapIfPresent(stubMapping);
        stubMapping.setInsertionIndex(existingMapping.getInsertionIndex());
        stubMapping.setTransient(true);
        this.mappings.replace(existingMapping, stubMapping);
    }

    private void removeFromSenarioMapIfPresent(StubMapping mapping) {
        if (mapping.isInScenario()) {
            this.scenarioMap.remove(mapping.getScenarioName(), Scenario.inStartedState());
        }
    }

    private void updateSenarioMapIfPresent(StubMapping mapping) {
        if (mapping.isInScenario()) {
            this.scenarioMap.putIfAbsent(mapping.getScenarioName(), Scenario.inStartedState());
            Scenario scenario = this.scenarioMap.get(mapping.getScenarioName());
            mapping.setScenario(scenario);
        }
    }

    @Override
    public void reset() {
        this.mappings.clear();
        this.scenarioMap.clear();
    }

    @Override
    public void resetScenarios() {
        for (Scenario scenario : this.scenarioMap.values()) {
            scenario.reset();
        }
    }

    @Override
    public List<StubMapping> getAll() {
        return ImmutableList.copyOf(this.mappings);
    }

    @Override
    public Optional<StubMapping> get(final UUID id) {
        return Iterables.tryFind(this.mappings, new Predicate<StubMapping>(){

            @Override
            public boolean apply(StubMapping input) {
                return input.getUuid().equals(id);
            }
        });
    }

    private Predicate<StubMapping> mappingMatchingAndInCorrectScenarioState(Request request) {
        return this.mappingMatchingAndInCorrectScenarioStateNew(request);
    }

    private Predicate<StubMapping> mappingMatchingAndInCorrectScenarioStateNew(final Request request) {
        return new Predicate<StubMapping>(){

            @Override
            public boolean apply(StubMapping mapping) {
                return mapping.getRequest().match(request, InMemoryStubMappings.this.customMatchers).isExactMatch() && (mapping.isIndependentOfScenarioState() || mapping.requiresCurrentScenarioState());
            }
        };
    }

    private Predicate<StubMapping> mappingMatchingUuid(final UUID uuid) {
        return new Predicate<StubMapping>(){

            @Override
            public boolean apply(StubMapping input) {
                return input.getUuid().equals(uuid);
            }
        };
    }
}

