/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Xml;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3c.dom.Document;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.google.common.base.Joiner;
import wiremock.com.google.common.base.Strings;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.org.xmlunit.XMLUnitException;
import wiremock.org.xmlunit.builder.DiffBuilder;
import wiremock.org.xmlunit.builder.Input;
import wiremock.org.xmlunit.diff.Comparison;
import wiremock.org.xmlunit.diff.ComparisonControllers;
import wiremock.org.xmlunit.diff.ComparisonListener;
import wiremock.org.xmlunit.diff.ComparisonResult;
import wiremock.org.xmlunit.diff.ComparisonType;
import wiremock.org.xmlunit.diff.Diff;
import wiremock.org.xmlunit.diff.DifferenceEvaluator;

public class EqualToXmlPattern
extends StringValuePattern {
    private static List<ComparisonType> COUNTED_COMPARISONS = ImmutableList.of(ComparisonType.SCHEMA_LOCATION, ComparisonType.NO_NAMESPACE_SCHEMA_LOCATION, ComparisonType.NODE_TYPE, ComparisonType.NAMESPACE_URI, ComparisonType.TEXT_VALUE, ComparisonType.PROCESSING_INSTRUCTION_TARGET, ComparisonType.PROCESSING_INSTRUCTION_DATA, ComparisonType.ELEMENT_NUM_ATTRIBUTES, ComparisonType.ATTR_VALUE, ComparisonType.CHILD_NODELIST_LENGTH, ComparisonType.CHILD_NODELIST_SEQUENCE, ComparisonType.CHILD_LOOKUP, new ComparisonType[]{ComparisonType.ATTR_NAME_LOOKUP});
    private final Document xmlDocument;
    private static final DifferenceEvaluator IGNORE_UNCOUNTED_COMPARISONS = new DifferenceEvaluator(){

        @Override
        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            if (COUNTED_COMPARISONS.contains((Object)comparison.getType()) && comparison.getControlDetails().getValue() != null) {
                return outcome;
            }
            return ComparisonResult.EQUAL;
        }
    };

    public EqualToXmlPattern(@JsonProperty(value="equalToXml") String expectedValue) {
        super(expectedValue);
        this.xmlDocument = Xml.read(expectedValue);
    }

    public String getEqualToXml() {
        return (String)this.expectedValue;
    }

    @Override
    public String getExpected() {
        return Xml.prettyPrint((String)this.getValue());
    }

    @Override
    public MatchResult match(final String value) {
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                if (Strings.isNullOrEmpty(value)) {
                    return false;
                }
                try {
                    Diff diff = DiffBuilder.compare(Input.from(EqualToXmlPattern.this.expectedValue)).withTest(value).withComparisonController(ComparisonControllers.StopWhenDifferent).ignoreWhitespace().ignoreComments().withDifferenceEvaluator(IGNORE_UNCOUNTED_COMPARISONS).withDocumentBuilderFactory(Xml.newDocumentBuilderFactory()).build();
                    return !diff.hasDifferences();
                }
                catch (XMLUnitException e) {
                    LocalNotifier.notifier().info("Failed to process XML. " + e.getMessage() + "\nExpected:\n" + (String)EqualToXmlPattern.this.expectedValue + "\n\nActual:\n" + value);
                    return false;
                }
            }

            @Override
            public double getDistance() {
                if (Strings.isNullOrEmpty(value)) {
                    return 1.0;
                }
                final AtomicInteger totalComparisons = new AtomicInteger(0);
                final AtomicInteger differences = new AtomicInteger(0);
                Diff diff = null;
                try {
                    diff = DiffBuilder.compare(Input.from(EqualToXmlPattern.this.expectedValue)).withTest(value).ignoreWhitespace().ignoreComments().withDifferenceEvaluator(IGNORE_UNCOUNTED_COMPARISONS).withComparisonListeners(new ComparisonListener(){

                        @Override
                        public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
                            if (COUNTED_COMPARISONS.contains((Object)comparison.getType()) && comparison.getControlDetails().getValue() != null) {
                                totalComparisons.incrementAndGet();
                                if (outcome == ComparisonResult.DIFFERENT) {
                                    differences.incrementAndGet();
                                }
                            }
                        }
                    }).withDocumentBuilderFactory(Xml.newDocumentBuilderFactory()).build();
                }
                catch (XMLUnitException e) {
                    LocalNotifier.notifier().info("Failed to process XML. " + e.getMessage() + "\nExpected:\n" + (String)EqualToXmlPattern.this.expectedValue + "\n\nActual:\n" + value);
                    return 1.0;
                }
                LocalNotifier.notifier().info(Joiner.on("\n").join(diff.getDifferences()));
                return differences.doubleValue() / totalComparisons.doubleValue();
            }
        };
    }
}

