/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.jayway.jsonpath.internal.token;

import java.util.List;
import wiremock.com.jayway.jsonpath.PathNotFoundException;
import wiremock.com.jayway.jsonpath.internal.PathRef;
import wiremock.com.jayway.jsonpath.internal.Utils;
import wiremock.com.jayway.jsonpath.internal.token.EvaluationContextImpl;
import wiremock.com.jayway.jsonpath.internal.token.PathToken;

public class PropertyPathToken
extends PathToken {
    private final List<String> properties;

    public PropertyPathToken(List<String> properties) {
        this.properties = properties;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    @Override
    public void evaluate(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        if (!ctx.jsonProvider().isMap(model)) {
            throw new PathNotFoundException("Property " + this.getPathFragment() + " not found in path " + currentPath);
        }
        this.handleObjectProperty(currentPath, model, ctx, this.properties);
    }

    @Override
    boolean isTokenDefinite() {
        return true;
    }

    @Override
    public String getPathFragment() {
        return "[" + Utils.join(", ", "'", this.properties) + "]";
    }
}

