/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.common.VeryShortIdGenerator;
import com.github.tomakehurst.wiremock.standalone.MappingsSource;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import wiremock.com.google.common.base.Predicate;
import wiremock.com.google.common.collect.Iterables;

public class JsonFileMappingsSource
implements MappingsSource {
    private final FileSource mappingsFileSource;
    private final VeryShortIdGenerator idGenerator;
    private final Map<UUID, String> fileNameMap;

    public JsonFileMappingsSource(FileSource mappingsFileSource) {
        this.mappingsFileSource = mappingsFileSource;
        this.idGenerator = new VeryShortIdGenerator();
        this.fileNameMap = new HashMap<UUID, String>();
    }

    @Override
    public void saveMappings(StubMappings stubMappings) {
        Iterable<StubMapping> transientStubs = Iterables.filter(stubMappings.getAll(), new Predicate<StubMapping>(){

            @Override
            public boolean apply(StubMapping input) {
                return input != null && input.isTransient();
            }
        });
        for (StubMapping mapping : transientStubs) {
            String mappingFileName = this.fileNameMap.get(mapping.getUuid());
            if (mappingFileName == null) {
                mappingFileName = "saved-mapping-" + this.idGenerator.generate() + ".json";
            }
            this.mappingsFileSource.writeTextFile(mappingFileName, Json.write(mapping));
            mapping.setTransient(false);
        }
    }

    @Override
    public void loadMappingsInto(StubMappings stubMappings) {
        if (!this.mappingsFileSource.exists()) {
            return;
        }
        Iterable<TextFile> mappingFiles = Iterables.filter(this.mappingsFileSource.listFilesRecursively(), this.byFileExtension("json"));
        for (TextFile mappingFile : mappingFiles) {
            StubMapping mapping = StubMapping.buildFrom(mappingFile.readContentsAsString());
            mapping.setTransient(false);
            stubMappings.addMapping(mapping);
            this.fileNameMap.put(mapping.getUuid(), this.getFileName(mappingFile));
        }
    }

    private Predicate<TextFile> byFileExtension(final String extension) {
        return new Predicate<TextFile>(){

            @Override
            public boolean apply(TextFile input) {
                return input.name().endsWith("." + extension);
            }
        };
    }

    private String getFileName(TextFile mappingFile) {
        return mappingFile.getUri().toString().replaceAll("^.*/", "");
    }
}

