/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.client.LocalMappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.ScenarioMappingBuilder;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestMatcher;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.UUID;
import wiremock.com.google.common.base.Preconditions;

class MappingBuilder
implements LocalMappingBuilder,
ScenarioMappingBuilder {
    private RequestPatternBuilder requestPatternBuilder;
    private ResponseDefinitionBuilder responseDefBuilder;
    private Integer priority;
    private String scenarioName;
    protected String requiredScenarioState;
    protected String newScenarioState;
    private UUID id;

    public MappingBuilder(RequestMethod method, UrlPattern urlPattern) {
        this.requestPatternBuilder = new RequestPatternBuilder(method, urlPattern);
    }

    public MappingBuilder(RequestMatcher requestMatcher) {
        this.requestPatternBuilder = new RequestPatternBuilder(requestMatcher);
    }

    public MappingBuilder(String customRequestMatcherName, Parameters parameters) {
        this.requestPatternBuilder = new RequestPatternBuilder(customRequestMatcherName, parameters);
    }

    @Override
    public MappingBuilder willReturn(ResponseDefinitionBuilder responseDefBuilder) {
        this.responseDefBuilder = responseDefBuilder;
        return this;
    }

    @Override
    public MappingBuilder atPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public MappingBuilder withHeader(String key, StringValuePattern headerPattern) {
        this.requestPatternBuilder.withHeader(key, headerPattern);
        return this;
    }

    @Override
    public MappingBuilder withCookie(String name, StringValuePattern cookieValuePattern) {
        this.requestPatternBuilder.withCookie(name, cookieValuePattern);
        return this;
    }

    @Override
    public MappingBuilder withQueryParam(String key, StringValuePattern queryParamPattern) {
        this.requestPatternBuilder.withQueryParam(key, queryParamPattern);
        return this;
    }

    @Override
    public MappingBuilder withRequestBody(StringValuePattern bodyPattern) {
        this.requestPatternBuilder.withRequestBody(bodyPattern);
        return this;
    }

    @Override
    public MappingBuilder inScenario(String scenarioName) {
        Preconditions.checkArgument(scenarioName != null, "Scenario name must not be null");
        this.scenarioName = scenarioName;
        return this;
    }

    @Override
    public MappingBuilder whenScenarioStateIs(String stateName) {
        this.requiredScenarioState = stateName;
        return this;
    }

    @Override
    public MappingBuilder willSetStateTo(String stateName) {
        this.newScenarioState = stateName;
        return this;
    }

    @Override
    public MappingBuilder withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    public MappingBuilder withBasicAuth(String username, String password) {
        this.requestPatternBuilder.withBasicAuth(new BasicCredentials(username, password));
        return this;
    }

    @Override
    public StubMapping build() {
        if (this.scenarioName == null && (this.requiredScenarioState != null || this.newScenarioState != null)) {
            throw new IllegalStateException("Scenario name must be specified to require or set a new scenario state");
        }
        RequestPattern requestPattern = this.requestPatternBuilder.build();
        ResponseDefinition response = this.responseDefBuilder.build();
        StubMapping mapping = new StubMapping(requestPattern, response);
        mapping.setPriority(this.priority);
        mapping.setScenarioName(this.scenarioName);
        mapping.setRequiredScenarioState(this.requiredScenarioState);
        mapping.setNewScenarioState(this.newScenarioState);
        mapping.setUuid(this.id);
        return mapping;
    }
}

