/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.DispatcherType;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import wiremock.org.eclipse.jetty.io.UncheckedPrintWriter;
import wiremock.org.eclipse.jetty.servlets.GzipFilter;
import wiremock.org.eclipse.jetty.servlets.gzip.AbstractCompressedStream;
import wiremock.org.eclipse.jetty.servlets.gzip.CompressedResponseWrapper;

public class IncludableGzipFilter
extends GzipFilter {
    boolean _uncheckedPrintWriter = false;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String tmp = filterConfig.getInitParameter("uncheckedPrintWriter");
        if (tmp != null) {
            this._uncheckedPrintWriter = Boolean.valueOf(tmp);
        }
    }

    @Override
    protected CompressedResponseWrapper createWrappedResponse(HttpServletRequest request, HttpServletResponse response, final String compressionType) {
        IncludableResponseWrapper wrappedResponse = null;
        if (compressionType == null) {
            wrappedResponse = new IncludableResponseWrapper(request, response){

                @Override
                protected AbstractCompressedStream newCompressedStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
                    return new AbstractCompressedStream(null, request, this, IncludableGzipFilter.this._vary){

                        @Override
                        protected DeflaterOutputStream createStream() throws IOException {
                            return null;
                        }
                    };
                }
            };
        } else if (compressionType.equals("gzip")) {
            wrappedResponse = new IncludableResponseWrapper(request, response){

                @Override
                protected AbstractCompressedStream newCompressedStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
                    return new AbstractCompressedStream(compressionType, request, this, IncludableGzipFilter.this._vary){

                        @Override
                        protected DeflaterOutputStream createStream() throws IOException {
                            return new GZIPOutputStream((OutputStream)this._response.getOutputStream(), IncludableGzipFilter.this._bufferSize);
                        }
                    };
                }
            };
        } else if (compressionType.equals("deflate")) {
            wrappedResponse = new IncludableResponseWrapper(request, response){

                @Override
                protected AbstractCompressedStream newCompressedStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
                    return new AbstractCompressedStream(compressionType, request, this, IncludableGzipFilter.this._vary){

                        @Override
                        protected DeflaterOutputStream createStream() throws IOException {
                            return new DeflaterOutputStream((OutputStream)this._response.getOutputStream(), new Deflater(IncludableGzipFilter.this._deflateCompressionLevel, IncludableGzipFilter.this._deflateNoWrap));
                        }
                    };
                }
            };
        } else {
            throw new IllegalStateException(compressionType + " not supported");
        }
        this.configureWrappedResponse(wrappedResponse);
        return wrappedResponse;
    }

    private abstract class IncludableResponseWrapper
    extends CompressedResponseWrapper {
        public IncludableResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
            super(request, response);
        }

        @Override
        public void setHeader(String name, String value) {
            if (this.getRequest().getDispatcherType() == DispatcherType.INCLUDE) {
                if (!"etag".equalsIgnoreCase(name) && !name.startsWith("content-")) {
                    HttpServletResponse response = (HttpServletResponse)this.getResponse();
                    response.setHeader("wiremock.org.eclipse.jetty.server.include." + name, value);
                }
            } else {
                super.setHeader(name, value);
            }
        }

        @Override
        public void addHeader(String name, String value) {
            super.addHeader(name, value);
            HttpServletResponse response = (HttpServletResponse)this.getResponse();
            if (!response.containsHeader(name)) {
                this.setHeader(name, value);
            }
        }

        @Override
        protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
            if (IncludableGzipFilter.this._uncheckedPrintWriter) {
                return encoding == null ? new UncheckedPrintWriter(out) : new UncheckedPrintWriter(new OutputStreamWriter(out, encoding));
            }
            return super.newWriter(out, encoding);
        }
    }
}

