/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.AnythingPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import wiremock.com.fasterxml.jackson.annotation.JsonValue;
import wiremock.com.google.common.base.Objects;

public class UrlPattern
implements ValueMatcher<String> {
    protected final StringValuePattern pattern;
    private final boolean regex;

    public UrlPattern(StringValuePattern pattern, boolean regex) {
        this.pattern = pattern;
        this.regex = regex;
    }

    public static UrlPattern fromOneOf(String url, String urlPattern, String urlPath, String urlPathPattern) {
        if (url != null) {
            return WireMock.urlEqualTo(url);
        }
        if (urlPattern != null) {
            return WireMock.urlMatching(urlPattern);
        }
        if (urlPath != null) {
            return WireMock.urlPathEqualTo(urlPath);
        }
        if (urlPathPattern != null) {
            return WireMock.urlPathMatching(urlPathPattern);
        }
        return WireMock.anyUrl();
    }

    @Override
    public MatchResult match(String url) {
        return this.pattern.match(url);
    }

    @Override
    public String getName() {
        return this.pattern.getName();
    }

    public boolean isRegex() {
        return this.regex;
    }

    @JsonValue
    public StringValuePattern getPattern() {
        return this.pattern;
    }

    @Override
    public String getExpected() {
        return this.pattern.expectedValue;
    }

    public String toString() {
        return "path and query " + this.pattern.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlPattern that = (UrlPattern)o;
        return this.regex == that.regex && Objects.equal(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hashCode(this.pattern, this.regex);
    }

    public boolean isSpecified() {
        return this.pattern.getClass() != AnythingPattern.class;
    }
}

