/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Xml;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.xmlunit.XMLUnitException;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonControllers;
import org.xmlunit.diff.ComparisonListener;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.DifferenceEvaluator;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.google.common.base.Joiner;
import wiremock.com.google.common.collect.ImmutableList;

public class EqualToXmlPattern
extends StringValuePattern {
    private static List<ComparisonType> COUNTED_COMPARISONS = ImmutableList.of(ComparisonType.SCHEMA_LOCATION, ComparisonType.NO_NAMESPACE_SCHEMA_LOCATION, ComparisonType.NODE_TYPE, ComparisonType.NAMESPACE_URI, ComparisonType.TEXT_VALUE, ComparisonType.PROCESSING_INSTRUCTION_TARGET, ComparisonType.PROCESSING_INSTRUCTION_DATA, ComparisonType.ELEMENT_NUM_ATTRIBUTES, ComparisonType.ATTR_VALUE, ComparisonType.CHILD_NODELIST_LENGTH, ComparisonType.CHILD_NODELIST_SEQUENCE, ComparisonType.CHILD_LOOKUP, new ComparisonType[]{ComparisonType.ATTR_NAME_LOOKUP});
    private static final DifferenceEvaluator IGNORE_UNCOUNTED_COMPARISONS = new DifferenceEvaluator(){

        @Override
        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            if (COUNTED_COMPARISONS.contains((Object)comparison.getType()) && comparison.getControlDetails().getValue() != null) {
                return outcome;
            }
            return ComparisonResult.EQUAL;
        }
    };

    public EqualToXmlPattern(@JsonProperty(value="equalToXml") String expectedValue) {
        super(expectedValue);
    }

    public String getEqualToXml() {
        return this.expectedValue;
    }

    @Override
    public String getExpected() {
        return Xml.prettyPrint(this.getValue());
    }

    @Override
    public MatchResult match(final String value) {
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                try {
                    Diff diff = DiffBuilder.compare(Input.from(EqualToXmlPattern.this.expectedValue)).withTest(value).withComparisonController(ComparisonControllers.StopWhenDifferent).ignoreWhitespace().ignoreComments().withDifferenceEvaluator(IGNORE_UNCOUNTED_COMPARISONS).build();
                    return !diff.hasDifferences();
                }
                catch (XMLUnitException e) {
                    LocalNotifier.notifier().info("Failed to process XML. " + e.getMessage() + "\nExpected:\n" + EqualToXmlPattern.this.expectedValue + "\n\nActual:\n" + value);
                    return false;
                }
            }

            @Override
            public double getDistance() {
                final AtomicInteger totalComparisons = new AtomicInteger(0);
                final AtomicInteger differences = new AtomicInteger(0);
                Diff diff = DiffBuilder.compare(Input.from(EqualToXmlPattern.this.expectedValue)).withTest(value).ignoreWhitespace().ignoreComments().withDifferenceEvaluator(IGNORE_UNCOUNTED_COMPARISONS).withComparisonListeners(new ComparisonListener(){

                    @Override
                    public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
                        if (COUNTED_COMPARISONS.contains((Object)comparison.getType()) && comparison.getControlDetails().getValue() != null) {
                            totalComparisons.incrementAndGet();
                            if (outcome == ComparisonResult.DIFFERENT) {
                                differences.incrementAndGet();
                            }
                        }
                    }
                }).build();
                LocalNotifier.notifier().info(Joiner.on("\n").join(diff.getDifferences()));
                return differences.doubleValue() / totalComparisons.doubleValue();
            }
        };
    }
}

