/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.skyscreamer.jsonassert;

import wiremock.org.json.JSONArray;
import wiremock.org.json.JSONException;
import wiremock.org.json.JSONObject;
import wiremock.org.skyscreamer.jsonassert.JSONCompare;
import wiremock.org.skyscreamer.jsonassert.JSONCompareMode;
import wiremock.org.skyscreamer.jsonassert.JSONCompareResult;
import wiremock.org.skyscreamer.jsonassert.JSONParser;
import wiremock.org.skyscreamer.jsonassert.comparator.JSONComparator;

public class JSONAssert {
    private JSONAssert() {
    }

    public static void assertEquals(String expectedStr, JSONObject actual, boolean strict) throws JSONException {
        JSONAssert.assertEquals(expectedStr, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertNotEquals(String expectedStr, JSONObject actual, boolean strict) throws JSONException {
        JSONAssert.assertNotEquals(expectedStr, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertEquals(String expectedStr, JSONObject actual, JSONCompareMode compareMode) throws JSONException {
        Object expected = JSONParser.parseJSON(expectedStr);
        if (!(expected instanceof JSONObject)) {
            throw new AssertionError((Object)"Expecting a JSON array, but passing in a JSON object");
        }
        JSONAssert.assertEquals((JSONObject)expected, actual, compareMode);
    }

    public static void assertNotEquals(String expectedStr, JSONObject actual, JSONCompareMode compareMode) throws JSONException {
        Object expected = JSONParser.parseJSON(expectedStr);
        if (!(expected instanceof JSONObject)) {
            throw new AssertionError((Object)"Expecting a JSON array, but passing in a JSON object");
        }
        JSONAssert.assertNotEquals((JSONObject)expected, actual, compareMode);
    }

    public static void assertEquals(String expectedStr, JSONArray actual, boolean strict) throws JSONException {
        JSONAssert.assertEquals(expectedStr, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertNotEquals(String expectedStr, JSONArray actual, boolean strict) throws JSONException {
        JSONAssert.assertNotEquals(expectedStr, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertEquals(String expectedStr, JSONArray actual, JSONCompareMode compareMode) throws JSONException {
        Object expected = JSONParser.parseJSON(expectedStr);
        if (!(expected instanceof JSONArray)) {
            throw new AssertionError((Object)"Expecting a JSON object, but passing in a JSON array");
        }
        JSONAssert.assertEquals((JSONArray)expected, actual, compareMode);
    }

    public static void assertNotEquals(String expectedStr, JSONArray actual, JSONCompareMode compareMode) throws JSONException {
        Object expected = JSONParser.parseJSON(expectedStr);
        if (!(expected instanceof JSONArray)) {
            throw new AssertionError((Object)"Expecting a JSON object, but passing in a JSON array");
        }
        JSONAssert.assertNotEquals((JSONArray)expected, actual, compareMode);
    }

    public static void assertEquals(String expectedStr, String actualStr, boolean strict) throws JSONException {
        JSONAssert.assertEquals(expectedStr, actualStr, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertNotEquals(String expectedStr, String actualStr, boolean strict) throws JSONException {
        JSONAssert.assertNotEquals(expectedStr, actualStr, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertEquals(String expectedStr, String actualStr, JSONCompareMode compareMode) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expectedStr, actualStr, compareMode);
        if (result.failed()) {
            throw new AssertionError((Object)result.getMessage());
        }
    }

    public static void assertNotEquals(String expectedStr, String actualStr, JSONCompareMode compareMode) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expectedStr, actualStr, compareMode);
        if (result.passed()) {
            throw new AssertionError((Object)result.getMessage());
        }
    }

    public static void assertEquals(String expectedStr, String actualStr, JSONComparator comparator) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expectedStr, actualStr, comparator);
        if (result.failed()) {
            throw new AssertionError((Object)result.getMessage());
        }
    }

    public static void assertNotEquals(String expectedStr, String actualStr, JSONComparator comparator) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expectedStr, actualStr, comparator);
        if (result.passed()) {
            throw new AssertionError((Object)result.getMessage());
        }
    }

    public static void assertEquals(JSONObject expected, JSONObject actual, boolean strict) throws JSONException {
        JSONAssert.assertEquals(expected, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertNotEquals(JSONObject expected, JSONObject actual, boolean strict) throws JSONException {
        JSONAssert.assertNotEquals(expected, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertEquals(JSONObject expected, JSONObject actual, JSONCompareMode compareMode) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expected, actual, compareMode);
        if (result.failed()) {
            throw new AssertionError((Object)result.getMessage());
        }
    }

    public static void assertNotEquals(JSONObject expected, JSONObject actual, JSONCompareMode compareMode) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expected, actual, compareMode);
        if (result.passed()) {
            throw new AssertionError((Object)result.getMessage());
        }
    }

    public static void assertEquals(JSONArray expected, JSONArray actual, boolean strict) throws JSONException {
        JSONAssert.assertEquals(expected, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertNotEquals(JSONArray expected, JSONArray actual, boolean strict) throws JSONException {
        JSONAssert.assertNotEquals(expected, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertEquals(JSONArray expected, JSONArray actual, JSONCompareMode compareMode) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expected, actual, compareMode);
        if (result.failed()) {
            throw new AssertionError((Object)result.getMessage());
        }
    }

    public static void assertNotEquals(JSONArray expected, JSONArray actual, JSONCompareMode compareMode) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expected, actual, compareMode);
        if (result.passed()) {
            throw new AssertionError((Object)result.getMessage());
        }
    }
}

