/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.CustomMatcherDefinition;
import com.github.tomakehurst.wiremock.matching.RequestMatcher;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.ValuePattern;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.base.Optional;
import wiremock.com.google.common.base.Predicate;
import wiremock.com.google.common.base.Predicates;
import wiremock.com.google.common.collect.FluentIterable;
import wiremock.com.google.common.collect.ImmutableSet;
import wiremock.com.google.common.collect.Iterables;
import wiremock.com.google.common.collect.Maps;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class RequestPattern {
    private String urlPattern;
    private String url;
    private String urlPath;
    private String urlPathPattern;
    private RequestMethod method;
    private Map<String, ValuePattern> headerPatterns;
    private Map<String, ValuePattern> queryParamPatterns;
    private List<ValuePattern> bodyPatterns;
    private final RequestMatcher defaultMatcher;
    private RequestMatcher matcher;
    private CustomMatcherDefinition customMatcherDefinition;
    private static final Function<Map.Entry<String, ValuePattern>, String> TO_KEYS_WHERE_VALUE_ABSENT = new Function<Map.Entry<String, ValuePattern>, String>(){

        @Override
        public String apply(Map.Entry<String, ValuePattern> input) {
            return input.getValue().nullSafeIsAbsent() ? input.getKey() : null;
        }
    };
    private static final Predicate<String> REMOVING_NULL = new Predicate<String>(){

        @Override
        public boolean apply(String input) {
            return input != null;
        }
    };

    public RequestPattern(RequestMatcher customMatcher) {
        this.matcher = this.defaultMatcher = new RequestMatcher(){

            @Override
            public boolean isMatchedBy(Request request) {
                return RequestPattern.this.allElementsMatch(request);
            }
        };
        this.matcher = customMatcher;
    }

    public RequestPattern(String customMatcherName, Parameters matcherParameters) {
        this.matcher = this.defaultMatcher = new /* invalid duplicate definition of identical inner class */;
        this.customMatcherDefinition = new CustomMatcherDefinition(customMatcherName, matcherParameters);
    }

    public RequestPattern(RequestMethod method, String url, Map<String, ValuePattern> headerPatterns, Map<String, ValuePattern> queryParamPatterns) {
        this.matcher = this.defaultMatcher = new /* invalid duplicate definition of identical inner class */;
        this.url = url;
        this.method = method;
        this.headerPatterns = headerPatterns;
        this.queryParamPatterns = queryParamPatterns;
    }

    public RequestPattern(RequestMethod method, String url, Map<String, ValuePattern> headerPatterns) {
        this.matcher = this.defaultMatcher = new /* invalid duplicate definition of identical inner class */;
        this.url = url;
        this.method = method;
        this.headerPatterns = headerPatterns;
    }

    public RequestPattern(RequestMethod method) {
        this.matcher = this.defaultMatcher = new /* invalid duplicate definition of identical inner class */;
        this.method = method;
    }

    public RequestPattern(RequestMethod method, String url) {
        this.matcher = this.defaultMatcher = new /* invalid duplicate definition of identical inner class */;
        this.url = url;
        this.method = method;
    }

    public RequestPattern() {
        this.matcher = this.defaultMatcher = new /* invalid duplicate definition of identical inner class */;
    }

    public static RequestPattern everything() {
        RequestPattern requestPattern = new RequestPattern(RequestMethod.ANY);
        requestPattern.setUrlPattern(".*");
        return requestPattern;
    }

    public static RequestPattern buildRequestPatternFrom(String json) {
        return Json.read(json, RequestPattern.class);
    }

    private void assertIsInValidState() {
        if (FluentIterable.from(Arrays.asList(this.url, this.urlPath, this.urlPattern, this.urlPathPattern)).filter(Predicates.notNull()).size() > 1) {
            throw new IllegalStateException("Only one of url, urlPattern, urlPath or urlPathPattern may be set");
        }
    }

    public boolean isMatchedBy(Request request, Map<String, RequestMatcherExtension> customMatchers) {
        if (this.customMatcherDefinition != null) {
            RequestMatcherExtension requestMatcher = customMatchers.get(this.customMatcherDefinition.getName());
            return requestMatcher.isMatchedBy(request, this.customMatcherDefinition.getParameters());
        }
        return this.matcher.isMatchedBy(request);
    }

    public boolean isMatchedBy(Request request) {
        return this.isMatchedBy(request, Collections.emptyMap());
    }

    private boolean allElementsMatch(Request request) {
        return this.urlIsMatch(request) && this.methodMatches(request) && this.requiredAbsentHeadersAreNotPresentIn(request) && this.headersMatch(request) && this.queryParametersMatch(request) && this.bodyMatches(request);
    }

    private boolean urlIsMatch(Request request) {
        String candidateUrl = request.getUrl();
        boolean matched = this.url != null ? this.url.equals(candidateUrl) : (this.urlPattern != null ? candidateUrl.matches(this.urlPattern) : (this.urlPathPattern != null ? candidateUrl.matches(this.urlPathPattern.concat(".*")) : URI.create(candidateUrl).getPath().equals(this.urlPath)));
        return matched;
    }

    private boolean methodMatches(Request request) {
        boolean matched;
        boolean bl = matched = this.method.equals(RequestMethod.ANY) || request.getMethod().equals(this.method);
        if (!matched) {
            LocalNotifier.notifier().info(String.format("URL %s is match, but method %s is not", request.getUrl(), request.getMethod()));
        }
        return matched;
    }

    private boolean requiredAbsentHeadersAreNotPresentIn(final Request request) {
        return !Iterables.any(this.requiredAbsentHeaderKeys(), new Predicate<String>(){

            @Override
            public boolean apply(String key) {
                return request.getAllHeaderKeys().contains(key);
            }
        });
    }

    private Set<String> requiredAbsentHeaderKeys() {
        if (this.headerPatterns == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(Iterables.filter(Iterables.transform(this.headerPatterns.entrySet(), TO_KEYS_WHERE_VALUE_ABSENT), REMOVING_NULL));
    }

    private boolean headersMatch(Request request) {
        return this.noHeadersAreRequiredToBePresent() || Iterables.all(this.headerPatterns.entrySet(), RequestPattern.matchHeadersIn(request));
    }

    private boolean queryParametersMatch(Request request) {
        return this.queryParamPatterns == null || Iterables.all(this.queryParamPatterns.entrySet(), this.matchQueryParametersIn(request));
    }

    private boolean noHeadersAreRequiredToBePresent() {
        return this.headerPatterns == null || this.allHeaderPatternsSpecifyAbsent();
    }

    private boolean allHeaderPatternsSpecifyAbsent() {
        return Iterables.size(Iterables.filter(this.headerPatterns.values(), new Predicate<ValuePattern>(){

            @Override
            public boolean apply(ValuePattern headerPattern) {
                return !headerPattern.nullSafeIsAbsent();
            }
        })) == 0;
    }

    private boolean bodyMatches(Request request) {
        if (this.bodyPatterns == null) {
            return true;
        }
        boolean matches = Iterables.all(this.bodyPatterns, ValuePattern.matching(request.getBodyAsString()));
        if (!matches) {
            LocalNotifier.notifier().info(String.format("URL %s is match, but body is not: %s", request.getUrl(), request.getBodyAsString()));
        }
        return matches;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
        this.assertIsInValidState();
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public void setMethod(RequestMethod method) {
        this.method = method;
    }

    public Map<String, ValuePattern> getHeaders() {
        return this.headerPatterns;
    }

    public Map<String, ValuePattern> getQueryParameters() {
        return this.queryParamPatterns;
    }

    public CustomMatcherDefinition getCustomMatcher() {
        return this.customMatcherDefinition;
    }

    public void setCustomMatcher(CustomMatcherDefinition customMatcherDefinition) {
        this.customMatcherDefinition = customMatcherDefinition;
    }

    public void setQueryParameters(Map<String, ValuePattern> queryParamPatterns) {
        this.queryParamPatterns = queryParamPatterns;
    }

    public void addHeader(String key, ValuePattern pattern) {
        if (this.headerPatterns == null) {
            this.headerPatterns = Maps.newLinkedHashMap();
        }
        this.headerPatterns.put(key, pattern);
    }

    public void addQueryParam(String key, ValuePattern valuePattern) {
        if (this.queryParamPatterns == null) {
            this.queryParamPatterns = Maps.newLinkedHashMap();
        }
        this.queryParamPatterns.put(key, valuePattern);
    }

    public void setHeaders(Map<String, ValuePattern> headers) {
        this.headerPatterns = headers;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.assertIsInValidState();
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
        this.assertIsInValidState();
    }

    public String getUrlPathPattern() {
        return this.urlPathPattern;
    }

    public void setUrlPathPattern(String urlPathPattern) {
        this.urlPathPattern = urlPathPattern;
        this.assertIsInValidState();
    }

    public List<ValuePattern> getBodyPatterns() {
        return this.bodyPatterns;
    }

    public void setBodyPatterns(List<ValuePattern> bodyPatterns) {
        this.bodyPatterns = bodyPatterns;
    }

    @JsonIgnore
    public boolean hasCustomMatcher() {
        return this.matcher != this.defaultMatcher;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestPattern that = (RequestPattern)o;
        return Objects.equals(this.urlPattern, that.urlPattern) && Objects.equals(this.url, that.url) && Objects.equals(this.urlPath, that.urlPath) && Objects.equals(this.urlPathPattern, that.urlPathPattern) && Objects.equals(this.method, that.method) && Objects.equals(this.headerPatterns, that.headerPatterns) && Objects.equals(this.queryParamPatterns, that.queryParamPatterns) && Objects.equals(this.bodyPatterns, that.bodyPatterns);
    }

    public int hashCode() {
        return Objects.hash(this.urlPattern, this.url, this.urlPath, this.urlPathPattern, this.method, this.headerPatterns, this.queryParamPatterns, this.bodyPatterns);
    }

    public String toString() {
        return Json.write(this);
    }

    private static Predicate<Map.Entry<String, ValuePattern>> matchHeadersIn(final Request request) {
        return new Predicate<Map.Entry<String, ValuePattern>>(){

            @Override
            public boolean apply(Map.Entry<String, ValuePattern> headerPattern) {
                ValuePattern headerValuePattern = headerPattern.getValue();
                String key = headerPattern.getKey();
                HttpHeader header = request.header(key);
                boolean match = header.hasValueMatching(headerValuePattern);
                if (!match) {
                    LocalNotifier.notifier().info(String.format("URL %s is match, but header %s is not. For a match, value should %s", request.getUrl(), key, headerValuePattern.toString()));
                }
                return match;
            }
        };
    }

    private Predicate<? super Map.Entry<String, ValuePattern>> matchQueryParametersIn(final Request request) {
        return new Predicate<Map.Entry<String, ValuePattern>>(){

            @Override
            public boolean apply(Map.Entry<String, ValuePattern> entry) {
                boolean match;
                ValuePattern valuePattern = entry.getValue();
                String key = entry.getKey();
                Optional<QueryParameter> queryParam = Optional.fromNullable(request.queryParameter(key));
                boolean bl = match = queryParam.isPresent() && queryParam.get().hasValueMatching(valuePattern);
                if (!match) {
                    LocalNotifier.notifier().info(String.format("URL %s is match, but query parameter %s is not. For a match, value should %s", request.getUrl(), key, valuePattern.toString()));
                }
                return match;
            }
        };
    }
}

