/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Exceptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import wiremock.com.google.common.base.Charsets;
import wiremock.com.google.common.io.ByteStreams;

public class Gzip {
    public static byte[] unGzip(byte[] gzippedContent) {
        try {
            GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(gzippedContent));
            return ByteStreams.toByteArray(gzipInputStream);
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, byte[].class);
        }
    }

    public static String unGzipToString(byte[] gzippedContent) {
        return new String(Gzip.unGzip(gzippedContent));
    }

    public static byte[] gzip(String plainContent) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(bytes);
            gzipOutputStream.write(plainContent.getBytes(Charsets.UTF_8));
            gzipOutputStream.close();
            return bytes.toByteArray();
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, byte[].class);
        }
    }
}

