/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util;

import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;

public class IncludeExclude<ITEM> {
    private final Set<ITEM> _includes;
    private final Set<ITEM> _excludes;
    private final BiFunction<Set<ITEM>, ITEM, Boolean> _matcher;

    public IncludeExclude() {
        this(HashSet.class, null);
    }

    public <SET extends Set<ITEM>> IncludeExclude(Class<SET> setClass, BiFunction<SET, ITEM, Boolean> matcher) {
        try {
            this._includes = (Set)setClass.newInstance();
            this._excludes = (Set)setClass.newInstance();
            this._matcher = matcher;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void include(ITEM element) {
        this._includes.add(element);
    }

    public void include(ITEM ... element) {
        for (ITEM e : element) {
            this._includes.add(e);
        }
    }

    public void exclude(ITEM element) {
        this._excludes.add(element);
    }

    public void exclude(ITEM ... element) {
        for (ITEM e : element) {
            this._excludes.add(e);
        }
    }

    public boolean matches(ITEM e) {
        if (this._matcher == null) {
            if (this._includes.size() > 0 && !this._includes.contains(e)) {
                return false;
            }
            return !this._excludes.contains(e);
        }
        if (this._includes.size() > 0 && !this._matcher.apply(this._includes, e).booleanValue()) {
            return false;
        }
        return this._matcher.apply(this._excludes, e) == false;
    }

    public int size() {
        return this._includes.size() + this._excludes.size();
    }

    public Set<ITEM> getIncluded() {
        return this._includes;
    }

    public Set<ITEM> getExcluded() {
        return this._excludes;
    }

    public void clear() {
        this._includes.clear();
        this._excludes.clear();
    }

    public String toString() {
        return String.format("%s@%x{i=%s,e=%s,m=%s}", this.getClass().getSimpleName(), this.hashCode(), this._includes, this._excludes, this._matcher);
    }
}

