/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class Scenario {
    public static final String STARTED = "Started";
    private final String id;
    private final String state;
    private final Set<StubMapping> stubMappings;

    @JsonCreator
    public Scenario(@JsonProperty(value="id") String id, @JsonProperty(value="name") String ignored, @JsonProperty(value="state") String currentState, @JsonProperty(value="possibleStates") Set<String> ignored2, @JsonProperty(value="mappings") Set<StubMapping> stubMappings) {
        this.id = id;
        this.state = currentState;
        this.stubMappings = stubMappings;
    }

    private Scenario(String id, String state, Set<StubMapping> stubMappings) {
        this(id, null, state, null, stubMappings);
    }

    public static Scenario inStartedState(String name) {
        return new Scenario(name, STARTED, Collections.emptySet());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.id;
    }

    public String getState() {
        return this.state;
    }

    public Set<String> getPossibleStates() {
        FluentIterable requiredStates = FluentIterable.from(this.stubMappings).transform((Function)new Function<StubMapping, String>(){

            public String apply(StubMapping mapping) {
                return mapping.getRequiredScenarioState();
            }
        });
        return FluentIterable.from(this.stubMappings).transform((Function)new Function<StubMapping, String>(){

            public String apply(StubMapping mapping) {
                return mapping.getNewScenarioState();
            }
        }).append((Iterable)requiredStates).filter(Predicates.notNull()).toSet();
    }

    public Set<StubMapping> getMappings() {
        return this.stubMappings;
    }

    Scenario setState(String newState) {
        if (!this.getPossibleStates().contains(newState)) {
            throw new InvalidInputException(Errors.single(11, "Scenario my-scenario does not support state " + newState));
        }
        return new Scenario(this.id, newState, this.stubMappings);
    }

    Scenario reset() {
        return new Scenario(this.id, STARTED, this.stubMappings);
    }

    Scenario withStubMapping(StubMapping stubMapping) {
        ImmutableSet newMappings = ImmutableSet.builder().addAll(this.stubMappings).add((Object)stubMapping).build();
        return new Scenario(this.id, this.state, (Set<StubMapping>)newMappings);
    }

    Scenario withoutStubMapping(StubMapping stubMapping) {
        Sets.SetView newMappings = Sets.difference(this.stubMappings, (Set)ImmutableSet.of((Object)stubMapping));
        return new Scenario(this.id, this.state, (Set<StubMapping>)newMappings);
    }

    public String toString() {
        return Json.write(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scenario scenario = (Scenario)o;
        return Objects.equals(this.getId(), scenario.getId()) && Objects.equals(this.getState(), scenario.getState()) && Objects.equals(this.getMappings(), scenario.getMappings());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getState(), this.getMappings());
    }

    public static final Predicate<Scenario> withName(final String name) {
        return new Predicate<Scenario>(){

            public boolean apply(Scenario input) {
                return input.getId().equals(name);
            }
        };
    }
}

