/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.proto.storage.internal;

import com.github.tobato.fastdfs.proto.FdfsRequest;
import com.github.tobato.fastdfs.proto.ProtoHead;
import com.github.tobato.fastdfs.proto.mapper.FdfsColumn;
import java.io.InputStream;

public class StorageUploadFileRequest
extends FdfsRequest {
    private static final byte uploadCmd = 11;
    private static final byte uploadAppenderCmd = 23;
    @FdfsColumn(index=0)
    private byte storeIndex;
    @FdfsColumn(index=1)
    private long fileSize;
    @FdfsColumn(index=2, max=6)
    private String fileExtName;

    public StorageUploadFileRequest(byte storeIndex, InputStream inputStream, String fileExtName, long fileSize, boolean isAppenderFile) {
        this.inputFile = inputStream;
        this.fileSize = fileSize;
        this.storeIndex = storeIndex;
        this.fileExtName = fileExtName;
        this.head = isAppenderFile ? new ProtoHead(23) : new ProtoHead(11);
    }

    public byte getStoreIndex() {
        return this.storeIndex;
    }

    public void setStoreIndex(byte storeIndex) {
        this.storeIndex = storeIndex;
    }

    public String getFileExtName() {
        return this.fileExtName;
    }

    public void setFileExtName(String fileExtName) {
        this.fileExtName = fileExtName;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }
}

