/*
 * Decompiled with CFR 0.152.
 */
package fluflu.msgpack;

import fluflu.msgpack.MessagePacker;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction2;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MessagePacker$ {
    public static MessagePacker$ MODULE$;
    private final CharsetEncoder encoder;
    private final byte 0xc3;
    private final byte 0xc2;
    private final byte 0xcb;
    private final byte 0xcf;
    private final byte 0xce;
    private final byte 0xcd;
    private final byte 0xcc;
    private final byte 0xd0;
    private final byte 0xd1;
    private final byte 0xd2;
    private final byte 0xd3;
    private final byte 0x3d;
    private final byte 0xda;
    private final byte 0xdb;
    private final byte 0xdd;
    private final byte 0xdc;
    private final byte 0xde;
    private final byte 0xdf;
    private final byte formatNil;

    static {
        new MessagePacker$();
    }

    public CharsetEncoder encoder() {
        return this.encoder;
    }

    public final byte 0xc3() {
        return this.0xc3;
    }

    public final byte 0xc2() {
        return this.0xc2;
    }

    public final byte 0xcb() {
        return this.0xcb;
    }

    public final byte 0xcf() {
        return this.0xcf;
    }

    public final byte 0xce() {
        return this.0xce;
    }

    public final byte 0xcd() {
        return this.0xcd;
    }

    public final byte 0xcc() {
        return this.0xcc;
    }

    public final byte 0xd0() {
        return this.0xd0;
    }

    public final byte 0xd1() {
        return this.0xd1;
    }

    public final byte 0xd2() {
        return this.0xd2;
    }

    public final byte 0xd3() {
        return this.0xd3;
    }

    public final byte 0x3d() {
        return this.0x3d;
    }

    public final byte 0xda() {
        return this.0xda;
    }

    public final byte 0xdb() {
        return this.0xdb;
    }

    public final byte 0xdd() {
        return this.0xdd;
    }

    public final byte 0xdc() {
        return this.0xdc;
    }

    public final byte 0xde() {
        return this.0xde;
    }

    public final byte 0xdf() {
        return this.0xdf;
    }

    public MessagePacker apply() {
        return new MessagePacker();
    }

    public void formatArrayFamilyHeader(int size, ByteBuffer builder) {
        if (size < 16) {
            builder.put((byte)(0x90 | size));
        } else if (size < 65536) {
            builder.put(this.0xdc());
            builder.put((byte)(size >>> 8));
            builder.put((byte)(size >>> 0));
        } else {
            builder.put(this.0xdd());
            builder.put((byte)(size >>> 24));
            builder.put((byte)(size >>> 16));
            builder.put((byte)(size >>> 8));
            builder.put((byte)(size >>> 0));
        }
    }

    public void formatMapFamilyHeader(int sz, ByteBuffer builder) {
        if (sz < 16) {
            builder.put((byte)(0x80 | sz));
        } else if (sz < 65536) {
            builder.put(this.0xde());
            builder.put((byte)(sz >>> 8));
            builder.put((byte)(sz >>> 0));
        } else {
            builder.put(this.0xdf());
            builder.put((byte)(sz >>> 24));
            builder.put((byte)(sz >>> 16));
            builder.put((byte)(sz >>> 8));
            builder.put((byte)(sz >>> 0));
        }
    }

    public void formatStrFamilyHeader(int sz, ByteBuffer builder) {
        if (sz < 32) {
            builder.put((byte)(0xA0 | sz));
        } else if (sz < 65536) {
            builder.put(this.0xda());
            builder.put((byte)(sz >>> 8));
            builder.put((byte)(sz >>> 0));
        } else {
            builder.put(this.0xdb());
            builder.put((byte)(sz >>> 24));
            builder.put((byte)(sz >>> 16));
            builder.put((byte)(sz >>> 8));
            builder.put((byte)(sz >>> 0));
        }
    }

    public byte formatNil() {
        return this.formatNil;
    }

    public void formatBoolFamily(boolean v, ByteBuffer builder) {
        builder.put(v ? this.0xc3() : this.0xc2());
    }

    public void formatIntFamily(long l, ByteBuffer builder) {
        if (0x100000000L <= l) {
            this.formatLong(this.0xcf(), l, builder);
        } else if (65536L <= l) {
            this.formatInt(this.0xce(), (int)l, builder);
        } else if (256L <= l) {
            this.formatShort(this.0xcd(), (int)l, builder);
        } else if (128L <= l) {
            this.formatByte(this.0xcc(), (byte)l, builder);
        } else if (0L <= l) {
            this.formatByte((byte)l, builder);
        } else if (l >= -32L) {
            this.formatByte((byte)(0xE0L | l + 32L), builder);
        } else if (l >= (long)-128) {
            this.formatByte(this.0xd0(), (byte)l, builder);
        } else if (l >= (long)Short.MIN_VALUE) {
            this.formatShort(this.0xd1(), (int)l, builder);
        } else if (l >= (long)Integer.MIN_VALUE) {
            this.formatInt(this.0xd2(), (int)l, builder);
        } else {
            this.formatLong(this.0xd3(), l, builder);
        }
    }

    public void formatIntFamily(byte t, BigInt v, ByteBuffer builder) {
        builder.put(t);
        builder.put(v.$greater$greater(56).toByte());
        builder.put(v.$greater$greater(48).toByte());
        builder.put(v.$greater$greater(40).toByte());
        builder.put(v.$greater$greater(32).toByte());
        builder.put(v.$greater$greater(24).toByte());
        builder.put(v.$greater$greater(16).toByte());
        builder.put(v.$greater$greater(8).toByte());
        builder.put(v.$greater$greater(0).toByte());
    }

    public void formatFloatFamily(double v, ByteBuffer builder) {
        long x = Double.doubleToLongBits(v);
        builder.put(this.0xcb());
        builder.put((byte)(x >>> 56));
        builder.put((byte)(x >>> 48));
        builder.put((byte)(x >>> 40));
        builder.put((byte)(x >>> 32));
        builder.put((byte)(x >>> 24));
        builder.put((byte)(x >>> 16));
        builder.put((byte)(x >>> 8));
        builder.put((byte)(x >>> 0));
    }

    public void formatStrFamily(String v, ByteBuffer builder) {
        CharBuffer cb = CharBuffer.wrap(v);
        ByteBuffer buf = this.encoder().encode(cb);
        this.formatStrFamilyHeader(this.strSize(cb), builder);
        builder.put(buf);
        cb.clear();
    }

    public void formatByte(byte v, ByteBuffer builder) {
        builder.put(v);
    }

    public void formatByte(byte t, byte v, ByteBuffer builder) {
        builder.put(t);
        builder.put(v);
    }

    public void formatShort(byte t, int v, ByteBuffer builder) {
        builder.put(t);
        builder.put((byte)(v >>> 8));
        builder.put((byte)(v >>> 0));
    }

    public void formatInt(byte t, int v, ByteBuffer builder) {
        builder.put(t);
        builder.put((byte)(v >>> 24));
        builder.put((byte)(v >>> 16));
        builder.put((byte)(v >>> 8));
        builder.put((byte)(v >>> 0));
    }

    public void formatLong(byte t, long v, ByteBuffer builder) {
        builder.put(t);
        builder.put((byte)(v >>> 56));
        builder.put((byte)(v >>> 48));
        builder.put((byte)(v >>> 40));
        builder.put((byte)(v >>> 32));
        builder.put((byte)(v >>> 24));
        builder.put((byte)(v >>> 16));
        builder.put((byte)(v >>> 8));
        builder.put((byte)(v >>> 0));
    }

    public int strSize(CharBuffer cb) {
        return BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), cb.capacity()).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & java.io.Serializable & Serializable)(l, r) -> l + this.charSize(cb.get(r))));
    }

    public int charSize(char ch) {
        return ch < '\u0080' ? 1 : (ch < '\u0800' ? 2 : (Character.isHighSurrogate(ch) ? 2 : (Character.isLowSurrogate(ch) ? 2 : 3)));
    }

    private MessagePacker$() {
        MODULE$ = this;
        this.encoder = StandardCharsets.UTF_8.newEncoder();
        this.0xc3 = (byte)195;
        this.0xc2 = (byte)194;
        this.0xcb = (byte)203;
        this.0xcf = (byte)207;
        this.0xce = (byte)206;
        this.0xcd = (byte)205;
        this.0xcc = (byte)204;
        this.0xd0 = (byte)208;
        this.0xd1 = (byte)209;
        this.0xd2 = (byte)210;
        this.0xd3 = (byte)211;
        this.0x3d = (byte)211;
        this.0xda = (byte)218;
        this.0xdb = (byte)219;
        this.0xdd = (byte)221;
        this.0xdc = (byte)220;
        this.0xde = (byte)222;
        this.0xdf = (byte)223;
        this.formatNil = (byte)192;
    }
}

