/*
 * Decompiled with CFR 0.152.
 */
package com.tencentyun;

import com.tencentyun.Base64URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.zip.Deflater;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;

public class TLSSigAPIv2 {
    private final long sdkappid;
    private final String key;

    public TLSSigAPIv2(long sdkappid, String key) {
        this.sdkappid = sdkappid;
        this.key = key;
    }

    public String genUserSig(String userid, long expire) {
        return this.genUserSig(userid, expire, null);
    }

    public String genPrivateMapKey(String userid, long expire, long roomid, long privilegeMap) {
        byte[] userbuf = this.genUserBuf(userid, roomid, expire, privilegeMap, 0L, "");
        return this.genUserSig(userid, expire, userbuf);
    }

    public String genPrivateMapKeyWithStringRoomID(String userid, long expire, String roomstr, long privilegeMap) {
        byte[] userbuf = this.genUserBuf(userid, 0L, expire, privilegeMap, 0L, roomstr);
        return this.genUserSig(userid, expire, userbuf);
    }

    private String hmacsha256(String identifier, long currTime, long expire, String base64Userbuf) {
        String contentToBeSigned = "TLS.identifier:" + identifier + "\nTLS.sdkappid:" + this.sdkappid + "\nTLS.time:" + currTime + "\nTLS.expire:" + expire + "\n";
        if (null != base64Userbuf) {
            contentToBeSigned = contentToBeSigned + "TLS.userbuf:" + base64Userbuf + "\n";
        }
        try {
            byte[] byteKey = this.key.getBytes(StandardCharsets.UTF_8);
            Mac hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec keySpec = new SecretKeySpec(byteKey, "HmacSHA256");
            hmac.init(keySpec);
            byte[] byteSig = hmac.doFinal(contentToBeSigned.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(byteSig).replaceAll("\\s*", "");
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            return "";
        }
    }

    private String genUserSig(String userid, long expire, byte[] userbuf) {
        String sig;
        long currTime = System.currentTimeMillis() / 1000L;
        JSONObject sigDoc = new JSONObject();
        sigDoc.put("TLS.ver", (Object)"2.0");
        sigDoc.put("TLS.identifier", (Object)userid);
        sigDoc.put("TLS.sdkappid", this.sdkappid);
        sigDoc.put("TLS.expire", expire);
        sigDoc.put("TLS.time", currTime);
        String base64UserBuf = null;
        if (null != userbuf) {
            base64UserBuf = Base64.getEncoder().encodeToString(userbuf).replaceAll("\\s*", "");
            sigDoc.put("TLS.userbuf", (Object)base64UserBuf);
        }
        if ((sig = this.hmacsha256(userid, currTime, expire, base64UserBuf)).length() == 0) {
            return "";
        }
        sigDoc.put("TLS.sig", (Object)sig);
        Deflater compressor = new Deflater();
        compressor.setInput(sigDoc.toString().getBytes(StandardCharsets.UTF_8));
        compressor.finish();
        byte[] compressedBytes = new byte[2048];
        int compressedBytesLength = compressor.deflate(compressedBytes);
        compressor.end();
        return new String(Base64URL.base64EncodeUrl(Arrays.copyOfRange(compressedBytes, 0, compressedBytesLength))).replaceAll("\\s*", "");
    }

    public byte[] genUserBuf(String account, long dwAuthID, long dwExpTime, long dwPrivilegeMap, long dwAccountType, String RoomStr) {
        int accountLength = account.length();
        int roomStrLength = RoomStr.length();
        int offset = 0;
        int bufLength = 3 + accountLength + 20;
        if (roomStrLength > 0) {
            bufLength = bufLength + 2 + roomStrLength;
        }
        byte[] userbuf = new byte[bufLength];
        userbuf[offset++] = roomStrLength > 0 ? (byte)1 : 0;
        userbuf[offset++] = (byte)((accountLength & 0xFF00) >> 8);
        userbuf[offset++] = (byte)(accountLength & 0xFF);
        while (offset < 3 + accountLength) {
            userbuf[offset] = (byte)account.charAt(offset - 3);
            ++offset;
        }
        userbuf[offset++] = (byte)((this.sdkappid & 0xFFFFFFFFFF000000L) >> 24);
        userbuf[offset++] = (byte)((this.sdkappid & 0xFF0000L) >> 16);
        userbuf[offset++] = (byte)((this.sdkappid & 0xFF00L) >> 8);
        userbuf[offset++] = (byte)(this.sdkappid & 0xFFL);
        userbuf[offset++] = (byte)((dwAuthID & 0xFFFFFFFFFF000000L) >> 24);
        userbuf[offset++] = (byte)((dwAuthID & 0xFF0000L) >> 16);
        userbuf[offset++] = (byte)((dwAuthID & 0xFF00L) >> 8);
        userbuf[offset++] = (byte)(dwAuthID & 0xFFL);
        long currTime = System.currentTimeMillis() / 1000L;
        long expire = currTime + dwExpTime;
        userbuf[offset++] = (byte)((expire & 0xFFFFFFFFFF000000L) >> 24);
        userbuf[offset++] = (byte)((expire & 0xFF0000L) >> 16);
        userbuf[offset++] = (byte)((expire & 0xFF00L) >> 8);
        userbuf[offset++] = (byte)(expire & 0xFFL);
        userbuf[offset++] = (byte)((dwPrivilegeMap & 0xFFFFFFFFFF000000L) >> 24);
        userbuf[offset++] = (byte)((dwPrivilegeMap & 0xFF0000L) >> 16);
        userbuf[offset++] = (byte)((dwPrivilegeMap & 0xFF00L) >> 8);
        userbuf[offset++] = (byte)(dwPrivilegeMap & 0xFFL);
        userbuf[offset++] = (byte)((dwAccountType & 0xFFFFFFFFFF000000L) >> 24);
        userbuf[offset++] = (byte)((dwAccountType & 0xFF0000L) >> 16);
        userbuf[offset++] = (byte)((dwAccountType & 0xFF00L) >> 8);
        userbuf[offset++] = (byte)(dwAccountType & 0xFFL);
        if (roomStrLength > 0) {
            userbuf[offset++] = (byte)((roomStrLength & 0xFF00) >> 8);
            userbuf[offset++] = (byte)(roomStrLength & 0xFF);
            while (offset < bufLength) {
                userbuf[offset] = (byte)RoomStr.charAt(offset - (bufLength - roomStrLength));
                ++offset;
            }
        }
        return userbuf;
    }
}

