/*
 * Decompiled with CFR 0.152.
 */
package com.github.timm.cucumber.generate;

import com.github.timm.cucumber.generate.CucumberITGenerator;
import com.github.timm.cucumber.generate.FileGeneratorConfig;
import com.github.timm.cucumber.generate.OverriddenCucumberOptionsParameters;
import com.github.timm.cucumber.generate.filter.TagFilter;
import com.github.timm.cucumber.generate.name.ClassNamingScheme;
import gherkin.AstBuilder;
import gherkin.Parser;
import gherkin.TokenMatcher;
import gherkin.ast.Feature;
import gherkin.ast.Location;
import gherkin.ast.Node;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CucumberITGeneratorByScenario
implements CucumberITGenerator {
    private final FileGeneratorConfig config;
    private final OverriddenCucumberOptionsParameters overriddenParameters;
    int fileCounter = 1;
    private String featureFileLocation;
    private Template velocityTemplate;
    private String outputFileName;
    private final ClassNamingScheme classNamingScheme;

    public CucumberITGeneratorByScenario(FileGeneratorConfig config, OverriddenCucumberOptionsParameters overriddenParameters, ClassNamingScheme classNamingScheme) {
        this.config = config;
        this.overriddenParameters = overriddenParameters;
        this.classNamingScheme = classNamingScheme;
        this.initTemplate();
    }

    private void initTemplate() {
        Properties props = new Properties();
        props.put("resource.loader", "class");
        props.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        VelocityEngine engine = new VelocityEngine(props);
        engine.init();
        this.velocityTemplate = this.config.useTestNG() ? engine.getTemplate("cucumber-testng-runner.vm", this.config.getEncoding()) : engine.getTemplate("cucumber-junit-runner.vm", this.config.getEncoding());
    }

    @Override
    public void generateCucumberITFiles(File outputDirectory, Collection<File> featureFiles) throws MojoExecutionException {
        Parser parser = new Parser((Parser.Builder)new AstBuilder());
        Feature feature = null;
        TagFilter tagFilter = new TagFilter(this.overriddenParameters.getTags());
        for (File file : featureFiles) {
            try {
                feature = (Feature)parser.parse((Reader)new FileReader(file), (Parser.ITokenMatcher)new TokenMatcher());
            }
            catch (FileNotFoundException e) {
                System.out.println(String.format("WARNING: Failed to parse '%s'...IGNORING", file.getName()));
            }
            Collection<Node> matchingScenariosAndExamples = tagFilter.matchingScenariosAndExamples(feature);
            for (Node match : matchingScenariosAndExamples) {
                this.outputFileName = this.classNamingScheme.generate(file.getName());
                this.setFeatureFileLocation(file, match.getLocation());
                this.writeFile(outputDirectory);
            }
        }
    }

    private void writeFile(File outputDirectory) throws MojoExecutionException {
        File outputFile = new File(outputDirectory, this.outputFileName + ".java");
        FileWriter w = null;
        try {
            w = new FileWriter(outputFile);
            this.writeContentFromTemplate(w);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating file " + outputFile, (Exception)e);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException e) {
                    System.out.println("Failed to close file: " + outputFile);
                }
            }
        }
        ++this.fileCounter;
    }

    private void setFeatureFileLocation(File file, Location location) {
        this.featureFileLocation = file.getPath().replace(File.separatorChar, '/').concat(":" + location.getLine());
    }

    private void writeContentFromTemplate(Writer writer) {
        VelocityContext context = new VelocityContext();
        context.put("strict", (Object)this.overriddenParameters.isStrict());
        context.put("featureFile", (Object)this.featureFileLocation);
        context.put("reports", (Object)this.createFormatStrings());
        context.put("tags", (Object)this.overriddenParameters.getTags());
        context.put("monochrome", (Object)this.overriddenParameters.isMonochrome());
        context.put("cucumberOutputDir", (Object)this.config.getCucumberOutputDir());
        context.put("glue", (Object)this.quoteGlueStrings());
        context.put("className", (Object)FilenameUtils.removeExtension((String)this.outputFileName));
        this.velocityTemplate.merge((Context)context, writer);
    }

    private String createFormatStrings() {
        String[] formatStrs = this.overriddenParameters.getFormat().split(",");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < formatStrs.length; ++i) {
            String formatStr = formatStrs[i].trim();
            if ("pretty".equalsIgnoreCase(formatStr)) {
                sb.append("\"pretty\"");
            } else {
                sb.append(String.format("\"%s:%s/%s.%s\"", formatStr, this.config.getCucumberOutputDir().replace('\\', '/'), this.fileCounter, formatStr));
            }
            if (i >= formatStrs.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private String quoteGlueStrings() {
        String[] packageStrs = this.overriddenParameters.getGlue().split(",");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < packageStrs.length; ++i) {
            String packageStr = packageStrs[i];
            sb.append(String.format("\"%s\"", packageStr.trim()));
            if (i >= packageStrs.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

