/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.ratelimiter.core;

import com.taptap.ratelimiter.core.RateLimiter;
import com.taptap.ratelimiter.model.LuaScript;
import com.taptap.ratelimiter.model.Result;
import com.taptap.ratelimiter.model.Rule;
import java.util.Collections;
import java.util.List;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.springframework.beans.factory.annotation.Qualifier;

public class TimeWindowRateLimiter
implements RateLimiter {
    private final RScript rScript;

    public TimeWindowRateLimiter(@Qualifier(value="rateLimiterRedissonBeanName") RedissonClient client) {
        this.rScript = client.getScript((Codec)LongCodec.INSTANCE);
    }

    @Override
    public Result isAllowed(Rule rule) {
        List<Object> keys = TimeWindowRateLimiter.getKeys(rule.getKey());
        String script = LuaScript.getTimeWindowRateLimiterScript();
        List results = (List)this.rScript.eval(RScript.Mode.READ_WRITE, script, RScript.ReturnType.MULTI, keys, new Object[]{rule.getRate(), rule.getRateInterval()});
        boolean isAllowed = (Long)results.get(0) == 1L;
        long ttl = (Long)results.get(1);
        return new Result(isAllowed, ttl);
    }

    static List<Object> getKeys(String key) {
        String prefix = "request_rate_limiter.{" + key;
        String keys = prefix + "}";
        return Collections.singletonList(keys);
    }
}

