/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.ratelimiter.core;

import com.taptap.ratelimiter.core.RateLimiter;
import com.taptap.ratelimiter.core.TimeWindowRateLimiter;
import com.taptap.ratelimiter.core.TokenBucketRateLimiter;
import com.taptap.ratelimiter.model.Mode;
import com.taptap.ratelimiter.model.Result;
import com.taptap.ratelimiter.model.Rule;
import java.util.HashMap;
import java.util.Map;
import org.redisson.api.RedissonClient;

public class RateLimiterService {
    private static final Map<Mode, RateLimiter> RATE_LIMITER_FACTORY = new HashMap<Mode, RateLimiter>();

    public RateLimiterService(RedissonClient redissonClient) {
        RATE_LIMITER_FACTORY.put(Mode.TIME_WINDOW, new TimeWindowRateLimiter(redissonClient));
        RATE_LIMITER_FACTORY.put(Mode.TOKEN_BUCKET, new TokenBucketRateLimiter(redissonClient));
    }

    public Result isAllowed(Rule rule) {
        RateLimiter rateLimiter = RATE_LIMITER_FACTORY.get((Object)rule.getMode());
        return rateLimiter.isAllowed(rule);
    }
}

