/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.cropme;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.MainThread;
import com.takusemba.cropme.CircleCropOverlay;
import com.takusemba.cropme.CropImageView;
import com.takusemba.cropme.CropLayout;
import com.takusemba.cropme.CropOverlay;
import com.takusemba.cropme.NoneCropOverlay;
import com.takusemba.cropme.OnCropListener;
import com.takusemba.cropme.R;
import com.takusemba.cropme.RectangleCropOverlay;
import com.takusemba.cropme.internal.GestureAnimation;
import com.takusemba.cropme.internal.GestureAnimator;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011J\b\u0010\u0015\u001a\u00020\u0013H\u0007J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/takusemba/cropme/CropLayout;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "cropImageView", "Lcom/takusemba/cropme/CropImageView;", "cropOverlay", "Lcom/takusemba/cropme/CropOverlay;", "frameCache", "Landroid/graphics/RectF;", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/takusemba/cropme/OnCropListener;", "addOnCropListener", "", "listener", "crop", "isOffFrame", "", "removeOnCropListener", "setBitmap", "bitmap", "Landroid/graphics/Bitmap;", "setUri", "uri", "Landroid/net/Uri;", "Companion", "cropme_release"})
public final class CropLayout
extends FrameLayout {
    private final CropImageView cropImageView;
    private final CropOverlay cropOverlay;
    private RectF frameCache;
    private final CopyOnWriteArrayList<OnCropListener> listeners;
    private static final String TAG = "CropLayout";
    private static final int OVERLAY_SHAPE_NONE = 0;
    private static final int OVERLAY_SHAPE_RECTANGLE = 1;
    private static final int OVERLAY_SHAPE_CIRCLE = 2;
    private static final int OVERLAY_SHAPE_CUSTOM = 3;
    private static final int DEFAULT_OVERLAY_SHAPE = 1;
    private static final float DEFAULT_MAX_SCALE = 2.0f;
    private static final int DEFAULT_BASE = 1;
    private static final int DEFAULT_PBASE = 1;
    private static final float DEFAULT_PERCENT_WIDTH = 0.8f;
    private static final float DEFAULT_PERCENT_HEIGHT = 0.8f;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void setUri(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.cropImageView.setImageURI(uri);
        this.cropImageView.requestLayout();
    }

    public final void setBitmap(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.cropImageView.setImageBitmap(bitmap);
        this.cropImageView.requestLayout();
    }

    public final void addOnCropListener(@NotNull OnCropListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.addIfAbsent(listener);
    }

    public final void removeOnCropListener(@NotNull OnCropListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.addIfAbsent(listener);
    }

    public final boolean isOffFrame() {
        RectF rectF = this.frameCache;
        if (rectF == null) {
            return false;
        }
        RectF frameRect = rectF;
        Rect targetRect = new Rect();
        this.cropImageView.getHitRect(targetRect);
        double d = frameRect.left;
        boolean bl = false;
        int n = (int)Math.ceil(d);
        d = frameRect.top;
        bl = false;
        int n2 = (int)Math.ceil(d);
        d = frameRect.right;
        bl = false;
        int n3 = (int)Math.floor(d);
        d = frameRect.bottom;
        bl = false;
        return !targetRect.contains(n, n2, n3, (int)Math.floor(d));
    }

    @MainThread
    public final void crop() {
        if (this.isOffFrame()) {
            Log.w((String)TAG, (String)"Image is off the frame.");
            return;
        }
        RectF rectF = this.frameCache;
        if (rectF == null) {
            return;
        }
        RectF frame = rectF;
        Handler mainHandler = new Handler(Looper.getMainLooper());
        Rect rect = new Rect();
        boolean bl = false;
        boolean bl2 = false;
        Rect $this$apply = rect;
        boolean bl3 = false;
        this.cropImageView.getHitRect($this$apply);
        Rect targetRect = rect;
        Drawable drawable = this.cropImageView.getDrawable();
        if (drawable == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.BitmapDrawable");
        }
        Bitmap source = ((BitmapDrawable)drawable).getBitmap();
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this, source, targetRect, frame, mainHandler){
            final /* synthetic */ CropLayout this$0;
            final /* synthetic */ Bitmap $source;
            final /* synthetic */ Rect $targetRect;
            final /* synthetic */ RectF $frame;
            final /* synthetic */ Handler $mainHandler;

            public final void invoke() {
                Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)this.$source, (int)this.$targetRect.width(), (int)this.$targetRect.height(), (boolean)false);
                int leftOffset = (int)(this.$frame.left - (float)this.$targetRect.left);
                int topOffset = (int)(this.$frame.top - (float)this.$targetRect.top);
                int width = (int)this.$frame.width();
                int height = (int)this.$frame.height();
                try {
                    Bitmap result = Bitmap.createBitmap((Bitmap)bitmap, (int)leftOffset, (int)topOffset, (int)width, (int)height);
                    this.$mainHandler.post(new Runnable(this, result){
                        final /* synthetic */ crop.1 this$0;
                        final /* synthetic */ Bitmap $result;

                        public final void run() {
                            for (OnCropListener listener : CropLayout.access$getListeners$p(this.this$0.this$0)) {
                                Bitmap bitmap = this.$result;
                                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"result");
                                listener.onSuccess(bitmap);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$result = bitmap;
                        }
                    });
                }
                catch (Exception e) {
                    for (OnCropListener listener : CropLayout.access$getListeners$p(this.this$0)) {
                        listener.onFailure(e);
                    }
                }
            }
            {
                this.this$0 = cropLayout;
                this.$source = bitmap;
                this.$targetRect = rect;
                this.$frame = rectF;
                this.$mainHandler = handler;
                super(0);
            }
        }), (int)31, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public CropLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.listeners = new CopyOnWriteArrayList();
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CropLayout, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026yleable.CropLayout, 0, 0)");
        TypedArray a = typedArray;
        final float percentWidth = 0.0f;
        final float percentHeight = 0.0f;
        final float scale = 0.0f;
        try {
            CropOverlay cropOverlay;
            CropImageView defaultCropImageView = new CropImageView(context, null, 0);
            defaultCropImageView.setId(R.id.cropme_image_view);
            defaultCropImageView.setScaleType(ImageView.ScaleType.FIT_XY);
            defaultCropImageView.setAdjustViewBounds(true);
            defaultCropImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
            this.addView((View)defaultCropImageView, 0);
            this.cropImageView = defaultCropImageView;
            int overlayShape = a.getInt(R.styleable.CropLayout_cropme_overlay_shape, 1);
            switch (overlayShape) {
                case 0: {
                    cropOverlay = new NoneCropOverlay(context, null, 0, attrs);
                    break;
                }
                case 1: {
                    cropOverlay = new RectangleCropOverlay(context, null, 0, attrs);
                    break;
                }
                case 2: {
                    cropOverlay = new CircleCropOverlay(context, null, 0, attrs);
                    break;
                }
                case 3: {
                    int layoutId = a.getResourceId(R.styleable.CropLayout_cropme_custom_shape_layout, -1);
                    View view = LayoutInflater.from((Context)context).inflate(layoutId, null);
                    View view2 = view.findViewById(R.id.cropme_overlay);
                    Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view.findViewById(R.id.cropme_overlay)");
                    cropOverlay = (CropOverlay)view2;
                    break;
                }
                default: {
                    cropOverlay = new RectangleCropOverlay(context, null, 0, attrs);
                }
            }
            CropOverlay defaultCropOverlay = cropOverlay;
            defaultCropOverlay.setId(R.id.cropme_overlay);
            defaultCropOverlay.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            this.addView((View)defaultCropOverlay, 1);
            this.cropOverlay = defaultCropOverlay;
            scale = a.getFloat(R.styleable.CropLayout_cropme_max_scale, 2.0f);
            percentWidth = a.getFraction(R.styleable.CropLayout_cropme_frame_width_percent, 1, 1, 0.8f);
            percentHeight = a.getFraction(R.styleable.CropLayout_cropme_frame_height_percent, 1, 1, 0.8f);
        }
        finally {
            a.recycle();
        }
        final ViewTreeObserver vto = this.getViewTreeObserver();
        vto.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                float totalWidth = this.getMeasuredWidth();
                float totalHeight = this.getMeasuredHeight();
                float frameWidth = (float)this.getMeasuredWidth() * percentWidth;
                float frameHeight = (float)this.getMeasuredHeight() * percentHeight;
                RectF frame = new RectF((totalWidth - frameWidth) / 2.0f, (totalHeight - frameHeight) / 2.0f, (totalWidth + frameWidth) / 2.0f, (totalHeight + frameHeight) / 2.0f);
                cropImageView.setFrame(frame);
                cropImageView.requestLayout();
                cropOverlay.setFrame(frame);
                cropOverlay.requestLayout();
                frameCache = frame;
                GestureAnimator animator = GestureAnimator.Companion.of((View)cropImageView, frame, scale);
                GestureAnimation animation = new GestureAnimation((View)cropOverlay, animator);
                animation.start();
                ViewTreeObserver viewTreeObserver = vto;
                Intrinsics.checkNotNullExpressionValue((Object)viewTreeObserver, (String)"vto");
                if (viewTreeObserver.isAlive()) {
                    vto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                } else {
                    cropOverlay.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                }
                return true;
            }
        });
    }

    public /* synthetic */ CropLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CropLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CropLayout(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getListeners$p(CropLayout $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ RectF access$getFrameCache$p(CropLayout $this) {
        return $this.frameCache;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/takusemba/cropme/CropLayout$Companion;", "", "()V", "DEFAULT_BASE", "", "DEFAULT_MAX_SCALE", "", "DEFAULT_OVERLAY_SHAPE", "DEFAULT_PBASE", "DEFAULT_PERCENT_HEIGHT", "DEFAULT_PERCENT_WIDTH", "OVERLAY_SHAPE_CIRCLE", "OVERLAY_SHAPE_CUSTOM", "OVERLAY_SHAPE_NONE", "OVERLAY_SHAPE_RECTANGLE", "TAG", "", "OverlayShape", "cropme_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Retention(value=AnnotationRetention.SOURCE)
        @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/takusemba/cropme/CropLayout$Companion$OverlayShape;", "", "cropme_release"})
        public static @interface OverlayShape {
        }
    }
}

