/*
 * Decompiled with CFR 0.152.
 */
package com.github.sylvainlaurent.maven.yamljsonvalidator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.Dereferencing;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.load.download.URIDownloader;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.sylvainlaurent.maven.yamljsonvalidator.ValidationResult;
import com.github.sylvainlaurent.maven.yamljsonvalidator.downloader.ClasspathDownloader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ValidationService {
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final JsonSchema schema;
    private final boolean isEmptyFileAllowed;

    public ValidationService(InputStream schemaFile, boolean isEmptyFileAllowed, boolean detectDuplicateKeys, boolean allowJsonComments, boolean allowTrailingComma) {
        this.schema = this.getJsonSchema(schemaFile);
        this.isEmptyFileAllowed = isEmptyFileAllowed;
        if (detectDuplicateKeys) {
            this.jsonMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION});
            this.yamlMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION});
        }
        if (allowJsonComments) {
            this.jsonMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
        }
        if (allowTrailingComma) {
            this.jsonMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_TRAILING_COMMA});
            this.yamlMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_TRAILING_COMMA});
        }
    }

    public ValidationService(InputStream schemaFile) {
        this(schemaFile, false, true, false, false);
    }

    public ValidationResult validate(File file) {
        JsonNode spec;
        ValidationResult validationResult = new ValidationResult();
        if (this.isEmptyFileAllowed && this.isFileEmpty(file)) {
            return validationResult;
        }
        try {
            spec = this.readFileContent(file);
            if (spec == null && !this.isEmptyFileAllowed) {
                validationResult.addMessage("Empty file is not valid: " + file);
                validationResult.encounteredError();
                return validationResult;
            }
        }
        catch (Exception e) {
            validationResult.addMessage("Error while parsing file " + file + ": " + e.getMessage());
            validationResult.encounteredError();
            return validationResult;
        }
        this.validateAgainstSchema(spec, validationResult);
        return validationResult;
    }

    private boolean isFileEmpty(File file) {
        return file.length() == 0L;
    }

    private void validateAgainstSchema(JsonNode spec, ValidationResult validationResult) {
        if (this.schema == null) {
            return;
        }
        try {
            ProcessingReport report = this.schema.validate(spec);
            if (!report.isSuccess()) {
                validationResult.encounteredError();
            }
            for (ProcessingMessage processingMessage : report) {
                validationResult.addMessage(processingMessage.toString());
            }
        }
        catch (ProcessingException e) {
            validationResult.addMessage(e.getMessage());
            validationResult.encounteredError();
        }
    }

    private JsonSchema getJsonSchema(InputStream schemaFile) {
        JsonSchema jsonSchema;
        if (schemaFile == null) {
            return null;
        }
        try {
            LoadingConfiguration loadingConfiguration = LoadingConfiguration.newBuilder().addScheme("classpath", (URIDownloader)new ClasspathDownloader()).dereferencing(Dereferencing.INLINE).freeze();
            JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().setLoadingConfiguration(loadingConfiguration).freeze();
            JsonNode schemaObject = this.jsonMapper.readTree(schemaFile);
            jsonSchema = factory.getJsonSchema(schemaObject);
        }
        catch (ProcessingException | IOException e) {
            throw new RuntimeException(e);
        }
        return jsonSchema;
    }

    private JsonNode readFileContent(File file) throws IOException {
        String fileName = file.getName().toLowerCase();
        if (fileName.endsWith(".yml") || fileName.endsWith(".yaml")) {
            return this.yamlMapper.readTree(file);
        }
        return this.jsonMapper.readTree(file);
    }
}

