/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.logger;

import ch.sla.jdbcperflogger.Logger;
import ch.sla.jdbcperflogger.logger.PerfLoggerRemoting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.TimeUnit;

class PerfLoggerClientThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(PerfLoggerClientThread.class);
    private static final int CONNECT_TIMEOUT_MS = 30000;
    boolean done;
    private final InetSocketAddress socketAddress;

    static PerfLoggerClientThread spawn(final InetSocketAddress socketAddress) {
        return AccessController.doPrivileged(new PrivilegedAction<PerfLoggerClientThread>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PerfLoggerClientThread run() {
                ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(null);
                    PerfLoggerClientThread thread = new PerfLoggerClientThread(socketAddress);
                    thread.start();
                    PerfLoggerClientThread perfLoggerClientThread = thread;
                    return perfLoggerClientThread;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(savedClassLoader);
                }
            }
        });
    }

    private PerfLoggerClientThread(InetSocketAddress socketAddress) {
        this.setDaemon(true);
        this.setName("PerfLoggerClient " + socketAddress);
        this.socketAddress = socketAddress;
    }

    @Override
    public void run() {
        while (!this.done) {
            Socket socket;
            try {
                InetSocketAddress resolvedAddress = new InetSocketAddress(this.socketAddress.getHostName(), this.socketAddress.getPort());
                socket = new Socket();
                socket.connect(resolvedAddress, 30000);
            }
            catch (IOException e) {
                LOGGER.debug("Unable to connect to " + this.socketAddress + ", will try again later", e);
                this.quietSleep(30);
                continue;
            }
            LOGGER.debug("Connected to " + this.socketAddress);
            try {
                PerfLoggerRemoting.LogSender sender = new PerfLoggerRemoting.LogSender(socket);
                PerfLoggerRemoting.senders.add(sender);
                sender.run();
            }
            catch (IOException e) {
                LOGGER.info("Error in connection with " + this.socketAddress + ", will try again later", e);
            }
        }
    }

    private void quietSleep(int seconds) {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(seconds));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

