/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.driver;

import ch.sla.jdbcperflogger.DatabaseType;
import ch.sla.jdbcperflogger.StatementType;
import ch.sla.jdbcperflogger.driver.LoggingResultSetInvocationHandler;
import ch.sla.jdbcperflogger.driver.Utils;
import ch.sla.jdbcperflogger.logger.PerfLogger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public class LoggingStatementInvocationHandler
implements InvocationHandler {
    protected static final String CLEAR_BATCH = "clearBatch";
    protected static final String ADD_BATCH = "addBatch";
    protected static final String EXECUTE_BATCH = "executeBatch";
    protected static final String EXECUTE_LARGE_BATCH = "executeLargeBatch";
    protected static final String EXECUTE_UPDATE = "executeUpdate";
    protected static final String EXECUTE_LARGE_UPDATE = "executeLargeUpdate";
    protected static final String EXECUTE = "execute";
    protected static final String EXECUTE_QUERY = "executeQuery";
    protected UUID connectionId;
    protected final DatabaseType databaseType;
    protected final Statement wrappedStatement;
    private final List<String> batchedNonPreparedStmtExecutions = new ArrayList<String>();

    LoggingStatementInvocationHandler(UUID connectionId, Statement statement, DatabaseType databaseType) {
        this.connectionId = connectionId;
        this.wrappedStatement = statement;
        this.databaseType = databaseType;
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object _proxy, @Nullable Method _method, @Nullable Object[] args) throws Throwable {
        assert (_method != null);
        Method method = _method;
        String methodName = method.getName();
        if (EXECUTE_QUERY.equals(methodName) && args != null) {
            return this.internalExecuteQuery(method, args);
        }
        if ((EXECUTE.equals(methodName) || EXECUTE_UPDATE.equals(methodName) || EXECUTE_LARGE_UPDATE.equals(methodName)) && args != null) {
            return this.internalExecute(method, args);
        }
        if (EXECUTE_BATCH.equals(methodName) || EXECUTE_LARGE_BATCH.equals(methodName)) {
            return this.internalExecuteBatch(method, args);
        }
        Object result = Utils.invokeUnwrapException(this.wrappedStatement, method, args);
        if (ADD_BATCH.equals(methodName) && args != null) {
            this.batchedNonPreparedStmtExecutions.add((String)args[0]);
        } else if (CLEAR_BATCH.equals(methodName)) {
            this.batchedNonPreparedStmtExecutions.clear();
        }
        return result;
    }

    protected final ResultSet internalExecuteQuery(Method method, Object[] args) throws Throwable {
        UUID logId = UUID.randomUUID();
        long start = System.nanoTime();
        PerfLogger.logBeforeStatement(this.connectionId, logId, (String)args[0], StatementType.NON_PREPARED_QUERY_STMT, this.wrappedStatement.getQueryTimeout(), this.wrappedStatement.getConnection().getAutoCommit());
        Throwable exc = null;
        try {
            ResultSet resultSet = (ResultSet)Utils.invokeUnwrapExceptionReturnNonNull(this.wrappedStatement, method, args);
            ResultSet resultSet2 = (ResultSet)Proxy.newProxyInstance(LoggingStatementInvocationHandler.class.getClassLoader(), Utils.extractAllInterfaces(resultSet.getClass()), (InvocationHandler)new LoggingResultSetInvocationHandler(resultSet, logId));
            return resultSet2;
        }
        catch (Throwable e) {
            exc = e;
            throw exc;
        }
        finally {
            long end = System.nanoTime();
            PerfLogger.logStatementExecuted(logId, end - start, null, exc);
        }
    }

    @Nullable
    protected final Object internalExecute(Method method, Object[] args) throws Throwable {
        Object object;
        UUID logId = UUID.randomUUID();
        PerfLogger.logBeforeStatement(this.connectionId, logId, (String)args[0], StatementType.BASE_NON_PREPARED_STMT, this.wrappedStatement.getQueryTimeout(), this.wrappedStatement.getConnection().getAutoCommit());
        Throwable exc = null;
        Long updateCount = null;
        long start = System.nanoTime();
        try {
            Object result = Utils.invokeUnwrapException(this.wrappedStatement, method, args);
            if (result instanceof Number) {
                updateCount = ((Number)result).longValue();
            }
            object = result;
        }
        catch (Throwable e) {
            try {
                exc = e;
                throw exc;
            }
            catch (Throwable throwable) {
                long end = System.nanoTime();
                PerfLogger.logStatementExecuted(logId, end - start, updateCount, exc);
                throw throwable;
            }
        }
        long end = System.nanoTime();
        PerfLogger.logStatementExecuted(logId, end - start, updateCount, exc);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Object internalExecuteBatch(Method method, @Nullable Object[] args) throws Throwable {
        UUID logId = UUID.randomUUID();
        PerfLogger.logNonPreparedBatchedStatements(this.connectionId, logId, this.batchedNonPreparedStmtExecutions, this.databaseType, this.wrappedStatement.getQueryTimeout(), this.wrappedStatement.getConnection().getAutoCommit());
        try {
            Object object = this.internalExecuteBatchInternal(method, args, logId);
            return object;
        }
        finally {
            this.batchedNonPreparedStmtExecutions.clear();
        }
    }

    @Nullable
    protected Object internalExecuteBatchInternal(Method method, @Nullable Object[] args, UUID logId) throws Throwable {
        Throwable exc = null;
        Long updateCount = null;
        long start = System.nanoTime();
        try {
            long totalRows;
            Object[] nbRows;
            Object result = Utils.invokeUnwrapException(this.wrappedStatement, method, args);
            if (result instanceof int[]) {
                nbRows = (int[])result;
                totalRows = 0L;
                for (int i = 0; i < nbRows.length; ++i) {
                    totalRows += (long)nbRows[i];
                }
                updateCount = totalRows;
            } else if (result instanceof long[]) {
                nbRows = (long[])result;
                totalRows = 0L;
                for (int i = 0; i < nbRows.length; ++i) {
                    totalRows += nbRows[i];
                }
                updateCount = totalRows;
            }
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            exc = e;
            throw exc;
        }
        finally {
            long end = System.nanoTime();
            PerfLogger.logStatementExecuted(logId, end - start, updateCount, exc);
        }
    }
}

