/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.driver;

import ch.sla.jdbcperflogger.driver.Utils;
import ch.sla.jdbcperflogger.logger.PerfLogger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.UUID;
import javax.annotation.Nullable;

public class LoggingResultSetInvocationHandler
implements InvocationHandler {
    private final ResultSet wrappedResultSet;
    private final UUID logId;
    private final long fetchStartTime;
    private boolean closed;
    private int nbRowsIterated;

    LoggingResultSetInvocationHandler(ResultSet rset, UUID logId) {
        this.wrappedResultSet = rset;
        this.logId = logId;
        this.fetchStartTime = System.nanoTime();
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object proxy, @Nullable Method method, @Nullable Object[] args) throws Throwable {
        assert (method != null);
        Object result = Utils.invokeUnwrapException(this.wrappedResultSet, method, args);
        String methodName = method.getName();
        if (args == null || args.length == 0) {
            if ("close".equals(methodName)) {
                if (!this.closed) {
                    this.closed = true;
                    PerfLogger.logClosedResultSet(this.logId, System.nanoTime() - this.fetchStartTime, this.nbRowsIterated);
                }
            } else if ("next".equals(methodName) && Boolean.TRUE.equals(result)) {
                ++this.nbRowsIterated;
            }
        }
        return result;
    }
}

