/*
 * Decompiled with CFR 0.152.
 */
package com.github.sundeepk.compactcalendarview;

import com.github.sundeepk.compactcalendarview.Events;
import com.github.sundeepk.compactcalendarview.comparators.EventComparator;
import com.github.sundeepk.compactcalendarview.domain.Event;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EventsContainer {
    private Map<String, List<Events>> eventsByMonthAndYearMap = new HashMap<String, List<Events>>();
    private Comparator<Event> eventsComparator = new EventComparator();
    private Calendar eventsCalendar;

    public EventsContainer(Calendar eventsCalendar) {
        this.eventsCalendar = eventsCalendar;
    }

    void addEvent(Event event) {
        Events eventsForTargetDay;
        this.eventsCalendar.setTimeInMillis(event.getTimeInMillis());
        String key = this.getKeyForCalendarEvent(this.eventsCalendar);
        List<Events> eventsForMonth = this.eventsByMonthAndYearMap.get(key);
        if (eventsForMonth == null) {
            eventsForMonth = new ArrayList<Events>();
        }
        if ((eventsForTargetDay = this.getEventDayEvent(event.getTimeInMillis())) == null) {
            ArrayList<Event> events = new ArrayList<Event>();
            events.add(event);
            eventsForMonth.add(new Events(event.getTimeInMillis(), events));
        } else {
            eventsForTargetDay.getEvents().add(event);
        }
        this.eventsByMonthAndYearMap.put(key, eventsForMonth);
    }

    void removeAllEvents() {
        this.eventsByMonthAndYearMap.clear();
    }

    void addEvents(List<Event> events) {
        int count = events.size();
        for (int i = 0; i < count; ++i) {
            this.addEvent(events.get(i));
        }
    }

    List<Event> getEventsFor(long epochMillis) {
        Events events = this.getEventDayEvent(epochMillis);
        if (events == null) {
            return new ArrayList<Event>();
        }
        return events.getEvents();
    }

    List<Events> getEventsForMonthAndYear(int month, int year) {
        return this.eventsByMonthAndYearMap.get(year + "_" + month);
    }

    List<Event> getEventsForMonth(long eventTimeInMillis) {
        this.eventsCalendar.setTimeInMillis(eventTimeInMillis);
        String keyForCalendarEvent = this.getKeyForCalendarEvent(this.eventsCalendar);
        List<Events> events = this.eventsByMonthAndYearMap.get(keyForCalendarEvent);
        ArrayList<Event> allEventsForMonth = new ArrayList<Event>();
        if (events != null) {
            for (Events eve : events) {
                if (eve == null) continue;
                allEventsForMonth.addAll(eve.getEvents());
            }
        }
        Collections.sort(allEventsForMonth, this.eventsComparator);
        return allEventsForMonth;
    }

    private Events getEventDayEvent(long eventTimeInMillis) {
        this.eventsCalendar.setTimeInMillis(eventTimeInMillis);
        int dayInMonth = this.eventsCalendar.get(5);
        String keyForCalendarEvent = this.getKeyForCalendarEvent(this.eventsCalendar);
        List<Events> eventsForMonthsAndYear = this.eventsByMonthAndYearMap.get(keyForCalendarEvent);
        if (eventsForMonthsAndYear != null) {
            for (Events events : eventsForMonthsAndYear) {
                this.eventsCalendar.setTimeInMillis(events.getTimeInMillis());
                int dayInMonthFromCache = this.eventsCalendar.get(5);
                if (dayInMonthFromCache != dayInMonth) continue;
                return events;
            }
        }
        return null;
    }

    void removeEventByEpochMillis(long epochMillis) {
        this.eventsCalendar.setTimeInMillis(epochMillis);
        int dayInMonth = this.eventsCalendar.get(5);
        String key = this.getKeyForCalendarEvent(this.eventsCalendar);
        List<Events> eventsForMonthAndYear = this.eventsByMonthAndYearMap.get(key);
        if (eventsForMonthAndYear != null) {
            Iterator<Events> calendarDayEventIterator = eventsForMonthAndYear.iterator();
            while (calendarDayEventIterator.hasNext()) {
                Events next = calendarDayEventIterator.next();
                this.eventsCalendar.setTimeInMillis(next.getTimeInMillis());
                int dayInMonthFromCache = this.eventsCalendar.get(5);
                if (dayInMonthFromCache != dayInMonth) continue;
                calendarDayEventIterator.remove();
                break;
            }
            if (eventsForMonthAndYear.isEmpty()) {
                this.eventsByMonthAndYearMap.remove(key);
            }
        }
    }

    void removeEvent(Event event) {
        this.eventsCalendar.setTimeInMillis(event.getTimeInMillis());
        String key = this.getKeyForCalendarEvent(this.eventsCalendar);
        List<Events> eventsForMonthAndYear = this.eventsByMonthAndYearMap.get(key);
        if (eventsForMonthAndYear != null) {
            Iterator<Events> eventsForMonthYrItr = eventsForMonthAndYear.iterator();
            while (eventsForMonthYrItr.hasNext()) {
                Events events = eventsForMonthYrItr.next();
                int indexOfEvent = events.getEvents().indexOf(event);
                if (indexOfEvent < 0) continue;
                if (events.getEvents().size() == 1) {
                    eventsForMonthYrItr.remove();
                    break;
                }
                events.getEvents().remove(indexOfEvent);
                break;
            }
            if (eventsForMonthAndYear.isEmpty()) {
                this.eventsByMonthAndYearMap.remove(key);
            }
        }
    }

    void removeEvents(List<Event> events) {
        int count = events.size();
        for (int i = 0; i < count; ++i) {
            this.removeEvent(events.get(i));
        }
    }

    private String getKeyForCalendarEvent(Calendar cal) {
        return cal.get(1) + "_" + cal.get(2);
    }
}

