/*
 * Decompiled with CFR 0.152.
 */
package com.github.sundeepk.compactcalendarview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.v4.view.GestureDetectorCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.widget.OverScroller;
import com.github.sundeepk.compactcalendarview.AnimationHandler;
import com.github.sundeepk.compactcalendarview.CompactCalendarController;
import com.github.sundeepk.compactcalendarview.EventsContainer;
import com.github.sundeepk.compactcalendarview.domain.Event;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class CompactCalendarView
extends View {
    public static final int FILL_LARGE_INDICATOR = 1;
    public static final int NO_FILL_LARGE_INDICATOR = 2;
    public static final int SMALL_INDICATOR = 3;
    private final AnimationHandler animationHandler;
    private CompactCalendarController compactCalendarController;
    private GestureDetectorCompat gestureDetector;
    private boolean horizontalScrollEnabled = true;
    private final GestureDetector.SimpleOnGestureListener gestureListener = new GestureDetector.SimpleOnGestureListener(){

        public void onLongPress(MotionEvent e) {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            CompactCalendarView.this.compactCalendarController.onSingleTapUp(e);
            CompactCalendarView.this.invalidate();
            return super.onSingleTapUp(e);
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (CompactCalendarView.this.horizontalScrollEnabled && Math.abs(distanceX) > 0.0f) {
                CompactCalendarView.this.getParent().requestDisallowInterceptTouchEvent(true);
                CompactCalendarView.this.compactCalendarController.onScroll(e1, e2, distanceX, distanceY);
                CompactCalendarView.this.invalidate();
                return true;
            }
            return false;
        }
    };

    public CompactCalendarView(Context context) {
        this(context, null);
    }

    public CompactCalendarView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CompactCalendarView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.compactCalendarController = new CompactCalendarController(new Paint(), new OverScroller(this.getContext()), new Rect(), attrs, this.getContext(), Color.argb((int)255, (int)233, (int)84, (int)81), Color.argb((int)255, (int)64, (int)64, (int)64), Color.argb((int)255, (int)219, (int)219, (int)219), VelocityTracker.obtain(), Color.argb((int)255, (int)100, (int)68, (int)65), new EventsContainer(Calendar.getInstance()), Locale.getDefault(), TimeZone.getDefault());
        this.gestureDetector = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)this.gestureListener);
        this.animationHandler = new AnimationHandler(this.compactCalendarController, this);
    }

    public void setAnimationListener(CompactCalendarAnimationListener compactCalendarAnimationListener) {
        this.animationHandler.setCompactCalendarAnimationListener(compactCalendarAnimationListener);
    }

    public void setLocale(TimeZone timeZone, Locale locale) {
        this.compactCalendarController.setLocale(timeZone, locale);
        this.invalidate();
    }

    public void setUseThreeLetterAbbreviation(boolean useThreeLetterAbbreviation) {
        this.compactCalendarController.setUseWeekDayAbbreviation(useThreeLetterAbbreviation);
        this.invalidate();
    }

    public void setCalendarBackgroundColor(int calenderBackgroundColor) {
        this.compactCalendarController.setCalenderBackgroundColor(calenderBackgroundColor);
        this.invalidate();
    }

    public void setDayColumnNames(String[] dayColumnNames) {
        this.compactCalendarController.setDayColumnNames(dayColumnNames);
    }

    public void setFirstDayOfWeek(int dayOfWeek) {
        this.compactCalendarController.setFirstDayOfWeek(dayOfWeek);
        this.invalidate();
    }

    public void setCurrentSelectedDayBackgroundColor(int currentSelectedDayBackgroundColor) {
        this.compactCalendarController.setCurrentSelectedDayBackgroundColor(currentSelectedDayBackgroundColor);
        this.invalidate();
    }

    public void setCurrentDayBackgroundColor(int currentDayBackgroundColor) {
        this.compactCalendarController.setCurrentDayBackgroundColor(currentDayBackgroundColor);
        this.invalidate();
    }

    public int getHeightPerDay() {
        return this.compactCalendarController.getHeightPerDay();
    }

    public void setListener(CompactCalendarViewListener listener) {
        this.compactCalendarController.setListener(listener);
    }

    public Date getFirstDayOfCurrentMonth() {
        return this.compactCalendarController.getFirstDayOfCurrentMonth();
    }

    public void shouldDrawIndicatorsBelowSelectedDays(boolean shouldDrawIndicatorsBelowSelectedDays) {
        this.compactCalendarController.shouldDrawIndicatorsBelowSelectedDays(shouldDrawIndicatorsBelowSelectedDays);
    }

    public void setCurrentDate(Date dateTimeMonth) {
        this.compactCalendarController.setCurrentDate(dateTimeMonth);
        this.invalidate();
    }

    public int getWeekNumberForCurrentMonth() {
        return this.compactCalendarController.getWeekNumberForCurrentMonth();
    }

    public void setShouldDrawDaysHeader(boolean shouldDrawDaysHeader) {
        this.compactCalendarController.setShouldDrawDaysHeader(shouldDrawDaysHeader);
    }

    public void setCurrentSelectedDayTextColor(int currentSelectedDayTextColor) {
        this.compactCalendarController.setCurrentSelectedDayTextColor(currentSelectedDayTextColor);
    }

    public void setCurrentDayTextColor(int currentDayTextColor) {
        this.compactCalendarController.setCurrentDayTextColor(currentDayTextColor);
    }

    public void addEvent(Event event) {
        this.addEvent(event, true);
    }

    public void addEvent(Event event, boolean shouldInvalidate) {
        this.compactCalendarController.addEvent(event);
        if (shouldInvalidate) {
            this.invalidate();
        }
    }

    public void addEvents(List<Event> events) {
        this.compactCalendarController.addEvents(events);
        this.invalidate();
    }

    public List<Event> getEvents(Date date) {
        return this.compactCalendarController.getCalendarEventsFor(date.getTime());
    }

    public List<Event> getEvents(long epochMillis) {
        return this.compactCalendarController.getCalendarEventsFor(epochMillis);
    }

    public List<Event> getEventsForMonth(long epochMillis) {
        return this.compactCalendarController.getCalendarEventsForMonth(epochMillis);
    }

    public List<Event> getEventsForMonth(Date date) {
        return this.compactCalendarController.getCalendarEventsForMonth(date.getTime());
    }

    public void removeEvents(Date date) {
        this.compactCalendarController.removeEventsFor(date.getTime());
    }

    public void removeEvents(long epochMillis) {
        this.compactCalendarController.removeEventsFor(epochMillis);
    }

    public void removeEvent(Event event) {
        this.removeEvent(event, true);
    }

    public void removeEvent(Event event, boolean shouldInvalidate) {
        this.compactCalendarController.removeEvent(event);
        if (shouldInvalidate) {
            this.invalidate();
        }
    }

    public void removeEvents(List<Event> events) {
        this.compactCalendarController.removeEvents(events);
        this.invalidate();
    }

    public void removeAllEvents() {
        this.compactCalendarController.removeAllEvents();
        this.invalidate();
    }

    public void setIsRtl(boolean isRtl) {
        this.compactCalendarController.setIsRtl(isRtl);
    }

    public void shouldSelectFirstDayOfMonthOnScroll(boolean shouldSelectFirstDayOfMonthOnScroll) {
        this.compactCalendarController.setShouldSelectFirstDayOfMonthOnScroll(shouldSelectFirstDayOfMonthOnScroll);
    }

    public void setCurrentSelectedDayIndicatorStyle(int currentSelectedDayIndicatorStyle) {
        this.compactCalendarController.setCurrentSelectedDayIndicatorStyle(currentSelectedDayIndicatorStyle);
        this.invalidate();
    }

    public void setCurrentDayIndicatorStyle(int currentDayIndicatorStyle) {
        this.compactCalendarController.setCurrentDayIndicatorStyle(currentDayIndicatorStyle);
        this.invalidate();
    }

    public void setEventIndicatorStyle(int eventIndicatorStyle) {
        this.compactCalendarController.setEventIndicatorStyle(eventIndicatorStyle);
        this.invalidate();
    }

    private void checkTargetHeight() {
        if (this.compactCalendarController.getTargetHeight() <= 0) {
            throw new IllegalStateException("Target height must be set in xml properties in order to expand/collapse CompactCalendar.");
        }
    }

    public void displayOtherMonthDays(boolean displayOtherMonthDays) {
        this.compactCalendarController.setDisplayOtherMonthDays(displayOtherMonthDays);
        this.invalidate();
    }

    public void setTargetHeight(int targetHeight) {
        this.compactCalendarController.setTargetHeight(targetHeight);
        this.checkTargetHeight();
    }

    public void showCalendar() {
        this.checkTargetHeight();
        this.animationHandler.openCalendar();
    }

    public void hideCalendar() {
        this.checkTargetHeight();
        this.animationHandler.closeCalendar();
    }

    public void showCalendarWithAnimation() {
        this.checkTargetHeight();
        this.animationHandler.openCalendarWithAnimation();
    }

    public void hideCalendarWithAnimation() {
        this.checkTargetHeight();
        this.animationHandler.closeCalendarWithAnimation();
    }

    public void scrollRight() {
        this.compactCalendarController.scrollRight();
        this.invalidate();
    }

    public void scrollLeft() {
        this.compactCalendarController.scrollLeft();
        this.invalidate();
    }

    public boolean isAnimating() {
        return this.animationHandler.isAnimating();
    }

    protected void onMeasure(int parentWidth, int parentHeight) {
        super.onMeasure(parentWidth, parentHeight);
        int width = View.MeasureSpec.getSize((int)parentWidth);
        int height = View.MeasureSpec.getSize((int)parentHeight);
        if (width > 0 && height > 0) {
            this.compactCalendarController.onMeasure(width, height, this.getPaddingRight(), this.getPaddingLeft());
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        this.compactCalendarController.onDraw(canvas);
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.compactCalendarController.computeScroll()) {
            this.invalidate();
        }
    }

    public void shouldScrollMonth(boolean enableHorizontalScroll) {
        this.horizontalScrollEnabled = enableHorizontalScroll;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.horizontalScrollEnabled) {
            this.compactCalendarController.onTouch(event);
            this.invalidate();
        }
        if ((event.getAction() == 3 || event.getAction() == 1) && this.horizontalScrollEnabled) {
            this.getParent().requestDisallowInterceptTouchEvent(false);
        }
        return this.gestureDetector.onTouchEvent(event);
    }

    public boolean canScrollHorizontally(int direction) {
        if (this.getVisibility() == 8) {
            return false;
        }
        return this.horizontalScrollEnabled;
    }

    public static interface CompactCalendarAnimationListener {
        public void onOpened();

        public void onClosed();
    }

    public static interface CompactCalendarViewListener {
        public void onDayClick(Date var1);

        public void onMonthScroll(Date var1);
    }
}

