/*
 * Decompiled with CFR 0.152.
 */
package com.github.sundeepk.compactcalendarview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import android.widget.OverScroller;
import com.github.sundeepk.compactcalendarview.CompactCalendarView;
import com.github.sundeepk.compactcalendarview.Events;
import com.github.sundeepk.compactcalendarview.EventsContainer;
import com.github.sundeepk.compactcalendarview.R;
import com.github.sundeepk.compactcalendarview.WeekUtils;
import com.github.sundeepk.compactcalendarview.domain.Event;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

class CompactCalendarController {
    public static final int IDLE = 0;
    public static final int EXPOSE_CALENDAR_ANIMATION = 1;
    public static final int EXPAND_COLLAPSE_CALENDAR = 2;
    public static final int ANIMATE_INDICATORS = 3;
    private static final int VELOCITY_UNIT_PIXELS_PER_SECOND = 1000;
    private static final int LAST_FLING_THRESHOLD_MILLIS = 300;
    private static final int DAYS_IN_WEEK = 7;
    private static final float SNAP_VELOCITY_DIP_PER_SECOND = 400.0f;
    private static final float ANIMATION_SCREEN_SET_DURATION_MILLIS = 700.0f;
    private int eventIndicatorStyle = 3;
    private int currentDayIndicatorStyle = 1;
    private int currentSelectedDayIndicatorStyle = 1;
    private int paddingWidth = 40;
    private int paddingHeight = 40;
    private int textHeight;
    private int textWidth;
    private int widthPerDay;
    private int monthsScrolledSoFar;
    private int heightPerDay;
    private int textSize = 30;
    private int width;
    private int height;
    private int paddingRight;
    private int paddingLeft;
    private int maximumVelocity;
    private int densityAdjustedSnapVelocity;
    private int distanceThresholdForAutoScroll;
    private int targetHeight;
    private int animationStatus = 0;
    private int firstDayOfWeekToDraw = 2;
    private float xIndicatorOffset;
    private float multiDayIndicatorStrokeWidth;
    private float bigCircleIndicatorRadius;
    private float smallIndicatorRadius;
    private float growFactor = 0.0f;
    private float screenDensity = 1.0f;
    private float growfactorIndicator;
    private float distanceX;
    private long lastAutoScrollFromFling;
    private boolean useThreeLetterAbbreviation = false;
    private boolean isSmoothScrolling;
    private boolean isScrolling;
    private boolean shouldDrawDaysHeader = true;
    private boolean shouldDrawIndicatorsBelowSelectedDays = false;
    private boolean displayOtherMonthDays = false;
    private boolean shouldSelectFirstDayOfMonthOnScroll = true;
    private boolean isRtl = false;
    private CompactCalendarView.CompactCalendarViewListener listener;
    private VelocityTracker velocityTracker = null;
    private Direction currentDirection = Direction.NONE;
    private Date currentDate = new Date();
    private Locale locale;
    private Calendar currentCalender;
    private Calendar todayCalender;
    private Calendar calendarWithFirstDayOfMonth;
    private Calendar eventsCalendar;
    private EventsContainer eventsContainer;
    private PointF accumulatedScrollOffset = new PointF();
    private OverScroller scroller;
    private Paint dayPaint = new Paint();
    private Paint background = new Paint();
    private Rect textSizeRect;
    private String[] dayColumnNames;
    private int multiEventIndicatorColor;
    private int currentDayBackgroundColor;
    private int currentDayTextColor;
    private int calenderTextColor;
    private int currentSelectedDayBackgroundColor;
    private int currentSelectedDayTextColor;
    private int calenderBackgroundColor = -1;
    private int otherMonthDaysTextColor;
    private TimeZone timeZone;
    private Calendar tempPreviousMonthCalendar;

    CompactCalendarController(Paint dayPaint, OverScroller scroller, Rect textSizeRect, AttributeSet attrs, Context context, int currentDayBackgroundColor, int calenderTextColor, int currentSelectedDayBackgroundColor, VelocityTracker velocityTracker, int multiEventIndicatorColor, EventsContainer eventsContainer, Locale locale, TimeZone timeZone) {
        this.dayPaint = dayPaint;
        this.scroller = scroller;
        this.textSizeRect = textSizeRect;
        this.currentDayBackgroundColor = currentDayBackgroundColor;
        this.calenderTextColor = calenderTextColor;
        this.currentSelectedDayBackgroundColor = currentSelectedDayBackgroundColor;
        this.otherMonthDaysTextColor = calenderTextColor;
        this.velocityTracker = velocityTracker;
        this.multiEventIndicatorColor = multiEventIndicatorColor;
        this.eventsContainer = eventsContainer;
        this.locale = locale;
        this.timeZone = timeZone;
        this.displayOtherMonthDays = false;
        this.loadAttributes(attrs, context);
        this.init(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttributes(AttributeSet attrs, Context context) {
        if (attrs != null && context != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CompactCalendarView, 0, 0);
            try {
                this.currentDayBackgroundColor = typedArray.getColor(R.styleable.CompactCalendarView_compactCalendarCurrentDayBackgroundColor, this.currentDayBackgroundColor);
                this.calenderTextColor = typedArray.getColor(R.styleable.CompactCalendarView_compactCalendarTextColor, this.calenderTextColor);
                this.currentDayTextColor = typedArray.getColor(R.styleable.CompactCalendarView_compactCalendarCurrentDayTextColor, this.calenderTextColor);
                this.otherMonthDaysTextColor = typedArray.getColor(R.styleable.CompactCalendarView_compactCalendarOtherMonthDaysTextColor, this.otherMonthDaysTextColor);
                this.currentSelectedDayBackgroundColor = typedArray.getColor(R.styleable.CompactCalendarView_compactCalendarCurrentSelectedDayBackgroundColor, this.currentSelectedDayBackgroundColor);
                this.currentSelectedDayTextColor = typedArray.getColor(R.styleable.CompactCalendarView_compactCalendarCurrentSelectedDayTextColor, this.calenderTextColor);
                this.calenderBackgroundColor = typedArray.getColor(R.styleable.CompactCalendarView_compactCalendarBackgroundColor, this.calenderBackgroundColor);
                this.multiEventIndicatorColor = typedArray.getColor(R.styleable.CompactCalendarView_compactCalendarMultiEventIndicatorColor, this.multiEventIndicatorColor);
                this.textSize = typedArray.getDimensionPixelSize(R.styleable.CompactCalendarView_compactCalendarTextSize, (int)TypedValue.applyDimension((int)2, (float)this.textSize, (DisplayMetrics)context.getResources().getDisplayMetrics()));
                this.targetHeight = typedArray.getDimensionPixelSize(R.styleable.CompactCalendarView_compactCalendarTargetHeight, (int)TypedValue.applyDimension((int)1, (float)this.targetHeight, (DisplayMetrics)context.getResources().getDisplayMetrics()));
                this.eventIndicatorStyle = typedArray.getInt(R.styleable.CompactCalendarView_compactCalendarEventIndicatorStyle, 3);
                this.currentDayIndicatorStyle = typedArray.getInt(R.styleable.CompactCalendarView_compactCalendarCurrentDayIndicatorStyle, 1);
                this.currentSelectedDayIndicatorStyle = typedArray.getInt(R.styleable.CompactCalendarView_compactCalendarCurrentSelectedDayIndicatorStyle, 1);
                this.displayOtherMonthDays = typedArray.getBoolean(R.styleable.CompactCalendarView_compactCalendarDisplayOtherMonthDays, this.displayOtherMonthDays);
                this.shouldSelectFirstDayOfMonthOnScroll = typedArray.getBoolean(R.styleable.CompactCalendarView_compactCalendarShouldSelectFirstDayOfMonthOnScroll, this.shouldSelectFirstDayOfMonthOnScroll);
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    private void init(Context context) {
        this.currentCalender = Calendar.getInstance(this.timeZone, this.locale);
        this.todayCalender = Calendar.getInstance(this.timeZone, this.locale);
        this.calendarWithFirstDayOfMonth = Calendar.getInstance(this.timeZone, this.locale);
        this.eventsCalendar = Calendar.getInstance(this.timeZone, this.locale);
        this.tempPreviousMonthCalendar = Calendar.getInstance(this.timeZone, this.locale);
        this.eventsCalendar.setMinimalDaysInFirstWeek(1);
        this.calendarWithFirstDayOfMonth.setMinimalDaysInFirstWeek(1);
        this.todayCalender.setMinimalDaysInFirstWeek(1);
        this.currentCalender.setMinimalDaysInFirstWeek(1);
        this.tempPreviousMonthCalendar.setMinimalDaysInFirstWeek(1);
        this.setFirstDayOfWeek(this.firstDayOfWeekToDraw);
        this.setUseWeekDayAbbreviation(false);
        this.dayPaint.setTextAlign(Paint.Align.CENTER);
        this.dayPaint.setStyle(Paint.Style.STROKE);
        this.dayPaint.setFlags(1);
        this.dayPaint.setTypeface(Typeface.SANS_SERIF);
        this.dayPaint.setTextSize((float)this.textSize);
        this.dayPaint.setColor(this.calenderTextColor);
        this.dayPaint.getTextBounds("31", 0, "31".length(), this.textSizeRect);
        this.textHeight = this.textSizeRect.height() * 3;
        this.textWidth = this.textSizeRect.width() * 2;
        this.todayCalender.setTime(new Date());
        this.setToMidnight(this.todayCalender);
        this.currentCalender.setTime(this.currentDate);
        this.setCalenderToFirstDayOfMonth(this.calendarWithFirstDayOfMonth, this.currentDate, -this.monthsScrolledSoFar, 0);
        this.initScreenDensityRelatedValues(context);
        this.xIndicatorOffset = 3.5f * this.screenDensity;
        this.smallIndicatorRadius = 2.5f * this.screenDensity;
        this.growFactor = 2.1474836E9f;
    }

    private void initScreenDensityRelatedValues(Context context) {
        if (context != null) {
            this.screenDensity = context.getResources().getDisplayMetrics().density;
            ViewConfiguration configuration = ViewConfiguration.get((Context)context);
            this.densityAdjustedSnapVelocity = (int)(this.screenDensity * 400.0f);
            this.maximumVelocity = configuration.getScaledMaximumFlingVelocity();
            DisplayMetrics dm = context.getResources().getDisplayMetrics();
            this.multiDayIndicatorStrokeWidth = TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)dm);
        }
    }

    private void setCalenderToFirstDayOfMonth(Calendar calendarWithFirstDayOfMonth, Date currentDate, int scrollOffset, int monthOffset) {
        this.setMonthOffset(calendarWithFirstDayOfMonth, currentDate, scrollOffset, monthOffset);
        calendarWithFirstDayOfMonth.set(5, 1);
    }

    private void setMonthOffset(Calendar calendarWithFirstDayOfMonth, Date currentDate, int scrollOffset, int monthOffset) {
        calendarWithFirstDayOfMonth.setTime(currentDate);
        calendarWithFirstDayOfMonth.add(2, scrollOffset + monthOffset);
        calendarWithFirstDayOfMonth.set(11, 0);
        calendarWithFirstDayOfMonth.set(12, 0);
        calendarWithFirstDayOfMonth.set(13, 0);
        calendarWithFirstDayOfMonth.set(14, 0);
    }

    void setIsRtl(boolean isRtl) {
        this.isRtl = isRtl;
    }

    void setShouldSelectFirstDayOfMonthOnScroll(boolean shouldSelectFirstDayOfMonthOnScroll) {
        this.shouldSelectFirstDayOfMonthOnScroll = shouldSelectFirstDayOfMonthOnScroll;
    }

    void setDisplayOtherMonthDays(boolean displayOtherMonthDays) {
        this.displayOtherMonthDays = displayOtherMonthDays;
    }

    void shouldDrawIndicatorsBelowSelectedDays(boolean shouldDrawIndicatorsBelowSelectedDays) {
        this.shouldDrawIndicatorsBelowSelectedDays = shouldDrawIndicatorsBelowSelectedDays;
    }

    void setCurrentDayIndicatorStyle(int currentDayIndicatorStyle) {
        this.currentDayIndicatorStyle = currentDayIndicatorStyle;
    }

    void setEventIndicatorStyle(int eventIndicatorStyle) {
        this.eventIndicatorStyle = eventIndicatorStyle;
    }

    void setCurrentSelectedDayIndicatorStyle(int currentSelectedDayIndicatorStyle) {
        this.currentSelectedDayIndicatorStyle = currentSelectedDayIndicatorStyle;
    }

    void setTargetHeight(int targetHeight) {
        this.targetHeight = targetHeight;
    }

    float getScreenDensity() {
        return this.screenDensity;
    }

    float getDayIndicatorRadius() {
        return this.bigCircleIndicatorRadius;
    }

    void setGrowFactorIndicator(float growfactorIndicator) {
        this.growfactorIndicator = growfactorIndicator;
    }

    float getGrowFactorIndicator() {
        return this.growfactorIndicator;
    }

    void setAnimationStatus(int animationStatus) {
        this.animationStatus = animationStatus;
    }

    int getTargetHeight() {
        return this.targetHeight;
    }

    int getWidth() {
        return this.width;
    }

    void setListener(CompactCalendarView.CompactCalendarViewListener listener) {
        this.listener = listener;
    }

    void removeAllEvents() {
        this.eventsContainer.removeAllEvents();
    }

    void setFirstDayOfWeek(int day) {
        if (day < 1 || day > 7) {
            throw new IllegalArgumentException("Day must be an int between 1 and 7 or DAY_OF_WEEK from Java Calendar class. For more information please see Calendar.DAY_OF_WEEK.");
        }
        this.firstDayOfWeekToDraw = day;
        this.setUseWeekDayAbbreviation(this.useThreeLetterAbbreviation);
        this.eventsCalendar.setFirstDayOfWeek(day);
        this.calendarWithFirstDayOfMonth.setFirstDayOfWeek(day);
        this.todayCalender.setFirstDayOfWeek(day);
        this.currentCalender.setFirstDayOfWeek(day);
        this.tempPreviousMonthCalendar.setFirstDayOfWeek(day);
    }

    void setCurrentSelectedDayBackgroundColor(int currentSelectedDayBackgroundColor) {
        this.currentSelectedDayBackgroundColor = currentSelectedDayBackgroundColor;
    }

    void setCurrentSelectedDayTextColor(int currentSelectedDayTextColor) {
        this.currentSelectedDayTextColor = currentSelectedDayTextColor;
    }

    void setCalenderBackgroundColor(int calenderBackgroundColor) {
        this.calenderBackgroundColor = calenderBackgroundColor;
    }

    void setCurrentDayBackgroundColor(int currentDayBackgroundColor) {
        this.currentDayBackgroundColor = currentDayBackgroundColor;
    }

    void setCurrentDayTextColor(int currentDayTextColor) {
        this.currentDayTextColor = currentDayTextColor;
    }

    void scrollRight() {
        if (this.isRtl) {
            this.scrollPrev();
        } else {
            this.scrollNext();
        }
    }

    void scrollLeft() {
        if (this.isRtl) {
            this.scrollNext();
        } else {
            this.scrollPrev();
        }
    }

    private void scrollNext() {
        --this.monthsScrolledSoFar;
        this.accumulatedScrollOffset.x = this.monthsScrolledSoFar * this.width;
        if (this.shouldSelectFirstDayOfMonthOnScroll) {
            this.setCalenderToFirstDayOfMonth(this.calendarWithFirstDayOfMonth, this.currentCalender.getTime(), 0, 1);
            this.setCurrentDate(this.calendarWithFirstDayOfMonth.getTime());
        }
        this.performMonthScrollCallback();
    }

    private void scrollPrev() {
        ++this.monthsScrolledSoFar;
        this.accumulatedScrollOffset.x = this.monthsScrolledSoFar * this.width;
        if (this.shouldSelectFirstDayOfMonthOnScroll) {
            this.setCalenderToFirstDayOfMonth(this.calendarWithFirstDayOfMonth, this.currentCalender.getTime(), 0, -1);
            this.setCurrentDate(this.calendarWithFirstDayOfMonth.getTime());
        }
        this.performMonthScrollCallback();
    }

    void setLocale(TimeZone timeZone, Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Locale cannot be null.");
        }
        if (timeZone == null) {
            throw new IllegalArgumentException("TimeZone cannot be null.");
        }
        this.locale = locale;
        this.timeZone = timeZone;
        this.eventsContainer = new EventsContainer(Calendar.getInstance(this.timeZone, this.locale));
        this.init(null);
    }

    void setUseWeekDayAbbreviation(boolean useThreeLetterAbbreviation) {
        this.useThreeLetterAbbreviation = useThreeLetterAbbreviation;
        this.dayColumnNames = WeekUtils.getWeekdayNames(this.locale, this.firstDayOfWeekToDraw, this.useThreeLetterAbbreviation);
    }

    void setDayColumnNames(String[] dayColumnNames) {
        if (dayColumnNames == null || dayColumnNames.length != 7) {
            throw new IllegalArgumentException("Column names cannot be null and must contain a value for each day of the week");
        }
        this.dayColumnNames = dayColumnNames;
    }

    void setShouldDrawDaysHeader(boolean shouldDrawDaysHeader) {
        this.shouldDrawDaysHeader = shouldDrawDaysHeader;
    }

    void onMeasure(int width, int height, int paddingRight, int paddingLeft) {
        this.widthPerDay = width / 7;
        this.heightPerDay = this.targetHeight > 0 ? this.targetHeight / 7 : height / 7;
        this.width = width;
        this.distanceThresholdForAutoScroll = (int)((double)width * 0.5);
        this.height = height;
        this.paddingRight = paddingRight;
        this.paddingLeft = paddingLeft;
        this.bigCircleIndicatorRadius = this.getInterpolatedBigCircleIndicator();
        this.bigCircleIndicatorRadius = this.shouldDrawIndicatorsBelowSelectedDays && this.eventIndicatorStyle == 3 ? this.bigCircleIndicatorRadius * 0.85f : this.bigCircleIndicatorRadius;
    }

    private float getInterpolatedBigCircleIndicator() {
        float x0 = this.textSizeRect.height();
        float x1 = this.heightPerDay;
        float x = (x1 + (float)this.textSizeRect.height()) / 2.0f;
        double y1 = 0.5 * Math.sqrt(x1 * x1 + x1 * x1);
        double y0 = 0.5 * Math.sqrt(x0 * x0 + x0 * x0);
        return (float)(y0 + (y1 - y0) * (double)((x - x0) / (x1 - x0)));
    }

    void onDraw(Canvas canvas) {
        this.paddingWidth = this.widthPerDay / 2;
        this.paddingHeight = this.heightPerDay / 2;
        this.calculateXPositionOffset();
        if (this.animationStatus == 1) {
            this.drawCalendarWhileAnimating(canvas);
        } else if (this.animationStatus == 3) {
            this.drawCalendarWhileAnimatingIndicators(canvas);
        } else {
            this.drawCalenderBackground(canvas);
            this.drawScrollableCalender(canvas);
        }
    }

    private void drawCalendarWhileAnimatingIndicators(Canvas canvas) {
        this.dayPaint.setColor(this.calenderBackgroundColor);
        this.dayPaint.setStyle(Paint.Style.FILL);
        canvas.drawCircle(0.0f, 0.0f, this.growFactor, this.dayPaint);
        this.dayPaint.setStyle(Paint.Style.STROKE);
        this.dayPaint.setColor(-1);
        this.drawScrollableCalender(canvas);
    }

    private void drawCalendarWhileAnimating(Canvas canvas) {
        this.background.setColor(this.calenderBackgroundColor);
        this.background.setStyle(Paint.Style.FILL);
        canvas.drawCircle(0.0f, 0.0f, this.growFactor, this.background);
        this.dayPaint.setStyle(Paint.Style.STROKE);
        this.dayPaint.setColor(-1);
        this.drawScrollableCalender(canvas);
    }

    void onSingleTapUp(MotionEvent e) {
        if (this.isScrolling()) {
            return;
        }
        int dayColumn = Math.round(((float)this.paddingLeft + e.getX() - (float)this.paddingWidth - (float)this.paddingRight) / (float)this.widthPerDay);
        int dayRow = Math.round((e.getY() - (float)this.paddingHeight) / (float)this.heightPerDay);
        this.setCalenderToFirstDayOfMonth(this.calendarWithFirstDayOfMonth, this.currentDate, this.monthsScrolledSoFar(), 0);
        int firstDayOfMonth = this.getDayOfWeek(this.calendarWithFirstDayOfMonth);
        int dayOfMonth = (dayRow - 1) * 7 - firstDayOfMonth;
        dayOfMonth = this.isRtl ? (dayOfMonth += 6 - dayColumn) : (dayOfMonth += dayColumn);
        if (dayOfMonth < this.calendarWithFirstDayOfMonth.getActualMaximum(5) && dayOfMonth >= 0) {
            this.calendarWithFirstDayOfMonth.add(5, dayOfMonth);
            this.currentCalender.setTimeInMillis(this.calendarWithFirstDayOfMonth.getTimeInMillis());
            this.performOnDayClickCallback(this.currentCalender.getTime());
        }
    }

    private boolean isScrolling() {
        int expectedScrollX;
        float scrolledX = Math.abs(this.accumulatedScrollOffset.x);
        return scrolledX < (float)((expectedScrollX = Math.abs(this.width * this.monthsScrolledSoFar)) - 5) || scrolledX > (float)(expectedScrollX + 5);
    }

    private void performOnDayClickCallback(Date date) {
        if (this.listener != null) {
            this.listener.onDayClick(date);
        }
    }

    boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.isSmoothScrolling) {
            return true;
        }
        if (this.currentDirection == Direction.NONE) {
            this.currentDirection = Math.abs(distanceX) > Math.abs(distanceY) ? Direction.HORIZONTAL : Direction.VERTICAL;
        }
        this.isScrolling = true;
        this.distanceX = distanceX;
        return true;
    }

    boolean onTouch(MotionEvent event) {
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(event);
        if (event.getAction() == 0) {
            if (!this.scroller.isFinished()) {
                this.scroller.abortAnimation();
            }
            this.isSmoothScrolling = false;
        } else if (event.getAction() == 2) {
            this.velocityTracker.addMovement(event);
            this.velocityTracker.computeCurrentVelocity(500);
        } else if (event.getAction() == 1) {
            this.handleHorizontalScrolling();
            this.velocityTracker.recycle();
            this.velocityTracker.clear();
            this.velocityTracker = null;
            this.isScrolling = false;
        }
        return false;
    }

    private void snapBackScroller() {
        float remainingScrollAfterFingerLifted1 = this.accumulatedScrollOffset.x - (float)(this.monthsScrolledSoFar * this.width);
        this.scroller.startScroll((int)this.accumulatedScrollOffset.x, 0, (int)(-remainingScrollAfterFingerLifted1), 0);
    }

    private void handleHorizontalScrolling() {
        int velocityX = this.computeVelocity();
        this.handleSmoothScrolling(velocityX);
        this.currentDirection = Direction.NONE;
        this.setCalenderToFirstDayOfMonth(this.calendarWithFirstDayOfMonth, this.currentDate, this.monthsScrolledSoFar(), 0);
        if (this.calendarWithFirstDayOfMonth.get(2) != this.currentCalender.get(2) && this.shouldSelectFirstDayOfMonthOnScroll) {
            this.setCalenderToFirstDayOfMonth(this.currentCalender, this.currentDate, this.monthsScrolledSoFar(), 0);
        }
    }

    private int computeVelocity() {
        this.velocityTracker.computeCurrentVelocity(1000, (float)this.maximumVelocity);
        return (int)this.velocityTracker.getXVelocity();
    }

    private void handleSmoothScrolling(int velocityX) {
        boolean isEnoughTimeElapsedSinceLastSmoothScroll;
        int distanceScrolled = (int)(this.accumulatedScrollOffset.x - (float)(this.width * this.monthsScrolledSoFar));
        boolean bl = isEnoughTimeElapsedSinceLastSmoothScroll = System.currentTimeMillis() - this.lastAutoScrollFromFling > 300L;
        if (velocityX > this.densityAdjustedSnapVelocity && isEnoughTimeElapsedSinceLastSmoothScroll) {
            this.scrollPreviousMonth();
        } else if (velocityX < -this.densityAdjustedSnapVelocity && isEnoughTimeElapsedSinceLastSmoothScroll) {
            this.scrollNextMonth();
        } else if (this.isScrolling && distanceScrolled > this.distanceThresholdForAutoScroll) {
            this.scrollPreviousMonth();
        } else if (this.isScrolling && distanceScrolled < -this.distanceThresholdForAutoScroll) {
            this.scrollNextMonth();
        } else {
            this.isSmoothScrolling = false;
            this.snapBackScroller();
        }
    }

    private void scrollNextMonth() {
        this.lastAutoScrollFromFling = System.currentTimeMillis();
        --this.monthsScrolledSoFar;
        this.performScroll();
        this.isSmoothScrolling = true;
        this.performMonthScrollCallback();
    }

    private void scrollPreviousMonth() {
        this.lastAutoScrollFromFling = System.currentTimeMillis();
        ++this.monthsScrolledSoFar;
        this.performScroll();
        this.isSmoothScrolling = true;
        this.performMonthScrollCallback();
    }

    private void performMonthScrollCallback() {
        if (this.listener != null) {
            this.listener.onMonthScroll(this.getFirstDayOfCurrentMonth());
        }
    }

    private void performScroll() {
        int targetScroll = this.monthsScrolledSoFar * this.width;
        float remainingScrollAfterFingerLifted = (float)targetScroll - this.accumulatedScrollOffset.x;
        this.scroller.startScroll((int)this.accumulatedScrollOffset.x, 0, (int)remainingScrollAfterFingerLifted, 0, (int)((float)Math.abs((int)remainingScrollAfterFingerLifted) / (float)this.width * 700.0f));
    }

    int getHeightPerDay() {
        return this.heightPerDay;
    }

    int getWeekNumberForCurrentMonth() {
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        calendar.setTime(this.currentDate);
        return calendar.get(4);
    }

    Date getFirstDayOfCurrentMonth() {
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        calendar.setTime(this.currentDate);
        calendar.add(2, this.monthsScrolledSoFar());
        calendar.set(5, 1);
        this.setToMidnight(calendar);
        return calendar.getTime();
    }

    void setCurrentDate(Date dateTimeMonth) {
        this.distanceX = 0.0f;
        this.monthsScrolledSoFar = 0;
        this.accumulatedScrollOffset.x = 0.0f;
        this.scroller.startScroll(0, 0, 0, 0);
        this.currentDate = new Date(dateTimeMonth.getTime());
        this.currentCalender.setTime(this.currentDate);
        this.todayCalender = Calendar.getInstance(this.timeZone, this.locale);
        this.setToMidnight(this.currentCalender);
    }

    private void setToMidnight(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    void addEvent(Event event) {
        this.eventsContainer.addEvent(event);
    }

    void addEvents(List<Event> events) {
        this.eventsContainer.addEvents(events);
    }

    List<Event> getCalendarEventsFor(long epochMillis) {
        return this.eventsContainer.getEventsFor(epochMillis);
    }

    List<Event> getCalendarEventsForMonth(long epochMillis) {
        return this.eventsContainer.getEventsForMonth(epochMillis);
    }

    void removeEventsFor(long epochMillis) {
        this.eventsContainer.removeEventByEpochMillis(epochMillis);
    }

    void removeEvent(Event event) {
        this.eventsContainer.removeEvent(event);
    }

    void removeEvents(List<Event> events) {
        this.eventsContainer.removeEvents(events);
    }

    void setGrowProgress(float grow) {
        this.growFactor = grow;
    }

    float getGrowFactor() {
        return this.growFactor;
    }

    boolean onDown(MotionEvent e) {
        this.scroller.forceFinished(true);
        return true;
    }

    boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        this.scroller.forceFinished(true);
        return true;
    }

    boolean computeScroll() {
        if (this.scroller.computeScrollOffset()) {
            this.accumulatedScrollOffset.x = this.scroller.getCurrX();
            return true;
        }
        return false;
    }

    private void drawScrollableCalender(Canvas canvas) {
        if (this.isRtl) {
            this.drawNextMonth(canvas, -1);
            this.drawCurrentMonth(canvas);
            this.drawPreviousMonth(canvas, 1);
        } else {
            this.drawPreviousMonth(canvas, -1);
            this.drawCurrentMonth(canvas);
            this.drawNextMonth(canvas, 1);
        }
    }

    private void drawNextMonth(Canvas canvas, int offset) {
        this.setCalenderToFirstDayOfMonth(this.calendarWithFirstDayOfMonth, this.currentDate, -this.monthsScrolledSoFar, offset);
        this.drawMonth(canvas, this.calendarWithFirstDayOfMonth, this.width * (-this.monthsScrolledSoFar + 1));
    }

    private void drawCurrentMonth(Canvas canvas) {
        this.setCalenderToFirstDayOfMonth(this.calendarWithFirstDayOfMonth, this.currentDate, this.monthsScrolledSoFar(), 0);
        this.drawMonth(canvas, this.calendarWithFirstDayOfMonth, this.width * -this.monthsScrolledSoFar);
    }

    private int monthsScrolledSoFar() {
        return this.isRtl ? this.monthsScrolledSoFar : -this.monthsScrolledSoFar;
    }

    private void drawPreviousMonth(Canvas canvas, int offset) {
        this.setCalenderToFirstDayOfMonth(this.calendarWithFirstDayOfMonth, this.currentDate, -this.monthsScrolledSoFar, offset);
        this.drawMonth(canvas, this.calendarWithFirstDayOfMonth, this.width * (-this.monthsScrolledSoFar - 1));
    }

    private void calculateXPositionOffset() {
        if (this.currentDirection == Direction.HORIZONTAL) {
            this.accumulatedScrollOffset.x -= this.distanceX;
        }
    }

    private void drawCalenderBackground(Canvas canvas) {
        this.dayPaint.setColor(this.calenderBackgroundColor);
        this.dayPaint.setStyle(Paint.Style.FILL);
        canvas.drawRect(0.0f, 0.0f, (float)this.width, (float)this.height, this.dayPaint);
        this.dayPaint.setStyle(Paint.Style.STROKE);
        this.dayPaint.setColor(this.calenderTextColor);
    }

    void drawEvents(Canvas canvas, Calendar currentMonthToDrawCalender, int offset) {
        int currentMonth = currentMonthToDrawCalender.get(2);
        List<Events> uniqEvents = this.eventsContainer.getEventsForMonthAndYear(currentMonth, currentMonthToDrawCalender.get(1));
        boolean shouldDrawCurrentDayCircle = currentMonth == this.todayCalender.get(2);
        boolean shouldDrawSelectedDayCircle = currentMonth == this.currentCalender.get(2);
        int todayDayOfMonth = this.todayCalender.get(5);
        int currentYear = this.todayCalender.get(1);
        int selectedDayOfMonth = this.currentCalender.get(5);
        float indicatorOffset = this.bigCircleIndicatorRadius / 2.0f;
        if (uniqEvents != null) {
            for (int i = 0; i < uniqEvents.size(); ++i) {
                boolean isCurrentSelectedDay;
                Events events = uniqEvents.get(i);
                long timeMillis = events.getTimeInMillis();
                this.eventsCalendar.setTimeInMillis(timeMillis);
                int dayOfWeek = this.getDayOfWeek(this.eventsCalendar);
                if (this.isRtl) {
                    dayOfWeek = 6 - dayOfWeek;
                }
                int weekNumberForMonth = this.eventsCalendar.get(4);
                float xPosition = (float)(this.widthPerDay * dayOfWeek + this.paddingWidth + this.paddingLeft) + this.accumulatedScrollOffset.x + (float)offset - (float)this.paddingRight;
                float yPosition = weekNumberForMonth * this.heightPerDay + this.paddingHeight;
                if ((this.animationStatus == 1 || this.animationStatus == 3) && xPosition >= this.growFactor || yPosition >= this.growFactor || this.animationStatus == 2 && yPosition >= this.growFactor || this.animationStatus == 1 && (this.eventIndicatorStyle == 1 || this.eventIndicatorStyle == 2)) continue;
                List<Event> eventsList = events.getEvents();
                int dayOfMonth = this.eventsCalendar.get(5);
                int eventYear = this.eventsCalendar.get(1);
                boolean isSameDayAsCurrentDay = shouldDrawCurrentDayCircle && todayDayOfMonth == dayOfMonth && eventYear == currentYear;
                boolean bl = isCurrentSelectedDay = shouldDrawSelectedDayCircle && selectedDayOfMonth == dayOfMonth;
                if (!this.shouldDrawIndicatorsBelowSelectedDays && (this.shouldDrawIndicatorsBelowSelectedDays || isSameDayAsCurrentDay || isCurrentSelectedDay) && this.animationStatus != 1) continue;
                if (this.eventIndicatorStyle == 1 || this.eventIndicatorStyle == 2) {
                    if (eventsList.isEmpty()) continue;
                    Event event = eventsList.get(0);
                    this.drawEventIndicatorCircle(canvas, xPosition, yPosition, event.getColor());
                    continue;
                }
                yPosition += indicatorOffset;
                if (this.shouldDrawIndicatorsBelowSelectedDays && (isSameDayAsCurrentDay || isCurrentSelectedDay)) {
                    yPosition += indicatorOffset;
                }
                if (eventsList.size() >= 3) {
                    this.drawEventsWithPlus(canvas, xPosition, yPosition, eventsList);
                    continue;
                }
                if (eventsList.size() == 2) {
                    this.drawTwoEvents(canvas, xPosition, yPosition, eventsList);
                    continue;
                }
                if (eventsList.size() != 1) continue;
                this.drawSingleEvent(canvas, xPosition, yPosition, eventsList);
            }
        }
    }

    private void drawSingleEvent(Canvas canvas, float xPosition, float yPosition, List<Event> eventsList) {
        Event event = eventsList.get(0);
        this.drawEventIndicatorCircle(canvas, xPosition, yPosition, event.getColor());
    }

    private void drawTwoEvents(Canvas canvas, float xPosition, float yPosition, List<Event> eventsList) {
        this.drawEventIndicatorCircle(canvas, xPosition + this.xIndicatorOffset * -1.0f, yPosition, eventsList.get(0).getColor());
        this.drawEventIndicatorCircle(canvas, xPosition + this.xIndicatorOffset * 1.0f, yPosition, eventsList.get(1).getColor());
    }

    private void drawEventsWithPlus(Canvas canvas, float xPosition, float yPosition, List<Event> eventsList) {
        int j = 0;
        int k = -2;
        while (j < 3) {
            Event event = eventsList.get(j);
            float xStartPosition = xPosition + this.xIndicatorOffset * (float)k;
            if (j == 2) {
                this.dayPaint.setColor(this.multiEventIndicatorColor);
                this.dayPaint.setStrokeWidth(this.multiDayIndicatorStrokeWidth);
                canvas.drawLine(xStartPosition - this.smallIndicatorRadius, yPosition, xStartPosition + this.smallIndicatorRadius, yPosition, this.dayPaint);
                canvas.drawLine(xStartPosition, yPosition - this.smallIndicatorRadius, xStartPosition, yPosition + this.smallIndicatorRadius, this.dayPaint);
                this.dayPaint.setStrokeWidth(0.0f);
            } else {
                this.drawEventIndicatorCircle(canvas, xStartPosition, yPosition, event.getColor());
            }
            ++j;
            k += 2;
        }
    }

    int getDayOfWeek(Calendar calendar) {
        int dayOfWeek = calendar.get(7) - this.firstDayOfWeekToDraw;
        dayOfWeek = dayOfWeek < 0 ? 7 + dayOfWeek : dayOfWeek;
        return dayOfWeek;
    }

    void drawMonth(Canvas canvas, Calendar monthToDrawCalender, int offset) {
        this.drawEvents(canvas, monthToDrawCalender, offset);
        int firstDayOfMonth = this.getDayOfWeek(monthToDrawCalender);
        boolean isSameMonthAsToday = monthToDrawCalender.get(2) == this.todayCalender.get(2);
        boolean isSameYearAsToday = monthToDrawCalender.get(1) == this.todayCalender.get(1);
        boolean isSameMonthAsCurrentCalendar = monthToDrawCalender.get(2) == this.currentCalender.get(2) && monthToDrawCalender.get(1) == this.currentCalender.get(1);
        int todayDayOfMonth = this.todayCalender.get(5);
        boolean isAnimatingWithExpose = this.animationStatus == 1;
        int maximumMonthDay = monthToDrawCalender.getActualMaximum(5);
        this.tempPreviousMonthCalendar.setTimeInMillis(monthToDrawCalender.getTimeInMillis());
        this.tempPreviousMonthCalendar.add(2, -1);
        int maximumPreviousMonthDay = this.tempPreviousMonthCalendar.getActualMaximum(5);
        int dayColumn = 0;
        int colDirection = this.isRtl ? 6 : 0;
        int dayRow = 0;
        while (dayColumn <= 6) {
            if (dayRow == 7) {
                colDirection = this.isRtl ? --colDirection : ++colDirection;
                dayRow = 0;
                if (dayColumn <= 6) {
                    ++dayColumn;
                }
            }
            if (dayColumn == this.dayColumnNames.length) break;
            float xPosition = (float)(this.widthPerDay * dayColumn + this.paddingWidth + this.paddingLeft) + this.accumulatedScrollOffset.x + (float)offset - (float)this.paddingRight;
            float yPosition = dayRow * this.heightPerDay + this.paddingHeight;
            if (!(xPosition >= this.growFactor && (isAnimatingWithExpose || this.animationStatus == 3) || yPosition >= this.growFactor)) {
                if (dayRow == 0) {
                    if (this.shouldDrawDaysHeader) {
                        this.dayPaint.setColor(this.calenderTextColor);
                        this.dayPaint.setTypeface(Typeface.DEFAULT_BOLD);
                        this.dayPaint.setStyle(Paint.Style.FILL);
                        this.dayPaint.setColor(this.calenderTextColor);
                        canvas.drawText(this.dayColumnNames[colDirection], xPosition, (float)this.paddingHeight, this.dayPaint);
                        this.dayPaint.setTypeface(Typeface.DEFAULT);
                    }
                } else {
                    int day = (dayRow - 1) * 7 + colDirection + 1 - firstDayOfMonth;
                    int defaultCalenderTextColorToUse = this.calenderTextColor;
                    if (this.currentCalender.get(5) == day && isSameMonthAsCurrentCalendar && !isAnimatingWithExpose) {
                        this.drawDayCircleIndicator(this.currentSelectedDayIndicatorStyle, canvas, xPosition, yPosition, this.currentSelectedDayBackgroundColor);
                        defaultCalenderTextColorToUse = this.currentSelectedDayTextColor;
                    } else if (isSameYearAsToday && isSameMonthAsToday && todayDayOfMonth == day && !isAnimatingWithExpose) {
                        this.drawDayCircleIndicator(this.currentDayIndicatorStyle, canvas, xPosition, yPosition, this.currentDayBackgroundColor);
                        defaultCalenderTextColorToUse = this.currentDayTextColor;
                    }
                    if (day <= 0) {
                        if (this.displayOtherMonthDays) {
                            this.dayPaint.setStyle(Paint.Style.FILL);
                            this.dayPaint.setColor(this.otherMonthDaysTextColor);
                            canvas.drawText(String.valueOf(maximumPreviousMonthDay + day), xPosition, yPosition, this.dayPaint);
                        }
                    } else if (day > maximumMonthDay) {
                        if (this.displayOtherMonthDays) {
                            this.dayPaint.setStyle(Paint.Style.FILL);
                            this.dayPaint.setColor(this.otherMonthDaysTextColor);
                            canvas.drawText(String.valueOf(day - maximumMonthDay), xPosition, yPosition, this.dayPaint);
                        }
                    } else {
                        this.dayPaint.setStyle(Paint.Style.FILL);
                        this.dayPaint.setColor(defaultCalenderTextColorToUse);
                        canvas.drawText(String.valueOf(day), xPosition, yPosition, this.dayPaint);
                    }
                }
            }
            ++dayRow;
        }
    }

    private void drawDayCircleIndicator(int indicatorStyle, Canvas canvas, float x, float y, int color) {
        this.drawDayCircleIndicator(indicatorStyle, canvas, x, y, color, 1.0f);
    }

    private void drawDayCircleIndicator(int indicatorStyle, Canvas canvas, float x, float y, int color, float circleScale) {
        float strokeWidth = this.dayPaint.getStrokeWidth();
        if (indicatorStyle == 2) {
            this.dayPaint.setStrokeWidth(2.0f * this.screenDensity);
            this.dayPaint.setStyle(Paint.Style.STROKE);
        } else {
            this.dayPaint.setStyle(Paint.Style.FILL);
        }
        this.drawCircle(canvas, x, y, color, circleScale);
        this.dayPaint.setStrokeWidth(strokeWidth);
        this.dayPaint.setStyle(Paint.Style.FILL);
    }

    private void drawCircle(Canvas canvas, float x, float y, int color, float circleScale) {
        this.dayPaint.setColor(color);
        if (this.animationStatus == 3) {
            float maxRadius = circleScale * this.bigCircleIndicatorRadius * 1.4f;
            this.drawCircle(canvas, this.growfactorIndicator > maxRadius ? maxRadius : this.growfactorIndicator, x, y - (float)(this.textHeight / 6));
        } else {
            this.drawCircle(canvas, circleScale * this.bigCircleIndicatorRadius, x, y - (float)(this.textHeight / 6));
        }
    }

    private void drawEventIndicatorCircle(Canvas canvas, float x, float y, int color) {
        this.dayPaint.setColor(color);
        if (this.eventIndicatorStyle == 3) {
            this.dayPaint.setStyle(Paint.Style.FILL);
            this.drawCircle(canvas, this.smallIndicatorRadius, x, y);
        } else if (this.eventIndicatorStyle == 2) {
            this.dayPaint.setStyle(Paint.Style.STROKE);
            this.drawDayCircleIndicator(2, canvas, x, y, color);
        } else if (this.eventIndicatorStyle == 1) {
            this.drawDayCircleIndicator(1, canvas, x, y, color);
        }
    }

    private void drawCircle(Canvas canvas, float radius, float x, float y) {
        canvas.drawCircle(x, y, radius, this.dayPaint);
    }

    private static enum Direction {
        NONE,
        HORIZONTAL,
        VERTICAL;

    }
}

