/*
 * Decompiled with CFR 0.152.
 */
package com.github.sundeepk.compactcalendarview;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import com.github.sundeepk.compactcalendarview.AnimationListener;
import com.github.sundeepk.compactcalendarview.AnimatorListener;
import com.github.sundeepk.compactcalendarview.CollapsingAnimation;
import com.github.sundeepk.compactcalendarview.CompactCalendarController;
import com.github.sundeepk.compactcalendarview.CompactCalendarView;

class AnimationHandler {
    private static final int HEIGHT_ANIM_DURATION_MILLIS = 650;
    private static final int INDICATOR_ANIM_DURATION_MILLIS = 600;
    private boolean isAnimating = false;
    private CompactCalendarController compactCalendarController;
    private CompactCalendarView compactCalendarView;
    private CompactCalendarView.CompactCalendarAnimationListener compactCalendarAnimationListener;

    AnimationHandler(CompactCalendarController compactCalendarController, CompactCalendarView compactCalendarView) {
        this.compactCalendarController = compactCalendarController;
        this.compactCalendarView = compactCalendarView;
    }

    void setCompactCalendarAnimationListener(CompactCalendarView.CompactCalendarAnimationListener compactCalendarAnimationListener) {
        this.compactCalendarAnimationListener = compactCalendarAnimationListener;
    }

    void openCalendar() {
        if (this.isAnimating) {
            return;
        }
        this.isAnimating = true;
        Animation heightAnim = this.getCollapsingAnimation(true);
        heightAnim.setDuration(650L);
        heightAnim.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.compactCalendarController.setAnimationStatus(2);
        this.setUpAnimationLisForOpen(heightAnim);
        this.compactCalendarView.getLayoutParams().height = 0;
        this.compactCalendarView.requestLayout();
        this.compactCalendarView.startAnimation(heightAnim);
    }

    void closeCalendar() {
        if (this.isAnimating) {
            return;
        }
        this.isAnimating = true;
        Animation heightAnim = this.getCollapsingAnimation(false);
        heightAnim.setDuration(650L);
        heightAnim.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.setUpAnimationLisForClose(heightAnim);
        this.compactCalendarController.setAnimationStatus(2);
        this.compactCalendarView.getLayoutParams().height = this.compactCalendarView.getHeight();
        this.compactCalendarView.requestLayout();
        this.compactCalendarView.startAnimation(heightAnim);
    }

    void openCalendarWithAnimation() {
        if (this.isAnimating) {
            return;
        }
        this.isAnimating = true;
        Animator indicatorAnim = this.getIndicatorAnimator(1.0f, this.compactCalendarController.getDayIndicatorRadius());
        Animation heightAnim = this.getExposeCollapsingAnimation(true);
        this.compactCalendarView.getLayoutParams().height = 0;
        this.compactCalendarView.requestLayout();
        this.setUpAnimationLisForExposeOpen(indicatorAnim, heightAnim);
        this.compactCalendarView.startAnimation(heightAnim);
    }

    void closeCalendarWithAnimation() {
        if (this.isAnimating) {
            return;
        }
        this.isAnimating = true;
        Animator indicatorAnim = this.getIndicatorAnimator(this.compactCalendarController.getDayIndicatorRadius(), 1.0f);
        Animation heightAnim = this.getExposeCollapsingAnimation(false);
        this.compactCalendarView.getLayoutParams().height = this.compactCalendarView.getHeight();
        this.compactCalendarView.requestLayout();
        this.setUpAnimationLisForExposeClose(indicatorAnim, heightAnim);
        this.compactCalendarView.startAnimation(heightAnim);
    }

    private void setUpAnimationLisForExposeOpen(final Animator indicatorAnim, Animation heightAnim) {
        heightAnim.setAnimationListener((Animation.AnimationListener)new AnimationListener(){

            @Override
            public void onAnimationStart(Animation animation) {
                AnimationHandler.this.compactCalendarController.setAnimationStatus(1);
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                indicatorAnim.start();
            }
        });
        indicatorAnim.addListener((Animator.AnimatorListener)new AnimatorListener(){

            @Override
            public void onAnimationStart(Animator animation) {
                AnimationHandler.this.compactCalendarController.setAnimationStatus(3);
            }

            @Override
            public void onAnimationEnd(Animator animation) {
                AnimationHandler.this.compactCalendarController.setAnimationStatus(0);
                AnimationHandler.this.onOpen();
                AnimationHandler.this.isAnimating = false;
            }
        });
    }

    private void setUpAnimationLisForExposeClose(final Animator indicatorAnim, Animation heightAnim) {
        heightAnim.setAnimationListener((Animation.AnimationListener)new AnimationListener(){

            @Override
            public void onAnimationStart(Animation animation) {
                AnimationHandler.this.compactCalendarController.setAnimationStatus(1);
                indicatorAnim.start();
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                AnimationHandler.this.compactCalendarController.setAnimationStatus(0);
                AnimationHandler.this.onClose();
                AnimationHandler.this.isAnimating = false;
            }
        });
        indicatorAnim.addListener((Animator.AnimatorListener)new AnimatorListener(){

            @Override
            public void onAnimationStart(Animator animation) {
                AnimationHandler.this.compactCalendarController.setAnimationStatus(3);
            }

            @Override
            public void onAnimationEnd(Animator animation) {
            }
        });
    }

    @NonNull
    private Animation getExposeCollapsingAnimation(boolean isCollapsing) {
        Animation heightAnim = this.getCollapsingAnimation(isCollapsing);
        heightAnim.setDuration(650L);
        heightAnim.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        return heightAnim;
    }

    @NonNull
    private Animation getCollapsingAnimation(boolean isCollapsing) {
        return new CollapsingAnimation(this.compactCalendarView, this.compactCalendarController, this.compactCalendarController.getTargetHeight(), this.getTargetGrowRadius(), isCollapsing);
    }

    @NonNull
    private Animator getIndicatorAnimator(float from, float to) {
        ValueAnimator animIndicator = ValueAnimator.ofFloat((float[])new float[]{from, to});
        animIndicator.setDuration(600L);
        animIndicator.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        animIndicator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                AnimationHandler.this.compactCalendarController.setGrowFactorIndicator(((Float)animation.getAnimatedValue()).floatValue());
                AnimationHandler.this.compactCalendarView.invalidate();
            }
        });
        return animIndicator;
    }

    private int getTargetGrowRadius() {
        int heightSq = this.compactCalendarController.getTargetHeight() * this.compactCalendarController.getTargetHeight();
        int widthSq = this.compactCalendarController.getWidth() * this.compactCalendarController.getWidth();
        return (int)(0.5 * Math.sqrt(heightSq + widthSq));
    }

    private void onOpen() {
        if (this.compactCalendarAnimationListener != null) {
            this.compactCalendarAnimationListener.onOpened();
        }
    }

    private void onClose() {
        if (this.compactCalendarAnimationListener != null) {
            this.compactCalendarAnimationListener.onClosed();
        }
    }

    private void setUpAnimationLisForOpen(Animation openAnimation) {
        openAnimation.setAnimationListener((Animation.AnimationListener)new AnimationListener(){

            @Override
            public void onAnimationEnd(Animation animation) {
                super.onAnimationEnd(animation);
                AnimationHandler.this.onOpen();
                AnimationHandler.this.isAnimating = false;
            }
        });
    }

    private void setUpAnimationLisForClose(Animation openAnimation) {
        openAnimation.setAnimationListener((Animation.AnimationListener)new AnimationListener(){

            @Override
            public void onAnimationEnd(Animation animation) {
                super.onAnimationEnd(animation);
                AnimationHandler.this.onClose();
                AnimationHandler.this.isAnimating = false;
            }
        });
    }

    public boolean isAnimating() {
        return this.isAnimating;
    }
}

