/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.maven;

import com.github.stephenc.javaisotools.iso9660.ConfigException;
import com.github.stephenc.javaisotools.iso9660.ISO9660Directory;
import com.github.stephenc.javaisotools.iso9660.ISO9660File;
import com.github.stephenc.javaisotools.iso9660.ISO9660RootDirectory;
import com.github.stephenc.javaisotools.iso9660.StandardConfig;
import com.github.stephenc.javaisotools.iso9660.impl.CreateISO;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Config;
import com.github.stephenc.javaisotools.iso9660.impl.ISOImageFileHandler;
import com.github.stephenc.javaisotools.joliet.impl.JolietConfig;
import com.github.stephenc.javaisotools.maven.ArchiveEntryDataReference;
import com.github.stephenc.javaisotools.maven.Iso9660ArchiverException;
import com.github.stephenc.javaisotools.rockridge.impl.RockRidgeConfig;
import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;

@Component(role=Archiver.class, hint="iso9660")
public class Iso9660Archiver
extends AbstractArchiver {
    private String systemId;
    private String volumeId;
    private String volumeSetId;
    private String publisher;
    private String preparer;
    private String application;

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public String getVolumeSetId() {
        return this.volumeSetId;
    }

    public void setVolumeSetId(String volumeSetId) {
        this.volumeSetId = volumeSetId;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getPreparer() {
        return this.preparer;
    }

    public void setPreparer(String preparer) {
        this.preparer = preparer;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    protected String getArchiveType() {
        return "iso9660";
    }

    protected void close() throws IOException {
    }

    protected void execute() throws ArchiverException, IOException {
        File dest = this.getDestFile();
        if (dest == null) {
            throw new Iso9660ArchiverException(Iso9660ArchiverException.Type.MissingDestination, "You must set the destination " + this.getArchiveType() + " file.");
        }
        if (dest.exists() && !dest.isFile()) {
            throw new Iso9660ArchiverException(Iso9660ArchiverException.Type.DestinationNotAFile, dest + " isn't a file.");
        }
        if (dest.exists() && !dest.canWrite()) {
            throw new Iso9660ArchiverException(Iso9660ArchiverException.Type.DestinationReadOnly, dest + " is read-only.");
        }
        ISO9660RootDirectory.MOVED_DIRECTORIES_STORE_NAME = "rr_moved";
        ISO9660RootDirectory root = new ISO9660RootDirectory();
        try {
            ISO9660Directory parent;
            TreeMap<String, Object> directories = new TreeMap<String, Object>();
            TreeMap<String, ISO9660File> files = new TreeMap<String, ISO9660File>();
            directories.put("", root);
            ResourceIterator i = this.getResources();
            block8: while (i.hasNext()) {
                ArchiveEntry entry = i.next();
                switch (entry.getType()) {
                    case 2: {
                        ISO9660Directory dir = new ISO9660Directory(this.getName(entry));
                        directories.put(this.getPath(entry), dir);
                        String path = this.getPath(entry);
                        while ((path = this.getParentPath(path)) != "") {
                            dir = new ISO9660Directory(this.getName(path));
                            directories.put(path, dir);
                        }
                        continue block8;
                    }
                    case 1: {
                        ISO9660File file = new ISO9660File((DataReference)new ArchiveEntryDataReference(entry), this.getName(entry), entry.getResource().getLastModified());
                        files.put(this.getPath(entry), file);
                        String path = this.getPath(entry);
                        while ((path = this.getParentPath(path)) != "") {
                            ISO9660Directory dir = new ISO9660Directory(this.getName(path));
                            directories.put(path, dir);
                        }
                        continue block8;
                    }
                }
                throw new Iso9660ArchiverException(Iso9660ArchiverException.Type.UnsupportedEntryType, "Unknown entry type");
            }
            for (Map.Entry e : directories.entrySet()) {
                if (((String)e.getKey()).equals("")) continue;
                parent = (ISO9660Directory)directories.get(this.getParentPath((String)e.getKey()));
                parent.addDirectory((ISO9660Directory)e.getValue());
            }
            for (Map.Entry e : files.entrySet()) {
                parent = (ISO9660Directory)directories.get(this.getParentPath((String)e.getKey()));
                parent.addFile((ISO9660File)e.getValue());
            }
            ISOImageFileHandler streamHandler = new ISOImageFileHandler(new File(dest.getParentFile(), dest.getName()));
            CreateISO iso = new CreateISO((StreamHandler)streamHandler, root);
            ISO9660Config iso9660Config = new ISO9660Config();
            iso9660Config.allowASCII(false);
            iso9660Config.setInterchangeLevel(1);
            iso9660Config.restrictDirDepthTo8(true);
            iso9660Config.forceDotDelimiter(true);
            this.applyConfig((StandardConfig)iso9660Config);
            RockRidgeConfig rrConfig = new RockRidgeConfig();
            rrConfig.setMkisofsCompatibility(false);
            rrConfig.hideMovedDirectoriesStore(true);
            rrConfig.forcePortableFilenameCharacterSet(true);
            JolietConfig jolietConfig = new JolietConfig();
            jolietConfig.forceDotDelimiter(true);
            this.applyConfig((StandardConfig)jolietConfig);
            iso.process(iso9660Config, rrConfig, jolietConfig, null);
        }
        catch (HandlerException e) {
            throw new ArchiverException(e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new ArchiverException(e.getMessage(), (Throwable)e);
        }
        catch (ConfigException e) {
            throw new ArchiverException(e.getMessage(), (Throwable)e);
        }
    }

    private String getParentPath(String path) {
        String parent = path.contains("/") ? path.substring(0, path.lastIndexOf(47)) : "";
        return parent;
    }

    private String getPath(ArchiveEntry entry) {
        return entry.getName();
    }

    private String getName(String path) {
        return path.contains("/") ? path.substring(path.lastIndexOf(47) + 1) : path;
    }

    private String getName(ArchiveEntry entry) {
        return this.getName(entry.getName());
    }

    private void applyConfig(StandardConfig config) throws ConfigException {
        if (StringUtils.isNotEmpty((String)this.systemId)) {
            config.setSystemID(this.systemId);
        }
        if (StringUtils.isNotEmpty((String)this.volumeId)) {
            config.setVolumeID(this.volumeId);
        }
        if (StringUtils.isNotEmpty((String)this.volumeSetId)) {
            config.setVolumeSetID(this.volumeSetId);
        }
        if (StringUtils.isNotEmpty((String)this.publisher)) {
            config.setPublisher(this.publisher);
        }
        if (StringUtils.isNotEmpty((String)this.preparer)) {
            config.setDataPreparer(this.preparer);
        }
        if (StringUtils.isNotEmpty((String)this.application)) {
            config.setApp(this.application);
        }
    }
}

