package com.eaio.wro4j;

import java.io.IOException;
import java.io.InputStream;

import ro.isdc.wro.extensions.manager.standalone.GoogleStandaloneManagerFactory;
import ro.isdc.wro.model.resource.support.naming.DefaultHashEncoderNamingStrategy;

/**
 * Renames only JavaScript files but keeps CSS files.
 *
 * @author <a href="mailto:jb@eaio.com">Johann Burkard</a>
 * @version $Id: JSRenamingManagerFactory.java 5257 2012-10-29 18:38:21Z johann $
 */
public class JSRenamingManagerFactory extends GoogleStandaloneManagerFactory {

    public JSRenamingManagerFactory() {
        super();
        setNamingStrategy(new DefaultHashEncoderNamingStrategy() {

            /**
             * Don't rename CSS files because CSS files are <em>included</em> whereas JS files are <em>referenced</em>.
             * @see ro.isdc.wro.model.resource.util.HashEncoderNamingStrategy#rename(java.lang.String, java.io.InputStream)
             */
            @Override
            public String rename(String originalName, InputStream inputStream) throws IOException {
                return originalName.matches("(?i).+\\.css$") ? originalName : super.rename(originalName, inputStream);
            }
            
        });
    }

}
