package com.eaio.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.LoggerFactory;

/**
 * Non-validating SSL socket factory.
 *
 * @author <a href="mailto:jb&#64;eaio.com">Johann Burkard</a>
 * @version $Id: NonValidatingSSLSocketFactory.java 5171 2012-09-25 18:56:08Z johann $
 * @see <a href="http://java.sun.com/products/javamail/javamail-1.4.2/SSLNOTES142.txt">http://java.sun.com/products/javamail/javamail-1.4.2/SSLNOTES142.txt</a>
 */
public class NonValidatingSSLSocketFactory extends SSLSocketFactory {

    private SSLSocketFactory factory;

    public NonValidatingSSLSocketFactory() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[] { new NonValidatingX509TrustManager() }, null);
            factory = sslcontext.getSocketFactory();
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(getClass()).error("while initializing an SSLContext", ExceptionUtils.getRootCause(ex));
        }
    }

    public Socket createSocket() throws IOException {
        return factory.createSocket();
    }

    public Socket createSocket(Socket socket, String s, int i, boolean flag) throws IOException {
        return factory.createSocket(socket, s, i, flag);
    }

    public Socket createSocket(InetAddress inaddr, int i, InetAddress inaddr1, int j) throws IOException {
        return factory.createSocket(inaddr, i, inaddr1, j);
    }

    public Socket createSocket(InetAddress inaddr, int i) throws IOException {
        return factory.createSocket(inaddr, i);
    }

    public Socket createSocket(String s, int i, InetAddress inaddr, int j) throws IOException {
        return factory.createSocket(s, i, inaddr, j);
    }

    public Socket createSocket(String s, int i) throws IOException {
        return factory.createSocket(s, i);
    }

    public String[] getDefaultCipherSuites() {
        return factory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return factory.getSupportedCipherSuites();
    }

    class NonValidatingX509TrustManager implements X509TrustManager {

        public void checkClientTrusted(X509Certificate[] cert, String authType) { /* Pruh */ }

        public void checkServerTrusted(X509Certificate[] cert, String authType) { /* Ctuh */ }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

    }

}
