/*
 * Decompiled with CFR 0.152.
 */
package toothpick.configuration;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import toothpick.Scope;
import toothpick.config.Binding;
import toothpick.configuration.CyclicDependencyException;
import toothpick.configuration.IllegalBindingException;
import toothpick.configuration.RuntimeCheckConfiguration;

class RuntimeCheckOnConfiguration
implements RuntimeCheckConfiguration {
    private ThreadLocal<LinkedHashSet<Pair>> cycleDetectionStack = new ThreadLocal<LinkedHashSet<Pair>>(){

        @Override
        protected LinkedHashSet<Pair> initialValue() {
            return new LinkedHashSet<Pair>();
        }
    };

    RuntimeCheckOnConfiguration() {
    }

    @Override
    public void checkIllegalBinding(Binding binding, Scope scope) {
        Class clazz;
        switch (binding.getMode()) {
            case SIMPLE: {
                clazz = binding.getKey();
                break;
            }
            case CLASS: {
                clazz = binding.getImplementationClass();
                break;
            }
            case PROVIDER_CLASS: {
                clazz = binding.getProviderClass();
                break;
            }
            default: {
                return;
            }
        }
        for (Annotation annotation : clazz.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.isAnnotationPresent(javax.inject.Scope.class) || scope.isScopeAnnotationSupported(annotationType)) continue;
            throw new IllegalBindingException(String.format("Class %s cannot be scoped. It has a scope annotation: %s that is not supported by the current scope: %s", clazz.getName(), annotationType.getName(), scope.getName()));
        }
    }

    @Override
    public void checkCyclesStart(Class clazz, String name) {
        Pair pair = new Pair(clazz, name);
        LinkedHashSet<Pair> linkedHashSet = this.cycleDetectionStack.get();
        if (linkedHashSet.contains(pair)) {
            throw new CyclicDependencyException(Pair.getClassList(linkedHashSet), clazz);
        }
        linkedHashSet.add(pair);
    }

    @Override
    public void checkCyclesEnd(Class clazz, String name) {
        this.cycleDetectionStack.get().remove(new Pair(clazz, name));
    }

    private static class Pair {
        public final Class clazz;
        public final String name;

        Pair(Class clazz, String name) {
            this.clazz = clazz;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair p = (Pair)o;
            return this.equal(p.clazz, this.clazz) && this.equal(p.name, this.name);
        }

        public int hashCode() {
            return (this.clazz == null ? 0 : this.clazz.hashCode()) ^ (this.name == null ? 0 : this.name.hashCode());
        }

        private boolean equal(Object a, Object b) {
            return Objects.equals(a, b);
        }

        private static List<Class<?>> getClassList(Collection<Pair> pairCollection) {
            ArrayList classList = new ArrayList();
            for (Pair pair : pairCollection) {
                classList.add(pair.clazz);
            }
            return classList;
        }
    }
}

