/*
 * Decompiled with CFR 0.152.
 */
package toothpick.configuration;

import java.util.List;

public class CyclicDependencyException
extends RuntimeException {
    private static final int MARGIN_SIZE = 3;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    CyclicDependencyException() {
    }

    CyclicDependencyException(String message) {
        super(message);
    }

    CyclicDependencyException(String message, Throwable cause) {
        super(message, cause);
    }

    CyclicDependencyException(Throwable cause) {
        super(cause);
    }

    public CyclicDependencyException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    CyclicDependencyException(List<Class<?>> path, Class startClass) {
        this(String.format("Class %s creates a cycle:%n%s", startClass.getName(), CyclicDependencyException.format(path, startClass)));
    }

    private static String format(List<Class<?>> path, Class startClass) {
        if (path.size() == 0) {
            throw new IllegalArgumentException();
        }
        int classPosition = Math.max(path.indexOf(startClass), 0);
        path = path.subList(classPosition, path.size());
        int maxWordLength = CyclicDependencyException.findLongestClassNameLength(path);
        int middleWordPos = maxWordLength / 2 + 3;
        int loopLinePosition = maxWordLength + 6;
        StringBuilder builder = new StringBuilder();
        CyclicDependencyException.addTopLines(builder, middleWordPos, loopLinePosition);
        for (Class<?> clazz : path) {
            CyclicDependencyException.addLine(builder, clazz.getName(), middleWordPos, loopLinePosition);
            CyclicDependencyException.addLine(builder, "||", middleWordPos, loopLinePosition);
        }
        CyclicDependencyException.addHorizontalLine(builder, middleWordPos, loopLinePosition);
        return builder.toString();
    }

    private static void addTopLines(StringBuilder builder, int middleWordPos, int loopLinePosition) {
        builder.append(LINE_SEPARATOR);
        CyclicDependencyException.addHorizontalLine(builder, middleWordPos, loopLinePosition);
        CyclicDependencyException.addLine(builder, "||", middleWordPos, loopLinePosition);
        CyclicDependencyException.addLine(builder, "\\/", middleWordPos, loopLinePosition);
    }

    private static void addHorizontalLine(StringBuilder builder, int middleWordPos, int loopLinePosition) {
        builder.append(CyclicDependencyException.repeat(' ', middleWordPos));
        builder.append(CyclicDependencyException.repeat('=', loopLinePosition - middleWordPos + 1));
        builder.append(LINE_SEPARATOR);
    }

    private static void addLine(StringBuilder builder, String content, int middleWordPos, int loopLinePosition) {
        int leftMarginSize = middleWordPos - content.length() / 2;
        int rightMarginSize = loopLinePosition - leftMarginSize - content.length();
        builder.append(CyclicDependencyException.repeat(' ', leftMarginSize));
        builder.append(content);
        builder.append(CyclicDependencyException.repeat(' ', rightMarginSize));
        builder.append("||");
        builder.append(LINE_SEPARATOR);
    }

    private static int findLongestClassNameLength(List<Class<?>> path) {
        int max = 0;
        for (Class<?> clazz : path) {
            int length = clazz.getName().length();
            if (length <= max) continue;
            max = length;
        }
        return max;
    }

    private static String repeat(char c, int n) {
        return new String(new char[n]).replace('\u0000', c);
    }
}

