/*
 * Decompiled with CFR 0.152.
 */
package toothpick.compiler.common.generators;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import toothpick.compiler.common.generators.targets.ParamInjectionTarget;

public abstract class CodeGenerator {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected Types typeUtil;

    public CodeGenerator(Types typeUtil) {
        this.typeUtil = typeUtil;
    }

    public abstract String brewJava();

    protected CodeBlock getInvokeScopeGetMethodWithNameCodeBlock(ParamInjectionTarget paramInjectionTarget) {
        ClassName className;
        String scopeGetMethodName;
        String injectionName = paramInjectionTarget.name == null ? "" : ", \"" + paramInjectionTarget.name.toString() + "\"";
        switch (paramInjectionTarget.kind) {
            case INSTANCE: {
                scopeGetMethodName = "getInstance";
                className = ClassName.get((TypeElement)paramInjectionTarget.memberClass);
                break;
            }
            case PROVIDER: {
                scopeGetMethodName = "getProvider";
                className = ClassName.get((TypeElement)paramInjectionTarget.kindParamClass);
                break;
            }
            case LAZY: {
                scopeGetMethodName = "getLazy";
                className = ClassName.get((TypeElement)paramInjectionTarget.kindParamClass);
                break;
            }
            default: {
                throw new IllegalStateException("The kind can't be null.");
            }
        }
        return CodeBlock.builder().add("$L($T.class$L)", new Object[]{scopeGetMethodName, className, injectionName}).build();
    }

    protected TypeName getParamType(ParamInjectionTarget paramInjectionTarget) {
        if (paramInjectionTarget.kind == ParamInjectionTarget.Kind.INSTANCE) {
            return TypeName.get((TypeMirror)this.typeUtil.erasure(paramInjectionTarget.memberClass.asType()));
        }
        return ParameterizedTypeName.get((ClassName)ClassName.get((TypeElement)paramInjectionTarget.memberClass), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)this.typeUtil.erasure(paramInjectionTarget.kindParamClass.asType()))});
    }

    public abstract String getFqcn();

    protected static String getGeneratedFQNClassName(TypeElement typeElement) {
        return CodeGenerator.getGeneratedPackageName(typeElement) + "." + CodeGenerator.getGeneratedSimpleClassName(typeElement);
    }

    protected static String getGeneratedSimpleClassName(TypeElement typeElement) {
        String result = typeElement.getSimpleName().toString();
        while (typeElement.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            result = typeElement.getEnclosingElement().getSimpleName().toString() + "$" + result;
            typeElement = (TypeElement)typeElement.getEnclosingElement();
        }
        return result;
    }

    protected static String getSimpleClassName(ClassName className) {
        String result = "";
        List simpleNames = className.simpleNames();
        for (int i = 0; i < simpleNames.size(); ++i) {
            String name = (String)simpleNames.get(i);
            result = result + name;
            if (i == simpleNames.size() - 1) continue;
            result = result + ".";
        }
        return result;
    }

    protected static String getGeneratedPackageName(TypeElement typeElement) {
        while (typeElement.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            typeElement = (TypeElement)typeElement.getEnclosingElement();
        }
        return typeElement.getEnclosingElement().toString();
    }
}

