/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.pane.component;

import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.gui.InventoryComponent;
import com.github.stefvanschie.inventoryframework.gui.type.util.Gui;
import com.github.stefvanschie.inventoryframework.pane.Flippable;
import com.github.stefvanschie.inventoryframework.pane.Orientable;
import com.github.stefvanschie.inventoryframework.pane.Pane;
import com.github.stefvanschie.inventoryframework.pane.component.util.VariableBar;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class Slider
extends VariableBar {
    public Slider(int x, int y, int length, int height, @NotNull Pane.Priority priority) {
        super(x, y, length, height, priority);
    }

    public Slider(int x, int y, int length, int height) {
        super(x, y, length, height);
    }

    public Slider(int length, int height) {
        super(length, height);
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        int adjustedSlot = slot - (this.getX() + paneOffsetX) - inventoryComponent.getLength() * (this.getY() + paneOffsetY);
        int x = adjustedSlot % inventoryComponent.getLength();
        int y = adjustedSlot / inventoryComponent.getLength();
        if (x < 0 || x >= length || y < 0 || y >= height) {
            return false;
        }
        if (this.orientation == Orientable.Orientation.HORIZONTAL) {
            this.setValue((float)(x + 1) / (float)length);
        } else if (this.orientation == Orientable.Orientation.VERTICAL) {
            this.setValue((float)(y + 1) / (float)height);
        } else {
            throw new UnsupportedOperationException("Unknown orientation");
        }
        this.callOnClick(event);
        int newPaneOffsetX = paneOffsetX + this.getX();
        int newPaneOffsetY = paneOffsetY + this.getY();
        boolean success = this.fillPane.click(gui, inventoryComponent, event, slot, newPaneOffsetX, newPaneOffsetY, length, height) || this.backgroundPane.click(gui, inventoryComponent, event, slot, newPaneOffsetX, newPaneOffsetY, length, height);
        gui.update();
        return success;
    }

    @Override
    public void setValue(float value) {
        super.setValue(value);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Slider copy() {
        Slider slider = new Slider(this.x, this.y, this.length, this.height, this.getPriority());
        this.applyContents(slider);
        return slider;
    }

    public float getValue() {
        return this.value;
    }

    @NotNull
    @Contract(pure=true)
    public static Slider load(@NotNull Object instance, @NotNull Element element) {
        int height;
        int length;
        try {
            length = Integer.parseInt(element.getAttribute("length"));
            height = Integer.parseInt(element.getAttribute("height"));
        }
        catch (NumberFormatException exception) {
            throw new XMLLoadException(exception);
        }
        Slider slider = new Slider(length, height);
        Pane.load(slider, instance, element);
        Orientable.load(slider, element);
        Flippable.load(slider, element);
        if (element.hasAttribute("populate")) {
            return slider;
        }
        if (element.hasAttribute("value")) {
            try {
                slider.setValue(Float.parseFloat(element.getAttribute("value")));
            }
            catch (IllegalArgumentException exception) {
                throw new XMLLoadException(exception);
            }
        }
        return slider;
    }
}

