/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.pane;

import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.InventoryComponent;
import com.github.stefvanschie.inventoryframework.gui.type.util.Gui;
import com.github.stefvanschie.inventoryframework.pane.Flippable;
import com.github.stefvanschie.inventoryframework.pane.Pane;
import com.github.stefvanschie.inventoryframework.pane.Rotatable;
import com.github.stefvanschie.inventoryframework.util.GeometryUtil;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StaticPane
extends Pane
implements Flippable,
Rotatable {
    @NotNull
    private final Map<Map.Entry<Integer, Integer>, GuiItem> items;
    private int rotation;
    private boolean flipHorizontally;
    private boolean flipVertically;

    public StaticPane(int x, int y, int length, int height, @NotNull Pane.Priority priority) {
        super(x, y, length, height, priority);
        this.items = new HashMap<Map.Entry<Integer, Integer>, GuiItem>(length * height);
    }

    public StaticPane(int x, int y, int length, int height) {
        this(x, y, length, height, Pane.Priority.NORMAL);
    }

    public StaticPane(int length, int height) {
        this(0, 0, length, height);
    }

    @Override
    public void display(@NotNull InventoryComponent inventoryComponent, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        this.items.entrySet().stream().filter(entry -> ((GuiItem)entry.getValue()).isVisible()).forEach(entry -> {
            Map.Entry location = (Map.Entry)entry.getKey();
            int x = (Integer)location.getKey();
            int y = (Integer)location.getValue();
            if (this.flipHorizontally) {
                x = length - x - 1;
            }
            if (this.flipVertically) {
                y = height - y - 1;
            }
            Map.Entry<Integer, Integer> coordinates = GeometryUtil.processClockwiseRotation(x, y, length, height, this.rotation);
            x = coordinates.getKey();
            y = coordinates.getValue();
            if (x < 0 || x >= length || y < 0 || y >= height) {
                return;
            }
            GuiItem item = (GuiItem)entry.getValue();
            int finalRow = this.getY() + y + paneOffsetY;
            int finalColumn = this.getX() + x + paneOffsetX;
            inventoryComponent.setItem(item, finalColumn, finalRow);
        });
    }

    public void addItem(@NotNull GuiItem item, int x, int y) {
        this.items.keySet().removeIf(entry -> (Integer)entry.getKey() == x && (Integer)entry.getValue() == y);
        this.items.put(new AbstractMap.SimpleEntry<Integer, Integer>(x, y), item);
    }

    public void removeItem(@NotNull GuiItem item) {
        this.items.values().removeIf(guiItem -> guiItem.equals(item));
    }

    public void removeItem(int x, int y) {
        this.items.remove(new AbstractMap.SimpleEntry<Integer, Integer>(x, y));
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        int adjustedSlot = slot - (this.getX() + paneOffsetX) - inventoryComponent.getLength() * (this.getY() + paneOffsetY);
        int x = adjustedSlot % inventoryComponent.getLength();
        int y = adjustedSlot / inventoryComponent.getLength();
        if (x < 0 || x >= length || y < 0 || y >= height) {
            return false;
        }
        this.callOnClick(event);
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return false;
        }
        GuiItem clickedItem = StaticPane.findMatchingItem(this.items.values(), itemStack);
        if (clickedItem == null) {
            return false;
        }
        clickedItem.callAction(event);
        return true;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public StaticPane copy() {
        StaticPane staticPane = new StaticPane(this.x, this.y, this.length, this.height, this.getPriority());
        for (Map.Entry<Map.Entry<Integer, Integer>, GuiItem> entry : this.items.entrySet()) {
            Map.Entry<Integer, Integer> coordinates = entry.getKey();
            staticPane.addItem(entry.getValue().copy(), coordinates.getKey(), coordinates.getValue());
        }
        staticPane.setVisible(this.isVisible());
        staticPane.onClick = this.onClick;
        staticPane.uuid = this.uuid;
        staticPane.rotation = this.rotation;
        staticPane.flipHorizontally = this.flipHorizontally;
        staticPane.flipVertically = this.flipVertically;
        return staticPane;
    }

    @Override
    public void setRotation(int rotation) {
        if (this.length != this.height) {
            throw new UnsupportedOperationException("length and height are different");
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("rotation isn't divisible by 90");
        }
        this.rotation = rotation % 360;
    }

    public void fillWith(@NotNull ItemStack itemStack, @Nullable Consumer<InventoryClickEvent> action) {
        Set<Map.Entry<Integer, Integer>> locations = this.items.keySet();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getLength(); ++x) {
                boolean found = false;
                for (Map.Entry<Integer, Integer> location : locations) {
                    if (location.getKey() != x || location.getValue() != y) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.addItem(new GuiItem(itemStack, action), x, y);
            }
        }
    }

    @Contract(value="null -> fail")
    public void fillWith(@NotNull ItemStack itemStack) {
        this.fillWith(itemStack, null);
    }

    @Override
    @NotNull
    public Collection<GuiItem> getItems() {
        return this.items.values();
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Collection<Pane> getPanes() {
        return new HashSet<Pane>();
    }

    @Override
    public void flipHorizontally(boolean flipHorizontally) {
        this.flipHorizontally = flipHorizontally;
    }

    @Override
    public void flipVertically(boolean flipVertically) {
        this.flipVertically = flipVertically;
    }

    @Override
    @Contract(pure=true)
    public int getRotation() {
        return this.rotation;
    }

    @Override
    @Contract(pure=true)
    public boolean isFlippedHorizontally() {
        return this.flipHorizontally;
    }

    @Override
    @Contract(pure=true)
    public boolean isFlippedVertically() {
        return this.flipVertically;
    }

    @NotNull
    public static StaticPane load(@NotNull Object instance, @NotNull Element element) {
        try {
            StaticPane staticPane = new StaticPane(Integer.parseInt(element.getAttribute("length")), Integer.parseInt(element.getAttribute("height")));
            Pane.load(staticPane, instance, element);
            Flippable.load(staticPane, element);
            Rotatable.load(staticPane, element);
            if (element.hasAttribute("populate")) {
                return staticPane;
            }
            NodeList childNodes = element.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (item.getNodeType() != 1) continue;
                Element child = (Element)item;
                staticPane.addItem(Pane.loadItem(instance, child), Integer.parseInt(child.getAttribute("x")), Integer.parseInt(child.getAttribute("y")));
            }
            return staticPane;
        }
        catch (NumberFormatException exception) {
            throw new XMLLoadException(exception);
        }
    }
}

