/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_16_2_3;

import com.github.stefvanschie.inventoryframework.abstraction.GrindstoneInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_16_2_3.util.TextHolderUtil;
import java.lang.reflect.Field;
import net.minecraft.server.v1_16_R2.Container;
import net.minecraft.server.v1_16_R2.ContainerGrindstone;
import net.minecraft.server.v1_16_R2.Containers;
import net.minecraft.server.v1_16_R2.EntityHuman;
import net.minecraft.server.v1_16_R2.EntityPlayer;
import net.minecraft.server.v1_16_R2.IChatBaseComponent;
import net.minecraft.server.v1_16_R2.IInventory;
import net.minecraft.server.v1_16_R2.NonNullList;
import net.minecraft.server.v1_16_R2.Packet;
import net.minecraft.server.v1_16_R2.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_16_R2.PacketPlayOutSetSlot;
import net.minecraft.server.v1_16_R2.PacketPlayOutWindowItems;
import net.minecraft.server.v1_16_R2.PlayerConnection;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftInventoryGrindstone;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrindstoneInventoryImpl
extends GrindstoneInventory {
    public GrindstoneInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for a grindstone should be 3, but is '" + itemAmount + "'");
        }
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        ContainerGrindstoneImpl containerGrindstone = new ContainerGrindstoneImpl(entityPlayer, items);
        entityPlayer.activeContainer = containerGrindstone;
        int id = containerGrindstone.windowId;
        IChatBaseComponent message = TextHolderUtil.toComponent(title);
        PacketPlayOutOpenWindow packet = new PacketPlayOutOpenWindow(id, Containers.GRINDSTONE, message);
        entityPlayer.playerConnection.sendPacket((Packet)packet);
        this.sendItems(player, items, null);
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items, @Nullable ItemStack cursor) {
        NonNullList nmsItems = NonNullList.a((Object)net.minecraft.server.v1_16_R2.ItemStack.b, (Object[])new net.minecraft.server.v1_16_R2.ItemStack[]{CraftItemStack.asNMSCopy((ItemStack)items[0]), CraftItemStack.asNMSCopy((ItemStack)items[1]), CraftItemStack.asNMSCopy((ItemStack)items[2])});
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        this.getPlayerConnection(entityPlayer).sendPacket((Packet)new PacketPlayOutWindowItems(this.getWindowId(entityPlayer), nmsItems));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        this.getPlayerConnection(this.getEntityPlayer(player)).sendPacket((Packet)new PacketPlayOutSetSlot(-1, -1, net.minecraft.server.v1_16_R2.ItemStack.b));
    }

    @Contract(pure=true)
    private int getWindowId(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.activeContainer.windowId;
    }

    @NotNull
    @Contract(pure=true)
    private PlayerConnection getPlayerConnection(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.playerConnection;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getEntityPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerGrindstoneImpl
    extends ContainerGrindstone {
        @NotNull
        private final Player player;
        @Nullable
        private CraftInventoryView bukkitEntity;
        @NotNull
        private final Field craftInventoryField;
        @NotNull
        private final Field resultInventoryField;

        public ContainerGrindstoneImpl(@Nullable EntityPlayer entityPlayer, ItemStack[] items) {
            super(entityPlayer.nextContainerCounter(), entityPlayer.inventory);
            this.player = entityPlayer.getBukkitEntity();
            try {
                this.craftInventoryField = ContainerGrindstone.class.getDeclaredField("craftInventory");
                this.craftInventoryField.setAccessible(true);
                this.resultInventoryField = ContainerGrindstone.class.getDeclaredField("resultInventory");
                this.resultInventoryField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException(exception);
            }
            this.getCraftInventory().setItem(0, CraftItemStack.asNMSCopy((ItemStack)items[0]));
            this.getCraftInventory().setItem(1, CraftItemStack.asNMSCopy((ItemStack)items[1]));
            this.getResultInventory().setItem(2, CraftItemStack.asNMSCopy((ItemStack)items[2]));
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity == null) {
                CraftInventoryGrindstone inventory = new CraftInventoryGrindstone(this.getCraftInventory(), this.getResultInventory()){

                    @NotNull
                    @Contract(pure=true)
                    public InventoryHolder getHolder() {
                        return GrindstoneInventoryImpl.this.inventoryHolder;
                    }
                };
                this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, (Inventory)inventory, (Container)this);
            }
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean canUse(@Nullable EntityHuman entityhuman) {
            return true;
        }

        public void a(IInventory inventory) {
        }

        public void b(EntityHuman entityhuman) {
        }

        @NotNull
        @Contract(pure=true)
        private IInventory getCraftInventory() {
            try {
                return (IInventory)this.craftInventoryField.get((Object)this);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }

        @NotNull
        @Contract(pure=true)
        private IInventory getResultInventory() {
            try {
                return (IInventory)this.resultInventoryField.get((Object)this);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

