/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.gui.type.util;

import com.github.stefvanschie.inventoryframework.adventuresupport.StringHolder;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.gui.type.util.Gui;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class NamedGui
extends Gui {
    @NotNull
    private TextHolder title;
    private boolean dirty = false;

    public NamedGui(@NotNull String title) {
        this(StringHolder.of(title));
    }

    public NamedGui(@NotNull TextHolder title) {
        this.title = title;
    }

    public void setTitle(@NotNull String title) {
        this.setTitle(StringHolder.of(title));
    }

    public void setTitle(@NotNull TextHolder title) {
        this.title = title;
        this.dirty = true;
    }

    @NotNull
    @Contract(pure=true)
    public String getTitle() {
        return this.title.asLegacyString();
    }

    @NotNull
    @Contract(pure=true)
    public TextHolder getTitleHolder() {
        return this.title;
    }

    @Contract(pure=true)
    public boolean isDirty() {
        return this.dirty;
    }

    public void markChanges() {
        this.dirty = false;
    }
}

