/*
 * Decompiled with CFR 0.152.
 */
package stonehorse.candy;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class Trampoline {
    private Trampoline() {
    }

    public static <V> Continuation<V> recur(Supplier<Continuation<V>> f) {
        return new Continuation(f, null, false);
    }

    public static <V> Continuation<V> done(V v) {
        return new Continuation(null, v, true);
    }

    public static <V> Continuation<V> stop() {
        return new Continuation(null, null, false);
    }

    public static <V> Continuation<V> seq(Supplier<Continuation<V>> f, V v) {
        return new Continuation(f, v, true);
    }

    public static <V> V trampoline(Supplier<Continuation<V>> fun) {
        boolean value = false;
        Continuation<V> ret = Continuation.nil();
        while (fun != null && !value) {
            ret = fun.get();
            fun = ret.fun;
            value = ret.hasValue;
        }
        return ret.value;
    }

    public static <A, V> Iterable<V> lazy(Supplier<Continuation<V>> fun) {
        return () -> new LazyIterator(fun);
    }

    private static class LazyIterator<V>
    implements Iterator<V> {
        private Supplier<Continuation<V>> fun;
        private V next;
        private boolean hasNext = false;

        public LazyIterator(Supplier<Continuation<V>> fun) {
            this.fun = fun;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                return true;
            }
            if (null == this.fun) {
                return false;
            }
            do {
                Continuation<V> ret;
                if (null == (ret = this.fun.get())) {
                    return false;
                }
                this.fun = ret.fun;
                this.next = ret.value;
                this.hasNext = ret.hasValue;
                if (!this.hasNext) continue;
                return true;
            } while (null != this.fun);
            return false;
        }

        @Override
        public V next() {
            if (this.hasNext()) {
                try {
                    this.hasNext = false;
                    V v = this.next;
                    return v;
                }
                finally {
                    this.next = null;
                }
            }
            throw new NoSuchElementException();
        }
    }

    public static class Continuation<V> {
        public final Supplier<Continuation<V>> fun;
        public final V value;
        public final boolean hasValue;

        private Continuation(Supplier<Continuation<V>> fun, V value, boolean hasValue) {
            this.fun = fun;
            this.value = value;
            this.hasValue = hasValue;
        }

        private static <V> Continuation<V> nil() {
            return new Continuation<Object>(null, null, false);
        }
    }
}

