/*
 * Decompiled with CFR 0.152.
 */
package stonehorse.candy;

import java.util.Objects;
import java.util.function.Function;

public class Identity<T> {
    private final T t;

    private Identity(T t) {
        this.t = t;
    }

    public static <T> Identity<T> identity(T t) {
        return new Identity<T>(t);
    }

    public T get() {
        return this.t;
    }

    public static <T> T get(Identity<? extends T> t) {
        return t.get();
    }

    public <V> Identity<V> map(Function<? super T, ? extends V> f) {
        return Identity.identity(f.apply(this.t));
    }

    public <V> Identity<V> flatmap(Function<? super T, Identity<V>> f) {
        return f.apply(this.t);
    }

    public String toString() {
        return "Identity[" + this.t + "]";
    }

    public int hashCode() {
        return Objects.hashCode(this.t);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Identity)) {
            return false;
        }
        return Objects.equals(this.t, ((Identity)obj).t);
    }

    public static <T, V> Identity<T> map(Function<? super V, ? extends T> f, Identity<V> v) {
        return v.map(f);
    }

    public static <T, V> Identity<T> flatmap(Function<? super V, Identity<T>> f, Identity<V> v) {
        return v.flatmap(f);
    }
}

