/*
 * Decompiled with CFR 0.152.
 */
package stonehorse.candy;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import stonehorse.candy.NullableBooleans;

public class Functions {
    private Functions() {
    }

    public static <T, V> Supplier<V> supplier(Function<? super T, ? extends V> f, T t) {
        Objects.requireNonNull(f);
        return () -> f.apply((Object)t);
    }

    public static <T, U, V> Function<U, V> function(BiFunction<? super T, ? super U, ? extends V> f, T t) {
        Objects.requireNonNull(f);
        return a -> f.apply((Object)t, (Object)a);
    }

    public static <T> Function<T, Boolean> complement(Predicate<? super T> f) {
        Objects.requireNonNull(f);
        return a -> NullableBooleans.not(f.test(a));
    }

    public static <V, U extends V> Function<U, V> identity() {
        return t -> t;
    }

    public static <A, B, V> Function<A, V> compose(Function<? super A, ? extends B> f1, Function<? super B, ? extends V> f2) {
        Objects.requireNonNull(f1);
        Objects.requireNonNull(f2);
        return a -> f2.apply((Object)f1.apply((Object)a));
    }
}

