/*
 * Decompiled with CFR 0.152.
 */
package github.com.st235.lib_expandablebottombar.components;

import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.appcompat.widget.AppCompatTextView;
import github.com.st235.lib_expandablebottombar.NotificationBadge;
import github.com.st235.lib_expandablebottombar.R;
import github.com.st235.lib_expandablebottombar.components.notifications.ExpandableBottomBarNotificationBadgeView;
import github.com.st235.lib_expandablebottombar.state.MenuItemSavedState;
import github.com.st235.lib_expandablebottombar.utils.DrawableHelper;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0018J\u0012\u0010\u001a\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001cH\u0014J\u0006\u0010\u001e\u001a\u00020\u0018J\u0018\u0010\u001f\u001a\u00020\u00182\b\b\u0001\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\"J\b\u0010'\u001a\u00020\u0018H\u0016J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010$\u001a\u00020(H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u00020\b2\b\b\u0001\u0010\f\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R&\u0010\u0012\u001a\u00020\b2\b\b\u0001\u0010\f\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lgithub/com/st235/lib_expandablebottombar/components/MenuItemView;", "Landroid/widget/LinearLayout;", "Lgithub/com/st235/lib_expandablebottombar/NotificationBadge;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "iconView", "Lgithub/com/st235/lib_expandablebottombar/components/notifications/ExpandableBottomBarNotificationBadgeView;", "value", "notificationBadgeBackgroundColor", "getNotificationBadgeBackgroundColor", "()I", "setNotificationBadgeBackgroundColor", "(I)V", "notificationBadgeTextColor", "getNotificationBadgeTextColor", "setNotificationBadgeTextColor", "titleView", "Landroidx/appcompat/widget/AppCompatTextView;", "clearNotification", "", "deselect", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "select", "setIcon", "drawableRes", "backgroundColorSelector", "Landroid/content/res/ColorStateList;", "setText", "text", "", "textColorSelector", "showNotification", "", "lib-expandablebottombar_release"})
public final class MenuItemView
extends LinearLayout
implements NotificationBadge {
    @NotNull
    private final ExpandableBottomBarNotificationBadgeView iconView;
    @NotNull
    private final AppCompatTextView titleView;

    @JvmOverloads
    public MenuItemView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        LinearLayout.inflate((Context)context, (int)R.layout.content_bottombar_menu_item, (ViewGroup)((ViewGroup)this));
        View view = this.findViewById(R.id.icon_view);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.icon_view)");
        this.iconView = (ExpandableBottomBarNotificationBadgeView)view;
        View view2 = this.findViewById(R.id.title_view);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.title_view)");
        this.titleView = (AppCompatTextView)view2;
        this.setOrientation(0);
        this.setGravity(17);
        this.setFocusable(true);
        this.setClipToPadding(false);
        this.setClipChildren(false);
    }

    public /* synthetic */ MenuItemView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Override
    public int getNotificationBadgeBackgroundColor() {
        return this.iconView.getBadgeColor();
    }

    @Override
    public void setNotificationBadgeBackgroundColor(@ColorInt int value) {
        this.iconView.setBadgeColor(value);
    }

    @Override
    public int getNotificationBadgeTextColor() {
        return this.iconView.getBadgeTextColor();
    }

    @Override
    public void setNotificationBadgeTextColor(@ColorInt int value) {
        this.iconView.setBadgeTextColor(value);
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        return new MenuItemSavedState(this.iconView.getState(), super.onSaveInstanceState());
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        if (!(state instanceof MenuItemSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        super.onRestoreInstanceState(((MenuItemSavedState)state).getSuperState());
        this.iconView.restore(((MenuItemSavedState)state).getBadgeState());
    }

    public final void setIcon(@DrawableRes int drawableRes, @NotNull ColorStateList backgroundColorSelector) {
        Intrinsics.checkNotNullParameter((Object)backgroundColorSelector, (String)"backgroundColorSelector");
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.iconView.setImageDrawable(DrawableHelper.INSTANCE.createDrawable(context, drawableRes, backgroundColorSelector));
    }

    public final void setText(@NotNull CharSequence text, @NotNull ColorStateList textColorSelector) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)textColorSelector, (String)"textColorSelector");
        this.titleView.setText(text);
        this.titleView.setTextColor(textColorSelector);
    }

    public final void select() {
        this.titleView.setVisibility(0);
        this.titleView.setSelected(true);
        this.iconView.setSelected(true);
        this.setSelected(true);
    }

    public final void deselect() {
        this.titleView.setVisibility(8);
        this.titleView.setSelected(false);
        this.iconView.setSelected(false);
        this.setSelected(false);
    }

    @Override
    public void showNotification() {
        this.iconView.setShowBadge(true);
        this.iconView.setBadgeText(null);
    }

    @Override
    public void showNotification(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (text.length() > 4) {
            throw new IllegalArgumentException("Text is longer than 4 symbols, which is not acceptable");
        }
        this.iconView.setShowBadge(true);
        this.iconView.setBadgeText(text);
    }

    @Override
    public void clearNotification() {
        this.iconView.setShowBadge(false);
        this.iconView.setBadgeText(null);
    }

    @JvmOverloads
    public MenuItemView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public MenuItemView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

