/*
 * Decompiled with CFR 0.152.
 */
package github.com.st235.lib_expandablebottombar;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.Px;
import androidx.annotation.VisibleForTesting;
import github.com.st235.lib_expandablebottombar.ExpandableBottomBar;
import github.com.st235.lib_expandablebottombar.MenuItem;
import github.com.st235.lib_expandablebottombar.MenuItemDescriptor;
import github.com.st235.lib_expandablebottombar.MenuItemImpl;
import github.com.st235.lib_expandablebottombar.R;
import github.com.st235.lib_expandablebottombar.components.MenuItemView;
import github.com.st235.lib_expandablebottombar.utils.DrawableHelper;
import github.com.st235.lib_expandablebottombar.utils.StyleController;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\u0007\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\n\u0012\b\b\u0001\u0010\f\u001a\u00020\u0007\u0012\b\b\u0001\u0010\r\u001a\u00020\u0007\u0012\b\b\u0001\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0015J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0011\u00a2\u0006\u0002\b\u001fR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lgithub/com/st235/lib_expandablebottombar/MenuItemFactory;", "", "rootView", "Lgithub/com/st235/lib_expandablebottombar/ExpandableBottomBar;", "styleController", "Lgithub/com/st235/lib_expandablebottombar/utils/StyleController;", "itemVerticalPadding", "", "itemHorizontalPadding", "backgroundCornerRadius", "", "backgroundOpacity", "itemInactiveColor", "globalNotificationBadgeColor", "globalNotificationBadgeTextColor", "(Lgithub/com/st235/lib_expandablebottombar/ExpandableBottomBar;Lgithub/com/st235/lib_expandablebottombar/utils/StyleController;IIFFIII)V", "build", "Lgithub/com/st235/lib_expandablebottombar/MenuItemImpl;", "menuItemDescriptor", "Lgithub/com/st235/lib_expandablebottombar/MenuItemDescriptor;", "onItemClickListener", "Lkotlin/Function2;", "Lgithub/com/st235/lib_expandablebottombar/MenuItem;", "Landroid/view/View;", "", "createHighlightedMenuShape", "Landroid/graphics/drawable/Drawable;", "createItemView", "Lgithub/com/st235/lib_expandablebottombar/components/MenuItemView;", "context", "Landroid/content/Context;", "createItemView$lib_expandablebottombar_release", "lib-expandablebottombar_release"})
public class MenuItemFactory {
    @NotNull
    private final ExpandableBottomBar rootView;
    @NotNull
    private final StyleController styleController;
    private final int itemVerticalPadding;
    private int itemHorizontalPadding;
    private float backgroundCornerRadius;
    private float backgroundOpacity;
    private int itemInactiveColor;
    private int globalNotificationBadgeColor;
    private int globalNotificationBadgeTextColor;

    public MenuItemFactory(@NotNull ExpandableBottomBar rootView, @NotNull StyleController styleController, @Px int itemVerticalPadding, @Px int itemHorizontalPadding, @Px float backgroundCornerRadius, @FloatRange(from=0.0, to=1.0) float backgroundOpacity, @ColorInt int itemInactiveColor, @ColorInt int globalNotificationBadgeColor, @ColorInt int globalNotificationBadgeTextColor) {
        Intrinsics.checkNotNullParameter((Object)((Object)rootView), (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)styleController, (String)"styleController");
        this.rootView = rootView;
        this.styleController = styleController;
        this.itemVerticalPadding = itemVerticalPadding;
        this.itemHorizontalPadding = itemHorizontalPadding;
        this.backgroundCornerRadius = backgroundCornerRadius;
        this.backgroundOpacity = backgroundOpacity;
        this.itemInactiveColor = itemInactiveColor;
        this.globalNotificationBadgeColor = globalNotificationBadgeColor;
        this.globalNotificationBadgeTextColor = globalNotificationBadgeTextColor;
    }

    @NotNull
    public final MenuItemImpl build(@NotNull MenuItemDescriptor menuItemDescriptor, @NotNull Function2<? super MenuItem, ? super View, Unit> onItemClickListener) {
        Intrinsics.checkNotNullParameter((Object)menuItemDescriptor, (String)"menuItemDescriptor");
        Intrinsics.checkNotNullParameter(onItemClickListener, (String)"onItemClickListener");
        Context context = this.rootView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"rootView.context");
        Context context2 = context;
        MenuItemView itemView = this.createItemView$lib_expandablebottombar_release(context2);
        MenuItemImpl menuItem2 = new MenuItemImpl(menuItemDescriptor, this.rootView, itemView, null, null, 24, null);
        ColorStateList backgroundColorStateList = DrawableHelper.INSTANCE.createSelectedUnselectedStateList(menuItemDescriptor.getActiveColor(), this.itemInactiveColor);
        MenuItemView $this$build_u24lambda_u2d1 = itemView;
        boolean bl = false;
        $this$build_u24lambda_u2d1.setId(menuItemDescriptor.getItemId());
        Object[] objectArray = new Object[]{menuItemDescriptor.getText()};
        $this$build_u24lambda_u2d1.setContentDescription(context2.getResources().getString(R.string.accessibility_item_description, objectArray));
        $this$build_u24lambda_u2d1.setPadding(this.itemHorizontalPadding, this.itemVerticalPadding, this.itemHorizontalPadding, this.itemVerticalPadding);
        $this$build_u24lambda_u2d1.setIcon(menuItemDescriptor.getIconId(), backgroundColorStateList);
        $this$build_u24lambda_u2d1.setText(menuItemDescriptor.getText(), backgroundColorStateList);
        Integer n = menuItemDescriptor.getBadgeBackgroundColor();
        $this$build_u24lambda_u2d1.setNotificationBadgeBackgroundColor(n != null ? n : this.globalNotificationBadgeColor);
        Integer n2 = menuItemDescriptor.getBadgeTextColor();
        $this$build_u24lambda_u2d1.setNotificationBadgeTextColor(n2 != null ? n2 : this.globalNotificationBadgeTextColor);
        $this$build_u24lambda_u2d1.setBackground(this.createHighlightedMenuShape(menuItemDescriptor));
        $this$build_u24lambda_u2d1.setOnClickListener(arg_0 -> MenuItemFactory.build$lambda-1$lambda-0(onItemClickListener, menuItem2, arg_0));
        return menuItem2;
    }

    @VisibleForTesting
    @NotNull
    public MenuItemView createItemView$lib_expandablebottombar_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new MenuItemView(context, null, 0, 6, null);
    }

    private final Drawable createHighlightedMenuShape(MenuItemDescriptor menuItemDescriptor) {
        return this.styleController.createStateBackground(menuItemDescriptor.getActiveColor(), this.backgroundCornerRadius, this.backgroundOpacity);
    }

    private static final void build$lambda-1$lambda-0(Function2 $onItemClickListener, MenuItemImpl $menuItem, View it) {
        Intrinsics.checkNotNullParameter((Object)$onItemClickListener, (String)"$onItemClickListener");
        Intrinsics.checkNotNullParameter((Object)$menuItem, (String)"$menuItem");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $onItemClickListener.invoke((Object)$menuItem, (Object)it);
    }
}

