/*
 * Decompiled with CFR 0.152.
 */
package github.com.st235.lib_expandablebottombar;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.IdRes;
import github.com.st235.lib_expandablebottombar.ExpandableBottomBar;
import github.com.st235.lib_expandablebottombar.Menu;
import github.com.st235.lib_expandablebottombar.MenuItem;
import github.com.st235.lib_expandablebottombar.MenuItemDescriptor;
import github.com.st235.lib_expandablebottombar.MenuItemFactory;
import github.com.st235.lib_expandablebottombar.MenuItemImpl;
import github.com.st235.lib_expandablebottombar.utils.TransitionHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\t\b\u0000\u0018\u0000 >2\u00020\u0001:\u0001>B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020/H\u0002J\b\u00102\u001a\u00020 H\u0016J\u0012\u00103\u001a\u00020\u00102\b\b\u0001\u00104\u001a\u00020\u0007H\u0016J\u000f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001006H\u0096\u0002J\b\u00107\u001a\u00020 H\u0002J\u0012\u00108\u001a\u00020 2\b\b\u0001\u00104\u001a\u00020\u0007H\u0016J\b\u00109\u001a\u00020 H\u0016J\u0012\u0010:\u001a\u00020 2\b\b\u0001\u00104\u001a\u00020\u0007H\u0016J\u0010\u0010;\u001a\u00020 2\u0006\u0010<\u001a\u00020\u0010H\u0002J\b\u0010=\u001a\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u0014j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rg\u0010\u0017\u001aO\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u001e\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 \u0018\u00010\u0018j\u0004\u0018\u0001`!X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%Rg\u0010&\u001aO\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u001e\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 \u0018\u00010\u0018j\u0004\u0018\u0001`!X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0012\u0010,\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lgithub/com/st235/lib_expandablebottombar/MenuImpl;", "Lgithub/com/st235/lib_expandablebottombar/Menu;", "rootView", "Lgithub/com/st235/lib_expandablebottombar/ExpandableBottomBar;", "itemFactory", "Lgithub/com/st235/lib_expandablebottombar/MenuItemFactory;", "menuItemHorizontalMargin", "", "menuItemVerticalMargin", "transitionDuration", "", "transitionHelper", "Lgithub/com/st235/lib_expandablebottombar/utils/TransitionHelper;", "(Lgithub/com/st235/lib_expandablebottombar/ExpandableBottomBar;Lgithub/com/st235/lib_expandablebottombar/MenuItemFactory;IIJLgithub/com/st235/lib_expandablebottombar/utils/TransitionHelper;)V", "items", "", "Lgithub/com/st235/lib_expandablebottombar/MenuItem;", "getItems", "()Ljava/util/List;", "itemsLookup", "Ljava/util/LinkedHashMap;", "Lgithub/com/st235/lib_expandablebottombar/MenuItemImpl;", "Lkotlin/collections/LinkedHashMap;", "onItemReselectedListener", "Lkotlin/Function3;", "Landroid/view/View;", "Lkotlin/ParameterName;", "name", "v", "menuItem", "", "byUser", "", "Lgithub/com/st235/lib_expandablebottombar/OnItemClickListener;", "getOnItemReselectedListener", "()Lkotlin/jvm/functions/Function3;", "setOnItemReselectedListener", "(Lkotlin/jvm/functions/Function3;)V", "onItemSelectedListener", "getOnItemSelectedListener", "setOnItemSelectedListener", "selectedItem", "getSelectedItem", "()Lgithub/com/st235/lib_expandablebottombar/MenuItem;", "selectedItemId", "add", "descriptor", "Lgithub/com/st235/lib_expandablebottombar/MenuItemDescriptor;", "createItem", "menuItemDescriptor", "deselect", "findItemById", "id", "iterator", "", "reconnectConstraints", "remove", "removeAll", "select", "selectItemInternal", "activeMenuItem", "updateAccessibility", "Companion", "lib-expandablebottombar_release"})
public final class MenuImpl
implements Menu {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ExpandableBottomBar rootView;
    @NotNull
    private final MenuItemFactory itemFactory;
    private final int menuItemHorizontalMargin;
    private final int menuItemVerticalMargin;
    private final long transitionDuration;
    @NotNull
    private final TransitionHelper transitionHelper;
    @IdRes
    private int selectedItemId;
    @NotNull
    private final LinkedHashMap<Integer, MenuItemImpl> itemsLookup;
    @Nullable
    private Function3<? super View, ? super MenuItem, ? super Boolean, Unit> onItemSelectedListener;
    @Nullable
    private Function3<? super View, ? super MenuItem, ? super Boolean, Unit> onItemReselectedListener;
    @Deprecated
    public static final int ITEM_NOT_SELECTED = -1;

    public MenuImpl(@NotNull ExpandableBottomBar rootView, @NotNull MenuItemFactory itemFactory, int menuItemHorizontalMargin, int menuItemVerticalMargin, long transitionDuration, @NotNull TransitionHelper transitionHelper) {
        Intrinsics.checkNotNullParameter((Object)((Object)rootView), (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)itemFactory, (String)"itemFactory");
        Intrinsics.checkNotNullParameter((Object)transitionHelper, (String)"transitionHelper");
        this.rootView = rootView;
        this.itemFactory = itemFactory;
        this.menuItemHorizontalMargin = menuItemHorizontalMargin;
        this.menuItemVerticalMargin = menuItemVerticalMargin;
        this.transitionDuration = transitionDuration;
        this.transitionHelper = transitionHelper;
        this.selectedItemId = -1;
        this.itemsLookup = new LinkedHashMap();
    }

    public /* synthetic */ MenuImpl(ExpandableBottomBar expandableBottomBar, MenuItemFactory menuItemFactory, int n, int n2, long l, TransitionHelper transitionHelper, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x20) != 0) {
            transitionHelper = new TransitionHelper();
        }
        this(expandableBottomBar, menuItemFactory, n, n2, l, transitionHelper);
    }

    @Override
    @Nullable
    public MenuItem getSelectedItem() {
        if (this.selectedItemId == -1) {
            return null;
        }
        return (MenuItem)MapsKt.getValue((Map)this.itemsLookup, (Object)this.selectedItemId);
    }

    @Override
    @NotNull
    public List<MenuItem> getItems() {
        return new ArrayList<MenuItemImpl>(this.itemsLookup.values());
    }

    @Override
    @Nullable
    public Function3<View, MenuItem, Boolean, Unit> getOnItemSelectedListener() {
        return this.onItemSelectedListener;
    }

    @Override
    public void setOnItemSelectedListener(@Nullable Function3<? super View, ? super MenuItem, ? super Boolean, Unit> function3) {
        this.onItemSelectedListener = function3;
    }

    @Override
    @Nullable
    public Function3<View, MenuItem, Boolean, Unit> getOnItemReselectedListener() {
        return this.onItemReselectedListener;
    }

    @Override
    public void setOnItemReselectedListener(@Nullable Function3<? super View, ? super MenuItem, ? super Boolean, Unit> function3) {
        this.onItemReselectedListener = function3;
    }

    @Override
    @NotNull
    public Iterator<MenuItem> iterator() {
        return this.getItems().iterator();
    }

    @Override
    public void add(@NotNull MenuItemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.transitionHelper.apply((ViewGroup)this.rootView, this.transitionDuration);
        if (this.selectedItemId == -1) {
            this.selectedItemId = descriptor.getItemId();
        }
        MenuItemImpl item = this.createItem(descriptor);
        ((Map)this.itemsLookup).put(descriptor.getItemId(), item);
        item.attachToSuperView(this.menuItemHorizontalMargin, this.menuItemVerticalMargin);
        this.reconnectConstraints();
        this.updateAccessibility();
    }

    private final void reconnectConstraints() {
        List<MenuItem> itemsList = this.getItems();
        Iterator<MenuItem> iterator = itemsList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            MenuItem item = iterator.next();
            int prevIconId = index - 1 < 0 ? ((MenuItem)CollectionsKt.first(itemsList)).getId() : itemsList.get(index - 1).getId();
            int nextIconId = index + 1 >= itemsList.size() ? ((MenuItem)CollectionsKt.last(itemsList)).getId() : itemsList.get(index + 1).getId();
            MenuItemImpl menuItemImpl = item instanceof MenuItemImpl ? (MenuItemImpl)item : null;
            if (menuItemImpl == null) continue;
            menuItemImpl.rebuildSiblingsConnection(prevIconId, nextIconId);
        }
    }

    @Override
    public void select(@IdRes int id) {
        block1: {
            if (!this.itemsLookup.containsKey(id)) {
                throw new IllegalArgumentException("Cannot select item with id " + id + " because it was not found in the menu");
            }
            this.selectItemInternal((MenuItem)MapsKt.getValue((Map)this.itemsLookup, (Object)id));
            MenuItem menuItem2 = this.getSelectedItem();
            Intrinsics.checkNotNull((Object)menuItem2);
            MenuItemImpl selectedItem = (MenuItemImpl)menuItem2;
            Function3<View, MenuItem, Boolean, Unit> function3 = this.getOnItemSelectedListener();
            if (function3 == null) break block1;
            function3.invoke((Object)selectedItem.getView(), (Object)selectedItem, (Object)false);
        }
    }

    @Override
    public void deselect() {
        block3: {
            Object v0;
            block2: {
                if (this.itemsLookup.isEmpty()) {
                    return;
                }
                Iterable iterable = this.getItems();
                for (Object t : iterable) {
                    MenuItem it = (MenuItem)t;
                    boolean bl = false;
                    if (!(it.isAttached() && it.isShown())) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            Intrinsics.checkNotNull(v0, (String)"null cannot be cast to non-null type github.com.st235.lib_expandablebottombar.MenuItemImpl");
            MenuItemImpl firstMenuItem = v0;
            this.selectItemInternal(firstMenuItem);
            Function3<View, MenuItem, Boolean, Unit> function3 = this.getOnItemSelectedListener();
            if (function3 == null) break block3;
            function3.invoke((Object)firstMenuItem.getView(), (Object)firstMenuItem, (Object)false);
        }
    }

    @Override
    public void remove(@IdRes int id) {
        if (!this.itemsLookup.containsKey(id)) {
            throw new IllegalArgumentException("Cannot remove item with id " + id + " because it was not found in the menu");
        }
        this.transitionHelper.apply((ViewGroup)this.rootView, this.transitionDuration);
        MenuItemImpl menuItemToRemove = (MenuItemImpl)MapsKt.getValue((Map)this.itemsLookup, (Object)id);
        menuItemToRemove.removeFromSuperView();
        this.itemsLookup.remove(id);
        this.reconnectConstraints();
        if (this.selectedItemId == id) {
            this.deselect();
        }
    }

    @Override
    public void removeAll() {
        this.itemsLookup.clear();
    }

    @Override
    @NotNull
    public MenuItem findItemById(@IdRes int id) {
        if (!this.itemsLookup.containsKey(id)) {
            throw new IllegalArgumentException("Cannot find item with id " + id);
        }
        return (MenuItem)MapsKt.getValue((Map)this.itemsLookup, (Object)id);
    }

    private final void selectItemInternal(MenuItem activeMenuItem) {
        if (this.selectedItemId == activeMenuItem.getId()) {
            return;
        }
        this.transitionHelper.apply((ViewGroup)this.rootView, this.transitionDuration);
        ((MenuItemImpl)MapsKt.getValue((Map)this.itemsLookup, (Object)activeMenuItem.getId())).select();
        MenuItemImpl menuItemImpl = this.itemsLookup.get(this.selectedItemId);
        if (menuItemImpl != null) {
            menuItemImpl.deselect();
        }
        this.selectedItemId = activeMenuItem.getId();
    }

    private final MenuItemImpl createItem(MenuItemDescriptor menuItemDescriptor) {
        MenuItemImpl menuItem2 = this.itemFactory.build(menuItemDescriptor, (Function2<? super MenuItem, ? super View, Unit>)((Function2)new Function2<MenuItem, View, Unit>(this){
            final /* synthetic */ MenuImpl this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull MenuItem menuItem2, @NotNull View v) {
                block1: {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)menuItem2, (String)"menuItem");
                        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                        if (v.isSelected()) break block0;
                        MenuImpl.access$selectItemInternal(this.this$0, menuItem2);
                        Function3<View, MenuItem, Boolean, Unit> function3 = this.this$0.getOnItemSelectedListener();
                        if (function3 == null) break block1;
                        function3.invoke((Object)v, (Object)menuItem2, (Object)true);
                        break block1;
                    }
                    Function3<View, MenuItem, Boolean, Unit> function3 = this.this$0.getOnItemReselectedListener();
                    if (function3 == null) break block1;
                    function3.invoke((Object)v, (Object)menuItem2, (Object)true);
                }
            }
        }));
        if (this.selectedItemId == menuItemDescriptor.getItemId()) {
            menuItem2.select();
        }
        return menuItem2;
    }

    private final void updateAccessibility() {
        List<MenuItem> items = this.getItems();
        Iterator<MenuItem> iterator = items.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            MenuItem item = iterator.next();
            Map map = this.itemsLookup;
            MenuItem menuItem2 = (MenuItem)CollectionsKt.getOrNull(items, (int)(i - 1));
            MenuItemImpl prev = (MenuItemImpl)map.get(menuItem2 != null ? Integer.valueOf(menuItem2.getId()) : null);
            Map map2 = this.itemsLookup;
            MenuItem menuItem3 = (MenuItem)CollectionsKt.getOrNull(items, (int)(i + 1));
            MenuItemImpl next = (MenuItemImpl)map2.get(menuItem3 != null ? Integer.valueOf(menuItem3.getId()) : null);
            MenuItemImpl menuItemImpl = this.itemsLookup.get(item.getId());
            if (menuItemImpl == null) continue;
            menuItemImpl.setAccessibleWith(prev, next);
        }
    }

    public static final /* synthetic */ void access$selectItemInternal(MenuImpl $this, MenuItem activeMenuItem) {
        $this.selectItemInternal(activeMenuItem);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgithub/com/st235/lib_expandablebottombar/MenuImpl$Companion;", "", "()V", "ITEM_NOT_SELECTED", "", "lib-expandablebottombar_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

