/*
 * Decompiled with CFR 0.152.
 */
package github.com.st235.lib_expandablebottombar;

import android.animation.Animator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Outline;
import android.graphics.Rect;
import android.os.Build;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import github.com.st235.lib_expandablebottombar.Menu;
import github.com.st235.lib_expandablebottombar.MenuImpl;
import github.com.st235.lib_expandablebottombar.MenuItem;
import github.com.st235.lib_expandablebottombar.MenuItemDescriptor;
import github.com.st235.lib_expandablebottombar.MenuItemFactory;
import github.com.st235.lib_expandablebottombar.R;
import github.com.st235.lib_expandablebottombar.behavior.ExpandableBottomBarBehavior;
import github.com.st235.lib_expandablebottombar.parsers.ExpandableBottomBarParser;
import github.com.st235.lib_expandablebottombar.state.BottomBarSavedState;
import github.com.st235.lib_expandablebottombar.utils.AnimationHelper;
import github.com.st235.lib_expandablebottombar.utils.DimensExtsKt;
import github.com.st235.lib_expandablebottombar.utils.DrawableHelper;
import github.com.st235.lib_expandablebottombar.utils.MathHelperKt;
import github.com.st235.lib_expandablebottombar.utils.StyleController;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002:\u0003OPQB%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010:\u001a\u00020+H\u0002J\f\u0010;\u001a\u0006\u0012\u0002\b\u00030<H\u0016J\b\u0010=\u001a\u00020\rH\u0002J\u0006\u0010>\u001a\u00020+J\b\u0010?\u001a\u00020+H\u0014J\u0012\u0010@\u001a\u00020+2\b\u0010A\u001a\u0004\u0018\u00010BH\u0014J\b\u0010C\u001a\u00020BH\u0014J(\u0010D\u001a\u00020+2\u0006\u0010E\u001a\u00020\b2\u0006\u0010F\u001a\u00020\b2\u0006\u0010G\u001a\u00020\b2\u0006\u0010H\u001a\u00020\bH\u0014J\u0012\u0010I\u001a\u00020+2\b\b\u0001\u0010J\u001a\u00020\bH\u0016J\u001a\u0010I\u001a\u00020+2\b\b\u0001\u0010J\u001a\u00020\b2\b\b\u0001\u0010\u000e\u001a\u00020\rJ\u0010\u0010K\u001a\u00020+2\b\b\u0001\u0010L\u001a\u00020\bJ\u001a\u0010K\u001a\u00020+2\b\b\u0001\u0010L\u001a\u00020\b2\b\b\u0001\u0010M\u001a\u00020\bJ\u0006\u0010N\u001a\u00020+R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8\u0002@BX\u0083\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u00be\u0001\u0010-\u001aO\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b((\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020+\u0018\u00010\"j\u0004\u0018\u0001`,2S\u0010\f\u001aO\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b((\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020+\u0018\u00010\"j\u0004\u0018\u0001`,8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u00be\u0001\u00102\u001aO\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b((\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020+\u0018\u00010\"j\u0004\u0018\u0001`,2S\u0010\f\u001aO\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b((\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020+\u0018\u00010\"j\u0004\u0018\u0001`,8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b3\u0010/\"\u0004\b4\u00101R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lgithub/com/st235/lib_expandablebottombar/ExpandableBottomBar;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "Landroidx/coordinatorlayout/widget/CoordinatorLayout$AttachedBehavior;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "animator", "Landroid/animation/Animator;", "value", "", "backgroundCornerRadius", "setBackgroundCornerRadius", "(F)V", "bounds", "Landroid/graphics/Rect;", "globalBadgeColor", "globalBadgeTextColor", "itemBackgroundCornerRadius", "itemBackgroundOpacity", "itemInactiveColor", "menu", "Lgithub/com/st235/lib_expandablebottombar/Menu;", "getMenu", "()Lgithub/com/st235/lib_expandablebottombar/Menu;", "menuHorizontalPadding", "menuImpl", "Lgithub/com/st235/lib_expandablebottombar/MenuImpl;", "menuItemHorizontalMargin", "menuItemVerticalMargin", "menuVerticalPadding", "Lkotlin/Function3;", "Landroid/view/View;", "Lkotlin/ParameterName;", "name", "v", "Lgithub/com/st235/lib_expandablebottombar/MenuItem;", "menuItem", "", "byUser", "", "Lgithub/com/st235/lib_expandablebottombar/OnItemClickListener;", "onItemReselectedListener", "getOnItemReselectedListener", "()Lkotlin/jvm/functions/Function3;", "setOnItemReselectedListener", "(Lkotlin/jvm/functions/Function3;)V", "onItemSelectedListener", "getOnItemSelectedListener", "setOnItemSelectedListener", "stateController", "Lgithub/com/st235/lib_expandablebottombar/ExpandableBottomBar$ExpandableBottomBarStateController;", "styleController", "Lgithub/com/st235/lib_expandablebottombar/utils/StyleController;", "transitionDuration", "cancelRunningAnimation", "getBehavior", "Landroidx/coordinatorlayout/widget/CoordinatorLayout$Behavior;", "getMaxScrollDistance", "hide", "onAttachedToWindow", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onSizeChanged", "w", "h", "oldw", "oldh", "setBackgroundColor", "color", "setBackgroundColorRes", "colorRes", "backgroundCornerRadiusRes", "show", "ExpandableBottomBarOutlineProvider", "ExpandableBottomBarStateController", "ItemStyle", "lib-expandablebottombar_release"})
public final class ExpandableBottomBar
extends ConstraintLayout
implements CoordinatorLayout.AttachedBehavior {
    @NotNull
    private final Rect bounds;
    @FloatRange(from=0.0, to=1.0)
    private final float itemBackgroundOpacity;
    @FloatRange(from=0.0)
    private final float itemBackgroundCornerRadius;
    @IntRange(from=0L)
    private final int menuItemHorizontalMargin;
    @IntRange(from=0L)
    private final int menuItemVerticalMargin;
    @IntRange(from=0L)
    private final int menuHorizontalPadding;
    @IntRange(from=0L)
    private final int menuVerticalPadding;
    @ColorInt
    private final int itemInactiveColor;
    @ColorInt
    private final int globalBadgeColor;
    @ColorInt
    private final int globalBadgeTextColor;
    private final int transitionDuration;
    @NotNull
    private final MenuImpl menuImpl;
    @NotNull
    private final StyleController styleController;
    @NotNull
    private final ExpandableBottomBarStateController stateController;
    @FloatRange(from=0.0)
    private float backgroundCornerRadius;
    @Nullable
    private Animator animator;

    @JvmOverloads
    public ExpandableBottomBar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.bounds = new Rect();
        this.stateController = new ExpandableBottomBarStateController(this);
        if (this.getId() == -1) {
            this.setId(View.generateViewId());
        }
        this.setContentDescription(this.getResources().getString(R.string.accessibility_description));
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ExpandableBottomBar, defStyleAttr, R.style.ExpandableBottomBar);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026ndableBottomBar\n        )");
        TypedArray typedArray2 = typedArray;
        this.itemBackgroundOpacity = typedArray2.getFloat(R.styleable.ExpandableBottomBar_exb_itemBackgroundOpacity, 0.2f);
        this.itemBackgroundCornerRadius = typedArray2.getDimension(R.styleable.ExpandableBottomBar_exb_itemBackgroundCornerRadius, DimensExtsKt.toPx(30.0f));
        this.transitionDuration = typedArray2.getInt(R.styleable.ExpandableBottomBar_exb_transitionDuration, 100);
        this.itemInactiveColor = typedArray2.getColor(R.styleable.ExpandableBottomBar_exb_itemInactiveColor, -16777216);
        this.menuItemHorizontalMargin = (int)typedArray2.getDimension(R.styleable.ExpandableBottomBar_exb_item_horizontal_margin, DimensExtsKt.toPx(5.0f));
        this.menuItemVerticalMargin = (int)typedArray2.getDimension(R.styleable.ExpandableBottomBar_exb_item_vertical_margin, DimensExtsKt.toPx(5.0f));
        this.menuHorizontalPadding = (int)typedArray2.getDimension(R.styleable.ExpandableBottomBar_exb_item_horizontal_padding, DimensExtsKt.toPx(15.0f));
        this.menuVerticalPadding = (int)typedArray2.getDimension(R.styleable.ExpandableBottomBar_exb_item_vertical_padding, DimensExtsKt.toPx(10.0f));
        this.globalBadgeColor = typedArray2.getColor(R.styleable.ExpandableBottomBar_exb_notificationBadgeBackgroundColor, -65536);
        this.globalBadgeTextColor = typedArray2.getColor(R.styleable.ExpandableBottomBar_exb_notificationBadgeTextColor, -1);
        int rawItemsStyle = typedArray2.getInt(R.styleable.ExpandableBottomBar_exb_itemStyle, 0);
        this.styleController = StyleController.Companion.create(ItemStyle.Companion.toItemStyle(rawItemsStyle));
        int backgroundColor = typedArray2.getColor(R.styleable.ExpandableBottomBar_exb_backgroundColor, -1);
        this.setBackgroundCornerRadius(typedArray2.getDimension(R.styleable.ExpandableBottomBar_exb_backgroundCornerRadius, 0.0f));
        this.setBackground(DrawableHelper.createShapeDrawable$default(DrawableHelper.INSTANCE, backgroundColor, false, false, this.backgroundCornerRadius, 1.0f, 6, null));
        boolean $i$f$applyForApiLAndHigher = false;
        if (Build.VERSION.SDK_INT >= 21) {
            boolean bl = false;
            this.setElevation(typedArray2.getDimension(R.styleable.ExpandableBottomBar_exb_elevation, DimensExtsKt.toPx(16.0f)));
            this.setOutlineProvider(new ExpandableBottomBarOutlineProvider());
            this.setClipToOutline(true);
        }
        MenuItemFactory menuItemFactory = new MenuItemFactory(this, this.styleController, this.menuVerticalPadding, this.menuHorizontalPadding, this.itemBackgroundCornerRadius, this.itemBackgroundOpacity, this.itemInactiveColor, this.globalBadgeColor, this.globalBadgeTextColor);
        this.menuImpl = new MenuImpl(this, menuItemFactory, this.menuItemHorizontalMargin, this.menuItemVerticalMargin, this.transitionDuration, null, 32, null);
        int menuId = typedArray2.getResourceId(R.styleable.ExpandableBottomBar_exb_items, -1);
        if (menuId != -1) {
            ExpandableBottomBarParser barParser = new ExpandableBottomBarParser(context);
            List<MenuItemDescriptor> items = barParser.inflate(menuId);
            for (MenuItemDescriptor item : items) {
                this.menuImpl.add(item);
            }
        }
        typedArray2.recycle();
    }

    public /* synthetic */ ExpandableBottomBar(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.exb_expandableButtonBarDefaultStyle;
        }
        this(context, attributeSet, n);
    }

    private final void setBackgroundCornerRadius(float value) {
        this.backgroundCornerRadius = value;
        boolean $i$f$applyForApiLAndHigher = false;
        if (Build.VERSION.SDK_INT >= 21) {
            boolean bl = false;
            this.invalidateOutline();
        }
    }

    @NotNull
    public final Menu getMenu() {
        return this.menuImpl;
    }

    @Nullable
    public final Function3<View, MenuItem, Boolean, Unit> getOnItemSelectedListener() {
        return this.getMenu().getOnItemSelectedListener();
    }

    public final void setOnItemSelectedListener(@Nullable Function3<? super View, ? super MenuItem, ? super Boolean, Unit> value) {
        this.getMenu().setOnItemSelectedListener(value);
    }

    @Nullable
    public final Function3<View, MenuItem, Boolean, Unit> getOnItemReselectedListener() {
        return this.getMenu().getOnItemReselectedListener();
    }

    public final void setOnItemReselectedListener(@Nullable Function3<? super View, ? super MenuItem, ? super Boolean, Unit> value) {
        this.getMenu().setOnItemReselectedListener(value);
    }

    @NotNull
    public CoordinatorLayout.Behavior<?> getBehavior() {
        return new ExpandableBottomBarBehavior();
    }

    public void setBackgroundColor(@ColorInt int color) {
        this.setBackgroundColor(color, this.backgroundCornerRadius);
    }

    public final void setBackgroundColor(@ColorInt int color, @FloatRange(from=0.0) float backgroundCornerRadius) {
        this.setBackgroundCornerRadius(backgroundCornerRadius);
        this.setBackground(DrawableHelper.createShapeDrawable$default(DrawableHelper.INSTANCE, color, false, false, backgroundCornerRadius, 1.0f, 6, null));
    }

    public final void setBackgroundColorRes(@ColorRes int colorRes) {
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)colorRes), this.backgroundCornerRadius);
    }

    public final void setBackgroundColorRes(@ColorRes int colorRes, @DimenRes int backgroundCornerRadiusRes) {
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)colorRes), this.getResources().getDimension(backgroundCornerRadiusRes));
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        if (lp instanceof CoordinatorLayout.LayoutParams) {
            ((CoordinatorLayout.LayoutParams)lp).insetEdge = 80;
        }
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return this.stateController.store(superState);
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        if (!(state instanceof BottomBarSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        super.onRestoreInstanceState(((BottomBarSavedState)state).getSuperState());
        this.stateController.restore((BottomBarSavedState)state);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.bounds.set(0, 0, w, h);
    }

    public final void show() {
        block0: {
            this.cancelRunningAnimation();
            Animator animator = this.animator = AnimationHelper.INSTANCE.translateViewTo((View)this, 0.0f);
            if (animator == null) break block0;
            animator.start();
        }
    }

    public final void hide() {
        block0: {
            this.cancelRunningAnimation();
            Animator animator = this.animator = AnimationHelper.INSTANCE.translateViewTo((View)this, this.getMaxScrollDistance());
            if (animator == null) break block0;
            animator.start();
        }
    }

    private final float getMaxScrollDistance() {
        int childHeight = ViewCompat.isLaidOut((View)((View)this)) ? this.getHeight() : this.getMeasuredHeight();
        float f = childHeight;
        View $this$marginBottom$iv = (View)this;
        boolean $i$f$getMarginBottom = false;
        ViewGroup.LayoutParams layoutParams = $this$marginBottom$iv.getLayoutParams();
        if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) {
            layoutParams = null;
        }
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
        return f + (float)(marginLayoutParams != null ? marginLayoutParams.bottomMargin : 0);
    }

    private final void cancelRunningAnimation() {
        Animator animator = this.animator;
        boolean bl = animator != null ? animator.isRunning() : false;
        if (bl) {
            Animator animator2 = this.animator;
            if (animator2 != null) {
                animator2.cancel();
            }
            this.animator = null;
        }
    }

    @JvmOverloads
    public ExpandableBottomBar(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ExpandableBottomBar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0080\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\t"}, d2={"Lgithub/com/st235/lib_expandablebottombar/ExpandableBottomBar$ItemStyle;", "", "id", "", "(Ljava/lang/String;II)V", "NORMAL", "OUTLINE", "STROKE", "Companion", "lib-expandablebottombar_release"})
    public static final class ItemStyle
    extends Enum<ItemStyle> {
        @NotNull
        public static final Companion Companion;
        private final int id;
        public static final /* enum */ ItemStyle NORMAL;
        public static final /* enum */ ItemStyle OUTLINE;
        public static final /* enum */ ItemStyle STROKE;
        private static final /* synthetic */ ItemStyle[] $VALUES;

        private ItemStyle(int id) {
            this.id = id;
        }

        public static ItemStyle[] values() {
            return (ItemStyle[])$VALUES.clone();
        }

        public static ItemStyle valueOf(String value) {
            return Enum.valueOf(ItemStyle.class, value);
        }

        static {
            NORMAL = new ItemStyle(0);
            OUTLINE = new ItemStyle(1);
            STROKE = new ItemStyle(2);
            $VALUES = itemStyleArray = new ItemStyle[]{ItemStyle.NORMAL, ItemStyle.OUTLINE, ItemStyle.STROKE};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lgithub/com/st235/lib_expandablebottombar/ExpandableBottomBar$ItemStyle$Companion;", "", "()V", "toItemStyle", "Lgithub/com/st235/lib_expandablebottombar/ExpandableBottomBar$ItemStyle;", "", "lib-expandablebottombar_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ItemStyle toItemStyle(int $this$toItemStyle) {
                ItemStyle itemStyle;
                block2: {
                    ItemStyle[] itemStyleArray = ItemStyle.values();
                    int n = itemStyleArray.length;
                    for (int i = 0; i < n; ++i) {
                        ItemStyle itemStyle2;
                        ItemStyle it = itemStyle2 = itemStyleArray[i];
                        boolean bl = false;
                        if (!(it.id == $this$toItemStyle)) continue;
                        itemStyle = itemStyle2;
                        break block2;
                    }
                    itemStyle = null;
                }
                if (itemStyle == null) {
                    throw new IllegalArgumentException("Cannot find style for id " + $this$toItemStyle);
                }
                return itemStyle;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nJ0\u0010\f\u001a\u00020\u0006*\u00020\r2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00060\u000fH\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgithub/com/st235/lib_expandablebottombar/ExpandableBottomBar$ExpandableBottomBarStateController;", "", "expandableBottomBar", "Lgithub/com/st235/lib_expandablebottombar/ExpandableBottomBar;", "(Lgithub/com/st235/lib_expandablebottombar/ExpandableBottomBar;)V", "restore", "", "stateBottomBar", "Lgithub/com/st235/lib_expandablebottombar/state/BottomBarSavedState;", "store", "Landroid/os/Parcelable;", "superState", "doSilently", "Lgithub/com/st235/lib_expandablebottombar/Menu;", "scope", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "menu", "lib-expandablebottombar_release"})
    public static final class ExpandableBottomBarStateController {
        @NotNull
        private final ExpandableBottomBar expandableBottomBar;

        public ExpandableBottomBarStateController(@NotNull ExpandableBottomBar expandableBottomBar) {
            Intrinsics.checkNotNullParameter((Object)((Object)expandableBottomBar), (String)"expandableBottomBar");
            this.expandableBottomBar = expandableBottomBar;
        }

        @NotNull
        public final Parcelable store(@Nullable Parcelable superState) {
            MenuItem selectedItem;
            MenuItem menuItem2 = selectedItem = this.expandableBottomBar.getMenu().getSelectedItem();
            return new BottomBarSavedState(menuItem2 != null ? Integer.valueOf(menuItem2.getId()) : null, superState);
        }

        public final void restore(@NotNull BottomBarSavedState stateBottomBar) {
            Intrinsics.checkNotNullParameter((Object)stateBottomBar, (String)"stateBottomBar");
            Integer selectedItemId = stateBottomBar.getSelectedItem();
            ExpandableBottomBarStateController expandableBottomBarStateController = this;
            Menu $this$doSilently$iv = this.expandableBottomBar.getMenu();
            boolean $i$f$doSilently = false;
            Function3<View, MenuItem, Boolean, Unit> selectedItemListener$iv = $this$doSilently$iv.getOnItemSelectedListener();
            Function3<View, MenuItem, Boolean, Unit> reselectedItemListener$iv = $this$doSilently$iv.getOnItemReselectedListener();
            $this$doSilently$iv.setOnItemSelectedListener(null);
            $this$doSilently$iv.setOnItemReselectedListener(null);
            Menu menu = $this$doSilently$iv;
            boolean bl = false;
            if (selectedItemId != null) {
                try {
                    menu.select(selectedItemId);
                }
                catch (IllegalArgumentException e) {
                    menu.deselect();
                }
            }
            $this$doSilently$iv.setOnItemSelectedListener(selectedItemListener$iv);
            $this$doSilently$iv.setOnItemReselectedListener(reselectedItemListener$iv);
        }

        private final void doSilently(Menu $this$doSilently, Function1<? super Menu, Unit> scope) {
            boolean $i$f$doSilently = false;
            Function3<View, MenuItem, Boolean, Unit> selectedItemListener = $this$doSilently.getOnItemSelectedListener();
            Function3<View, MenuItem, Boolean, Unit> reselectedItemListener = $this$doSilently.getOnItemReselectedListener();
            $this$doSilently.setOnItemSelectedListener(null);
            $this$doSilently.setOnItemReselectedListener(null);
            scope.invoke((Object)$this$doSilently);
            $this$doSilently.setOnItemSelectedListener(selectedItemListener);
            $this$doSilently.setOnItemReselectedListener(reselectedItemListener);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lgithub/com/st235/lib_expandablebottombar/ExpandableBottomBar$ExpandableBottomBarOutlineProvider;", "Landroid/view/ViewOutlineProvider;", "(Lgithub/com/st235/lib_expandablebottombar/ExpandableBottomBar;)V", "getOutline", "", "view", "Landroid/view/View;", "outline", "Landroid/graphics/Outline;", "lib-expandablebottombar_release"})
    @TargetApi(value=21)
    private final class ExpandableBottomBarOutlineProvider
    extends ViewOutlineProvider {
        public void getOutline(@Nullable View view, @Nullable Outline outline) {
            block0: {
                Outline outline2 = outline;
                if (outline2 == null) break block0;
                outline2.setRoundRect(ExpandableBottomBar.this.bounds, ((Number)((Object)MathHelperKt.clamp((Comparable)Float.valueOf(ExpandableBottomBar.this.backgroundCornerRadius), (Comparable)Float.valueOf(0.0f), (Comparable)Float.valueOf(((Number)((Object)MathHelperKt.min(ExpandableBottomBar.this.getHeight(), ExpandableBottomBar.this.getWidth()))).floatValue() / 2.0f)))).floatValue());
            }
        }
    }
}

