/*
 * Decompiled with CFR 0.152.
 */
package net.iryndin.jdbf.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class IOUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream input) throws IOException {
        try {
            int count;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((count = input.read(buffer)) > 0) {
                baos.write(buffer, 0, count);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            input.close();
        }
    }

    public static int readFully(InputStream in, byte[] bs) throws IOException {
        return IOUtils.readFully(in, bs, 0, bs.length);
    }

    public static int readFully(InputStream in, byte[] bs, int offset, int len) throws IOException {
        int ret;
        int byteCount = in.read(bs, offset, len);
        if (byteCount <= -1) {
            return 0;
        }
        while (byteCount < len && (ret = in.read(bs, offset + byteCount, len - byteCount)) != -1) {
            byteCount += ret;
        }
        return byteCount;
    }
}

