/*
 * Decompiled with CFR 0.152.
 */
package net.iryndin.jdbf.core;

import java.nio.charset.Charset;
import net.iryndin.jdbf.core.MemoRecordTypeEnum;
import net.iryndin.jdbf.util.BitUtils;

public class MemoRecord {
    private final int blockSize;
    private final int offsetInBlocks;
    private byte[] value;
    private int length;
    private MemoRecordTypeEnum memoType;

    public MemoRecord(byte[] header, byte[] value, int blockSize, int offsetInBlocks) {
        this.value = value;
        this.calculateFields(header);
        this.blockSize = blockSize;
        this.offsetInBlocks = offsetInBlocks;
    }

    private void calculateFields(byte[] bytes) {
        int type = BitUtils.makeInt(bytes[3], bytes[2], bytes[1], bytes[0]);
        this.memoType = MemoRecordTypeEnum.fromInt(type);
        this.length = BitUtils.makeInt(bytes[7], bytes[6], bytes[5], bytes[4]);
    }

    public byte[] getValue() {
        return this.value;
    }

    public String getValueAsString(Charset charset) {
        return new String(this.value, charset);
    }

    public int getLength() {
        return this.length;
    }

    public MemoRecordTypeEnum getMemoType() {
        return this.memoType;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getOffsetInBlocks() {
        return this.offsetInBlocks;
    }
}

