/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.reflect;

import com.github.mustachejava.Binding;
import com.github.mustachejava.Code;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.reflect.BaseObjectHandler;
import com.github.mustachejava.util.GuardException;
import com.github.mustachejava.util.Wrapper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleObjectHandler
extends BaseObjectHandler {
    private Map<WrapperKey, AccessibleObject> cache = new ConcurrentHashMap<WrapperKey, AccessibleObject>();
    private static AccessibleObject NONE;

    @Override
    public Binding createBinding(final String name, TemplateContext tc, Code code) {
        return new Binding(){
            private Wrapper wrapper;
            {
                this.wrapper = SimpleObjectHandler.this.find(name, null);
            }

            @Override
            public Object get(Object[] scopes) {
                return this.wrapper.call(scopes);
            }
        };
    }

    @Override
    public Wrapper find(final String name, Object[] scopes) {
        return new Wrapper(){

            @Override
            public Object call(Object[] scopes) throws GuardException {
                for (int i = scopes.length - 1; i >= 0; --i) {
                    Object scope = scopes[i];
                    if (scope == null) continue;
                    int index = name.indexOf(".");
                    if (index == -1) {
                        Map map;
                        if (scope instanceof Map && (map = (Map)scope).containsKey(name)) {
                            return map.get(name);
                        }
                        try {
                            AccessibleObject ao = SimpleObjectHandler.this.lookup(scope.getClass(), name);
                            if (ao instanceof Method) {
                                return ((Method)ao).invoke(scope, new Object[0]);
                            }
                            if (!(ao instanceof Field)) continue;
                            return ((Field)ao).get(scope);
                        }
                        catch (InvocationTargetException ie) {
                            throw new MustacheException("Failed to get " + name + " from " + scope.getClass(), ie);
                        }
                        catch (IllegalAccessException iae) {
                            throw new MustacheException("Set accessible failed to get " + name + " from " + scope.getClass(), iae);
                        }
                    }
                    Object[] subscope = new Object[]{scope};
                    Wrapper wrapper = SimpleObjectHandler.this.find(name.substring(0, index), subscope);
                    if (wrapper == null) continue;
                    scope = wrapper.call(subscope);
                    subscope = new Object[]{scope};
                    return SimpleObjectHandler.this.find(name.substring(index + 1), new Object[]{subscope}).call(subscope);
                }
                return null;
            }
        };
    }

    private AccessibleObject lookup(Class sClass, String name) {
        WrapperKey key = new WrapperKey(sClass, name);
        AccessibleObject ao = this.cache.get(key);
        if (ao == null) {
            ao = this.findMember(sClass, name);
            this.cache.put(key, ao == null ? NONE : ao);
        }
        return ao == NONE ? null : ao;
    }

    static {
        try {
            NONE = SimpleObjectHandler.class.getDeclaredField("NONE");
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)("Failed to init: " + e));
        }
    }

    private static class WrapperKey {
        private final Class aClass;
        private final String name;
        private int hashcode;

        WrapperKey(Class aClass, String name) {
            this.aClass = aClass;
            this.name = name;
            this.hashcode = aClass.hashCode() + 43 * name.hashCode();
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WrapperKey) {
                WrapperKey oKey = (WrapperKey)obj;
                return this.aClass.equals(oKey.aClass) && this.name.equals(oKey.name);
            }
            return false;
        }
    }
}

