/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.reflect;

import com.github.mustachejava.Iteration;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.reflect.ClassGuard;
import com.github.mustachejava.reflect.DepthGuard;
import com.github.mustachejava.reflect.DotGuard;
import com.github.mustachejava.reflect.MapGuard;
import com.github.mustachejava.reflect.MissingWrapper;
import com.github.mustachejava.reflect.ReflectionWrapper;
import com.github.mustachejava.util.GuardException;
import com.github.mustachejava.util.Wrapper;
import com.google.common.base.Predicate;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReflectionObjectHandler
implements ObjectHandler {
    protected static final Method MAP_METHOD;

    @Override
    public Wrapper find(String name, Object[] scopes) {
        Wrapper wrapper = null;
        int length = scopes.length;
        ArrayList<Predicate<Object[]>> guards = new ArrayList<Predicate<Object[]>>(scopes.length);
        guards.add(new DepthGuard(length));
        block2: for (int i = length - 1; i >= 0; --i) {
            int dotIndex;
            Object scope = scopes[i];
            if (scope == null) continue;
            ClassGuard guard = new ClassGuard(i, scope);
            guards.add(guard);
            ArrayList<Wrapper> wrappers = null;
            String subname = name;
            while ((dotIndex = subname.indexOf(46)) != -1) {
                String lookup = subname.substring(0, dotIndex);
                subname = subname.substring(dotIndex + 1);
                guards.add(new DotGuard(lookup, i, scope));
                ArrayList<Predicate<Object[]>> wrapperGuard = new ArrayList<Predicate<Object[]>>(1);
                wrapperGuard.add(new ClassGuard(0, scope));
                wrapper = this.findWrapper(0, null, wrapperGuard, scope, lookup);
                if (wrapper == null) continue block2;
                if (wrappers == null) {
                    wrappers = new ArrayList<Wrapper>();
                }
                wrappers.add(wrapper);
                try {
                    scope = wrapper.call(new Object[]{scope});
                }
                catch (GuardException e) {
                    throw new AssertionError((Object)e);
                }
                if (scope != null) continue;
                wrapper = null;
                break block2;
            }
            Wrapper[] foundWrappers = wrappers == null ? null : wrappers.toArray(new Wrapper[wrappers.size()]);
            Wrapper foundWrapper = this.findWrapper(i, foundWrappers, guards, scope, subname);
            if (foundWrapper == null) continue;
            wrapper = foundWrapper;
            break;
        }
        return wrapper == null ? new MissingWrapper(guards.toArray(new Predicate[guards.size()])) : wrapper;
    }

    @Override
    public Object coerce(Object object) {
        return object;
    }

    protected Wrapper findWrapper(int scopeIndex, Wrapper[] wrappers, List<Predicate<Object[]>> guards, Object scope, String name) {
        if ((scope = this.coerce(scope)) == null) {
            return null;
        }
        if (scope instanceof Map) {
            Map map = (Map)scope;
            if (!map.containsKey(name)) {
                guards.add(new MapGuard(scopeIndex, name, false, wrappers));
                return null;
            }
            guards.add(new MapGuard(scopeIndex, name, true, wrappers));
            return this.createWrapper(scopeIndex, wrappers, guards, MAP_METHOD, new Object[]{name});
        }
        Class<?> aClass = scope.getClass();
        Wrapper member = null;
        try {
            member = this.getField(scopeIndex, wrappers, guards, name, aClass);
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        if (member == null) {
            try {
                member = this.getMethod(scopeIndex, wrappers, guards, name, aClass, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                String propertyname = name.substring(0, 1).toUpperCase() + (name.length() > 1 ? name.substring(1) : "");
                try {
                    member = this.getMethod(scopeIndex, wrappers, guards, "get" + propertyname, aClass, new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    try {
                        member = this.getMethod(scopeIndex, wrappers, guards, "is" + propertyname, aClass, new Class[0]);
                    }
                    catch (NoSuchMethodException e3) {
                        // empty catch block
                    }
                }
            }
        }
        return member;
    }

    protected Wrapper getMethod(int scopeIndex, Wrapper[] wrappers, List<? extends Predicate<Object[]>> guard, String name, Class aClass, Class ... params) throws NoSuchMethodException {
        Method member;
        try {
            member = aClass.getDeclaredMethod(name, params);
        }
        catch (NoSuchMethodException nsme) {
            Class superclass = aClass.getSuperclass();
            if (superclass != null && superclass != Object.class) {
                return this.getMethod(scopeIndex, wrappers, guard, name, superclass, params);
            }
            throw nsme;
        }
        this.checkMethod(member);
        member.setAccessible(true);
        return this.createWrapper(scopeIndex, wrappers, guard, member, null);
    }

    protected void checkMethod(Method member) throws NoSuchMethodException {
        if ((member.getModifiers() & 2) == 2) {
            throw new NoSuchMethodException("Only public, protected and package members allowed");
        }
    }

    protected Wrapper getField(int scopeIndex, Wrapper[] wrappers, List<? extends Predicate<Object[]>> guard, String name, Class aClass) throws NoSuchFieldException {
        Field member;
        try {
            member = aClass.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            Class superclass = aClass.getSuperclass();
            if (superclass != null && superclass != Object.class) {
                return this.getField(scopeIndex, wrappers, guard, name, superclass);
            }
            throw nsfe;
        }
        this.checkField(member);
        member.setAccessible(true);
        return this.createWrapper(scopeIndex, wrappers, guard, member, null);
    }

    protected void checkField(Field member) throws NoSuchFieldException {
        if ((member.getModifiers() & 2) == 2) {
            throw new NoSuchFieldException("Only public, protected and package members allowed");
        }
    }

    protected Wrapper createWrapper(int scopeIndex, Wrapper[] wrappers, List<? extends Predicate<Object[]>> guard, AccessibleObject member, Object[] arguments) {
        return new ReflectionWrapper(scopeIndex, wrappers, guard.toArray(new Predicate[guard.size()]), member, arguments, this);
    }

    @Override
    public Writer falsey(Iteration iteration, Writer writer, Object object, Object[] scopes) {
        if (object != null) {
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    return writer;
                }
            } else if (object instanceof String) {
                if (!object.toString().equals("")) {
                    return writer;
                }
            } else if (object instanceof List) {
                List list = (List)object;
                int length = list.size();
                if (length > 0) {
                    return writer;
                }
            } else if (object instanceof Iterable) {
                Iterable iterable = (Iterable)object;
                if (iterable.iterator().hasNext()) {
                    return writer;
                }
            } else if (object instanceof Iterator) {
                Iterator iterator = (Iterator)object;
                if (iterator.hasNext()) {
                    return writer;
                }
            } else if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                int length = array.length;
                if (length > 0) {
                    return writer;
                }
            } else {
                return writer;
            }
        }
        return iteration.next(writer, object, scopes);
    }

    @Override
    public Writer iterate(Iteration iteration, Writer writer, Object object, Object[] scopes) {
        if (object == null) {
            return writer;
        }
        if (object instanceof Boolean && !((Boolean)object).booleanValue()) {
            return writer;
        }
        if (object instanceof String && object.toString().equals("")) {
            return writer;
        }
        if (object instanceof Iterable) {
            for (Object next : (Iterable)object) {
                writer = iteration.next(writer, this.coerce(next), scopes);
            }
        } else if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                writer = iteration.next(writer, this.coerce(iterator.next()), scopes);
            }
        } else if (object instanceof Object[]) {
            Object[] array;
            for (Object o : array = (Object[])object) {
                writer = iteration.next(writer, this.coerce(o), scopes);
            }
        } else {
            writer = iteration.next(writer, object, scopes);
        }
        return writer;
    }

    static {
        try {
            MAP_METHOD = Map.class.getMethod("get", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

