/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.codes;

import com.github.mustachejava.Code;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheFactory;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.ExtendNameCode;
import com.github.mustachejava.codes.PartialCode;
import com.github.mustachejava.codes.WriteCode;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class ExtendCode
extends PartialCode {
    private MustacheFactory mf;

    public ExtendCode(TemplateContext tc, DefaultMustacheFactory mf, Mustache codes, String name) throws MustacheException {
        super(tc, mf, codes, "<", name);
        this.mf = mf;
    }

    private Code[] replaceCodes(Code[] supercodes, Map<String, ExtendNameCode> replaceMap) {
        Code[] newcodes = (Code[])supercodes.clone();
        for (int i = 0; i < supercodes.length; ++i) {
            Code code = supercodes[i];
            if (code instanceof ExtendNameCode) {
                ExtendNameCode enc = (ExtendNameCode)code;
                ExtendNameCode extendReplaceCode = replaceMap.get(enc.getName());
                if (extendReplaceCode != null) {
                    newcodes[i] = extendReplaceCode;
                    extendReplaceCode.appended = enc.appended;
                    continue;
                }
                enc.setCodes(this.replaceCodes(enc.getCodes(), replaceMap));
                continue;
            }
            Code[] codes = code.getCodes();
            if (codes == null) continue;
            code.setCodes(this.replaceCodes(codes, replaceMap));
        }
        return newcodes;
    }

    @Override
    public Writer execute(Writer writer, Object[] scopes) throws MustacheException {
        return this.partialExecute(writer, scopes);
    }

    @Override
    public synchronized void init() {
        HashMap<String, ExtendNameCode> replaceMap = new HashMap<String, ExtendNameCode>();
        for (Code code : this.mustache.getCodes()) {
            if (code instanceof ExtendNameCode) {
                ExtendNameCode erc = (ExtendNameCode)code;
                replaceMap.put(erc.getName(), erc);
                erc.init();
                continue;
            }
            if (code instanceof WriteCode) continue;
            throw new IllegalArgumentException("Illegal code in extend section: " + code.getClass().getName());
        }
        this.partial = this.mf.compile(this.name + this.extension);
        Code[] supercodes = this.partial.getCodes();
        this.partial.setCodes(this.replaceCodes(supercodes, replaceMap));
    }
}

